/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.Weighted;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.Registration;
import java.util.ArrayList;
import java.util.List;

class HttpRoutingFeature
implements HttpFeature,
Weighted {
    private final List<Registration> registrations = new ArrayList<Registration>();

    HttpRoutingFeature() {
    }

    @Override
    public void setup(HttpRouting.Builder routing) {
        this.registrations.forEach(it -> it.register(routing));
    }

    void filter(Filter filter) {
        this.registrations.add(Registration.create(filter));
    }

    <T extends Throwable> void error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
        this.registrations.add(Registration.create(exceptionClass, handler));
    }

    void service(HttpService ... services) {
        this.registrations.add(Registration.create(services));
    }

    void service(String path, HttpService ... services) {
        this.registrations.add(Registration.create(path, services));
    }

    void route(HttpRoute route) {
        this.registrations.add(Registration.create(route));
    }

    void copyFrom(HttpRoutingFeature mainRouting) {
        this.registrations.addAll(mainRouting.registrations);
    }
}

