/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ServerLifecycle;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRouteBase;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.RouteCrawler;
import io.helidon.webserver.http.RoutingRequest;
import java.util.List;
import java.util.function.Predicate;

class ServiceRoute
extends HttpRouteBase
implements HttpRoute {
    private final HttpService theService;
    private final Predicate<Method> methodPredicate;
    private final PathMatcher pathMatcher;
    private final List<HttpRouteBase> routes;

    ServiceRoute(HttpService theService, Predicate<Method> methodPredicate, PathMatcher pathMatcher, List<HttpRouteBase> routes) {
        this.theService = theService;
        this.methodPredicate = methodPredicate;
        this.pathMatcher = pathMatcher;
        this.routes = routes;
    }

    @Override
    public void beforeStart() {
        this.theService.beforeStart();
        this.routes.forEach(ServerLifecycle::beforeStart);
    }

    @Override
    public void afterStart(WebServer webServer) {
        this.theService.afterStart(webServer);
        this.routes.forEach(r -> r.afterStart(webServer));
    }

    @Override
    public void afterStop() {
        this.theService.afterStop();
        this.routes.forEach(ServerLifecycle::afterStop);
    }

    @Override
    public PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        throw new IllegalStateException("List routes must use acceptsPrefix");
    }

    @Override
    public Handler handler() {
        throw new IllegalStateException("Service routing cannot provide a handler, use list of routes");
    }

    public String toString() {
        return String.valueOf(this.methodPredicate) + " (" + String.valueOf(this.pathMatcher) + ") with " + this.routes.size() + " routes, service: " + String.valueOf(this.theService);
    }

    @Override
    PathMatchers.PrefixMatchResult acceptsPrefix(HttpPrologue prologue) {
        if (!this.methodPredicate.test(prologue.method())) {
            return PathMatchers.PrefixMatchResult.notAccepted();
        }
        return this.pathMatcher.prefixMatch(prologue.uriPath());
    }

    @Override
    List<HttpRouteBase> routes() {
        return this.routes;
    }

    @Override
    boolean isList() {
        return true;
    }

    RouteCrawler crawler(ConnectionContext ctx, RoutingRequest request) {
        return new RouteCrawler(ctx, request, this.routes);
    }
}

