/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.GenericType;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.DateTime;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpException;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.ServerResponseTrailers;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaContext;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ServerConnectionException;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.http.ServerResponseBase;
import io.helidon.webserver.http.spi.Sink;
import io.helidon.webserver.http.spi.SinkProvider;
import io.helidon.webserver.http.spi.SinkProviderContext;
import io.helidon.webserver.http1.Http1ConnectionListener;
import io.helidon.webserver.http1.Http1ServerRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

class Http1ServerResponse
extends ServerResponseBase<Http1ServerResponse> {
    private static final System.Logger LOGGER = System.getLogger(Http1ServerResponse.class.getName());
    private static final byte[] HTTP_BYTES = "HTTP/1.1 ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] OK_200 = "HTTP/1.1 200 OK\r\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATE = "Date: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TERMINATING_CHUNK = "0\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TERMINATING_CHUNK_TRAILERS = "0\r\n".getBytes(StandardCharsets.UTF_8);
    private static final List<SinkProvider> SINK_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(SinkProvider.class)).build().asList();
    private static final WritableHeaders<?> EMPTY_HEADERS = WritableHeaders.create();
    private final ConnectionContext ctx;
    private final Http1ConnectionListener sendListener;
    private final DataWriter dataWriter;
    private final Http1ServerRequest request;
    private final ServerResponseHeaders headers;
    private final ServerResponseTrailers trailers;
    private final boolean keepAlive;
    private boolean streamingEntity;
    private boolean isSent;
    private ClosingBufferedOutputStream outputStream;
    private long bytesWritten;
    private String streamResult = "";
    private boolean isNoEntityStatus;
    private final boolean validateHeaders;
    private UnaryOperator<OutputStream> outputStreamFilter;

    Http1ServerResponse(ConnectionContext ctx, Http1ConnectionListener sendListener, DataWriter dataWriter, Http1ServerRequest request, boolean keepAlive, boolean validateHeaders) {
        super(ctx, request);
        this.ctx = ctx;
        this.sendListener = sendListener;
        this.dataWriter = dataWriter;
        this.request = request;
        this.headers = ServerResponseHeaders.create();
        this.trailers = ServerResponseTrailers.create();
        this.keepAlive = keepAlive;
        this.validateHeaders = validateHeaders;
    }

    static void nonEntityBytes(ServerResponseHeaders headers, Status status, BufferData buffer, boolean keepAlive, boolean validateHeaders) {
        Status status2 = status = status == null ? Status.OK_200 : status;
        if (Http1ServerResponse.isNoEntityStatus(status) && (headers.contains(HeaderNames.CONTENT_LENGTH) && !headers.contains(HeaderValues.CONTENT_LENGTH_ZERO) || headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED))) {
            status = Http1ServerResponse.noEntityInternalError(status);
        }
        if (status == Status.OK_200) {
            buffer.write(OK_200);
        } else {
            buffer.write(HTTP_BYTES);
            String reasonPhrase = status.reasonPhrase() == null || status.reasonPhrase().isEmpty() ? status.codeText() : status.reasonPhrase();
            buffer.write((status.code() + " " + reasonPhrase).getBytes(StandardCharsets.US_ASCII));
            buffer.write(13);
            buffer.write(10);
        }
        if (!headers.contains(HeaderNames.DATE)) {
            buffer.write(DATE);
            byte[] dateBytes = DateTime.http1Bytes();
            buffer.write(dateBytes);
        }
        if (keepAlive) {
            headers.setIfAbsent(HeaderValues.CONNECTION_KEEP_ALIVE);
        } else {
            headers.set(HeaderValues.CONNECTION_CLOSE);
        }
        Http1ServerResponse.writeHeaders((Headers)headers, buffer, validateHeaders);
        buffer.write(13);
        buffer.write(10);
    }

    @Override
    public Http1ServerResponse status(Status status) {
        super.status(status);
        this.isNoEntityStatus = Http1ServerResponse.isNoEntityStatus(status);
        if (this.isNoEntityStatus) {
            if (!this.headers.contains(HeaderNames.CONTENT_LENGTH)) {
                this.headers.set(HeaderValues.CONTENT_LENGTH_ZERO);
            } else if (this.headers.get(HeaderNames.CONTENT_LENGTH).getLong() > 0L) {
                throw new IllegalStateException("Cannot set status to " + String.valueOf(status) + " with header " + String.valueOf(HeaderNames.CONTENT_LENGTH) + " greater than zero");
            }
        }
        return this;
    }

    @Override
    public Http1ServerResponse header(Header header) {
        if (this.streamingEntity) {
            throw new IllegalStateException("Cannot set response header after requesting output stream.");
        }
        if (this.isSent()) {
            throw new IllegalStateException("Cannot set response header after response was already sent.");
        }
        this.headers.set(header);
        return this;
    }

    @Override
    public void send(byte[] bytes) {
        this.send(bytes, 0, bytes.length);
    }

    @Override
    public void send(byte[] bytes, int position, int length) {
        if (this.isNoEntityStatus && length > 0) {
            this.status(Http1ServerResponse.noEntityInternalError(this.status()));
            return;
        }
        if (this.outputStreamFilter == null && !this.headers.contains(HeaderNames.TRAILER)) {
            byte[] entity = this.entityBytes(bytes, position, length);
            BufferData bufferData = bytes != entity ? this.responseBuffer(entity) : this.responseBuffer(entity, position, length);
            this.bytesWritten = bufferData.available();
            this.isSent = true;
            this.request.reset();
            this.dataWriter.write(bufferData);
            this.afterSend();
        } else {
            boolean skipEncoders = length == 0;
            try (OutputStream os = this.outputStream(skipEncoders);){
                os.write(bytes, position, length);
            }
            catch (IOException e) {
                throw new ServerConnectionException("Failed to write response", e);
            }
        }
    }

    @Override
    public boolean isSent() {
        return this.isSent;
    }

    @Override
    public OutputStream outputStream() {
        return this.outputStream(false);
    }

    @Override
    public long bytesWritten() {
        if (this.streamingEntity) {
            return this.outputStream.totalBytesWritten();
        }
        return this.bytesWritten;
    }

    @Override
    public ServerResponseHeaders headers() {
        return this.headers;
    }

    @Override
    public ServerResponseTrailers trailers() {
        if (this.request.headers().contains(HeaderValues.TE_TRAILERS) || this.headers.contains(HeaderNames.TRAILER)) {
            return this.trailers;
        }
        throw new IllegalStateException("Trailers are supported only when request came with 'TE: trailers' header or response headers have trailer names definition 'Trailer: <trailer-name>'");
    }

    @Override
    public void streamResult(String result) {
        this.streamResult = result;
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public boolean hasEntity() {
        return this.isSent || this.streamingEntity;
    }

    @Override
    public boolean reset() {
        if (this.isSent || this.outputStream != null && this.outputStream.totalBytesWritten() > 0L) {
            return false;
        }
        this.headers.clear();
        this.streamingEntity = false;
        this.outputStream = null;
        return true;
    }

    @Override
    public void commit() {
        if (this.outputStream != null) {
            this.outputStream.commit();
        }
    }

    public <X extends Sink<?>> X sink(GenericType<X> sinkType) {
        for (SinkProvider p : SINK_PROVIDERS) {
            if (!p.supports(sinkType, this.request)) continue;
            try {
                return p.create(new SinkProviderContext(){

                    @Override
                    public ServerResponse serverResponse() {
                        return Http1ServerResponse.this;
                    }

                    @Override
                    public ConnectionContext connectionContext() {
                        return Http1ServerResponse.this.ctx;
                    }

                    @Override
                    public Runnable closeRunnable() {
                        return () -> {
                            Http1ServerResponse.this.isSent = true;
                            Http1ServerResponse.this.afterSend();
                            Http1ServerResponse.this.request.reset();
                        };
                    }
                });
            }
            catch (UnsupportedOperationException e) {
                return p.create(this, this::handleSinkData, this::commit);
            }
        }
        throw new HttpException("Unable to find sink provider for request", Status.NOT_ACCEPTABLE_406);
    }

    @Override
    public void streamFilter(UnaryOperator<OutputStream> filterFunction) {
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("OutputStream already obtained");
        }
        Objects.requireNonNull(filterFunction);
        UnaryOperator<OutputStream> current = this.outputStreamFilter;
        this.outputStreamFilter = current == null ? filterFunction : it -> (OutputStream)filterFunction.apply((OutputStream)current.apply((OutputStream)it));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSinkData(Object data, MediaType mediaType) {
        if (this.outputStream == null) {
            this.outputStream();
        }
        try {
            MediaContext mediaContext = this.mediaContext();
            if (data instanceof byte[]) {
                byte[] bytes = (byte[])data;
                this.outputStream.write(bytes);
                return;
            }
            if (data instanceof String) {
                String str = (String)data;
                if (mediaType.equals((Object)MediaTypes.TEXT_PLAIN)) {
                    EntityWriter writer = mediaContext.writer(GenericType.STRING, EMPTY_HEADERS, EMPTY_HEADERS);
                    writer.write(GenericType.STRING, (Object)str, (OutputStream)this.outputStream, EMPTY_HEADERS, EMPTY_HEADERS);
                    return;
                }
            }
            GenericType type = GenericType.create((Object)data);
            WritableHeaders resHeaders = WritableHeaders.create();
            resHeaders.set(HeaderNames.CONTENT_TYPE, new String[]{mediaType.text()});
            EntityWriter writer = mediaContext.writer(type, EMPTY_HEADERS, resHeaders);
            writer.write(type, data, (OutputStream)this.outputStream, EMPTY_HEADERS, resHeaders);
            return;
        }
        catch (IOException e) {
            throw new ServerConnectionException("Failed to write sink data", e);
        }
    }

    private static void writeHeaders(Headers headers, BufferData buffer, boolean validate) {
        if (validate) {
            headers.forEach(Header::validate);
        }
        for (Header header : headers) {
            header.writeHttp1Header(buffer);
        }
    }

    private BufferData responseBuffer(byte[] bytes) {
        return this.responseBuffer(bytes, 0, bytes.length);
    }

    private BufferData responseBuffer(byte[] bytes, int position, int length) {
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("When output stream is used, response is completed by closing the output stream, do not call send().");
        }
        boolean forcedChunkedEncoding = false;
        this.headers.setIfAbsent(HeaderValues.CONNECTION_KEEP_ALIVE);
        if (this.headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED)) {
            this.headers.remove(HeaderNames.CONTENT_LENGTH);
            forcedChunkedEncoding = true;
        } else if (!this.headers.contains(HeaderNames.CONTENT_LENGTH)) {
            this.headers.contentLength((long)length);
        }
        Status usedStatus = this.status();
        this.sendListener.status(this.ctx, usedStatus);
        this.sendListener.headers(this.ctx, (Headers)this.headers);
        BufferData responseBuffer = BufferData.growing((int)(256 + length));
        Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, responseBuffer, this.keepAlive, this.validateHeaders);
        if (forcedChunkedEncoding) {
            byte[] hex = Integer.toHexString(length).getBytes(StandardCharsets.US_ASCII);
            responseBuffer.write(hex);
            responseBuffer.write(13);
            responseBuffer.write(10);
            responseBuffer.write(bytes, position, length);
            responseBuffer.write(13);
            responseBuffer.write(10);
            responseBuffer.write(TERMINATING_CHUNK);
        } else {
            responseBuffer.write(bytes, position, length);
        }
        this.sendListener.data(this.ctx, responseBuffer);
        return responseBuffer;
    }

    private OutputStream outputStream(boolean skipEncoders) {
        if (this.isSent) {
            throw new IllegalStateException("Response already sent");
        }
        if (this.streamingEntity) {
            throw new IllegalStateException("OutputStream already obtained");
        }
        this.streamingEntity = true;
        BlockingOutputStream bos = new BlockingOutputStream(this.headers, (WritableHeaders<?>)this.trailers, this::status, () -> this.streamResult, this.dataWriter, () -> {
            this.isSent = true;
            this.afterSend();
            this.request.reset();
        }, this.ctx, this.sendListener, this.request, this.keepAlive, this.validateHeaders, this.isNoEntityStatus);
        int writeBufferSize = this.ctx.listenerContext().config().writeBufferSize();
        OutputStream encodedOutputStream = this.outputStream = new ClosingBufferedOutputStream(bos, writeBufferSize);
        if (!skipEncoders) {
            encodedOutputStream = this.contentEncode(this.outputStream);
            bos.checkResponseHeaders();
        }
        return this.outputStreamFilter == null ? encodedOutputStream : (OutputStream)this.outputStreamFilter.apply(encodedOutputStream);
    }

    private static Status noEntityInternalError(Status status) {
        LOGGER.log(System.Logger.Level.ERROR, "Attempt to send status " + status.text() + " with entity. Server responded with Internal Server Error. Please fix your routing, this is not allowed by HTTP specification, such responses MUST NOT contain an entity.");
        return Status.INTERNAL_SERVER_ERROR_500;
    }

    private static boolean isNoEntityStatus(Status status) {
        int code = status.code();
        return code == Status.NO_CONTENT_204.code() || code == Status.RESET_CONTENT_205.code() || code == Status.NOT_MODIFIED_304.code();
    }

    static class ClosingBufferedOutputStream
    extends OutputStream {
        private final BlockingOutputStream closingDelegate;
        private final OutputStream delegate;

        ClosingBufferedOutputStream(BlockingOutputStream out, int size) {
            this.closingDelegate = out;
            this.delegate = size <= 0 ? out : new BufferedOutputStream(out, size);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() {
            this.closingDelegate.closing();
            try {
                this.delegate.close();
            }
            catch (IOException | UncheckedIOException e) {
                throw new ServerConnectionException("Failed to close server output stream", e);
            }
        }

        long totalBytesWritten() {
            return this.closingDelegate.totalBytesWritten();
        }

        void commit() {
            try {
                this.flush();
                this.closingDelegate.commit();
            }
            catch (IOException | UncheckedIOException e) {
                throw new ServerConnectionException("Failed to flush server output stream", e);
            }
        }
    }

    static class BlockingOutputStream
    extends OutputStream {
        private final ServerResponseHeaders headers;
        private final WritableHeaders<?> trailers;
        private final Supplier<Status> status;
        private final DataWriter dataWriter;
        private final Runnable responseCloseRunnable;
        private final ConnectionContext ctx;
        private final Http1ConnectionListener sendListener;
        private final Http1ServerRequest request;
        private final boolean keepAlive;
        private final Supplier<String> streamResult;
        private boolean forcedChunked;
        private BufferData firstBuffer;
        private boolean closed;
        private long bytesWritten;
        private long contentLength;
        private boolean isChunked;
        private boolean firstByte = true;
        private long responseBytesTotal;
        private boolean closing = false;
        private final boolean validateHeaders;
        private final boolean isNoEntityStatus;

        private BlockingOutputStream(ServerResponseHeaders headers, WritableHeaders<?> trailers, Supplier<Status> status, Supplier<String> streamResult, DataWriter dataWriter, Runnable responseCloseRunnable, ConnectionContext ctx, Http1ConnectionListener sendListener, Http1ServerRequest request, boolean keepAlive, boolean validateHeaders, boolean isNoEntityStatus) {
            this.headers = headers;
            this.trailers = trailers;
            this.status = status;
            this.streamResult = streamResult;
            this.dataWriter = dataWriter;
            this.responseCloseRunnable = responseCloseRunnable;
            this.ctx = ctx;
            this.sendListener = sendListener;
            this.contentLength = headers.contentLength().orElse(-1L);
            this.request = request;
            this.keepAlive = keepAlive;
            this.validateHeaders = validateHeaders;
            this.isNoEntityStatus = isNoEntityStatus;
        }

        void checkResponseHeaders() {
            if (this.headers.contains(HeaderNames.TRAILER)) {
                this.headers.remove(HeaderNames.CONTENT_LENGTH);
                this.isChunked = true;
                this.forcedChunked = true;
            } else {
                this.isChunked = !this.headers.contains(HeaderNames.CONTENT_LENGTH);
                this.forcedChunked = this.headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.write(BufferData.create((int)1).write(b));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(BufferData.create((byte[])b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(BufferData.create((byte[])b, (int)off, (int)len));
        }

        @Override
        public void flush() throws IOException {
            if (this.closing) {
                return;
            }
            if (this.firstByte && this.firstBuffer != null) {
                this.write(BufferData.empty());
            }
        }

        @Override
        public void close() {
        }

        public void closing() {
            this.closing = true;
        }

        void commit() {
            boolean sendTrailers;
            if (this.closed) {
                return;
            }
            this.closed = true;
            boolean bl = sendTrailers = !(!this.isChunked && !this.forcedChunked || !this.request.headers().contains(HeaderValues.TE_TRAILERS) && !this.headers.contains(HeaderNames.TRAILER));
            if (this.firstByte) {
                if (this.forcedChunked && this.firstBuffer != null) {
                    this.sendHeadersAndPrepare();
                    this.writeChunked(this.firstBuffer);
                    this.terminatingChunk(sendTrailers);
                } else {
                    this.sendFirstChunkOnly();
                }
            } else if (this.isChunked) {
                this.terminatingChunk(sendTrailers);
            }
            if (sendTrailers) {
                this.trailers.set(STREAM_RESULT_NAME, new String[]{this.streamResult.get()});
                BufferData buffer = BufferData.growing((int)128);
                Http1ServerResponse.writeHeaders(this.trailers, buffer, this.validateHeaders);
                buffer.write(13);
                buffer.write(10);
                this.dataWriter.write(buffer);
            }
            this.responseCloseRunnable.run();
            try {
                super.close();
            }
            catch (IOException e) {
                throw new ServerConnectionException("Failed to close server response stream.", e);
            }
        }

        long totalBytesWritten() {
            return this.responseBytesTotal;
        }

        private void terminatingChunk(boolean trailers) {
            BufferData terminatingChunk = BufferData.create((byte[])(trailers ? TERMINATING_CHUNK_TRAILERS : TERMINATING_CHUNK));
            this.sendListener.data(this.ctx, terminatingChunk);
            this.dataWriter.write(terminatingChunk);
        }

        private void write(BufferData buffer) throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed");
            }
            if (this.isNoEntityStatus && buffer.available() > 0) {
                throw new IllegalStateException("Attempting to write data on a response with status " + String.valueOf(this.status));
            }
            if (!this.isChunked) {
                if (this.firstByte) {
                    this.firstByte = false;
                    Status usedStatus = this.status.get();
                    this.sendListener.status(this.ctx, usedStatus);
                    this.sendListener.headers(this.ctx, (Headers)this.headers);
                    BufferData growing = BufferData.growing((int)(256 + buffer.available()));
                    Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, growing, this.keepAlive, this.validateHeaders);
                    this.bytesWritten += (long)buffer.available();
                    this.checkContentLength(buffer);
                    this.sendListener.data(this.ctx, buffer);
                    growing.write(buffer);
                    this.responseBytesTotal += (long)growing.available();
                    this.dataWriter.write(growing);
                } else {
                    this.writeContent(buffer);
                }
                return;
            }
            if (this.firstByte && this.firstBuffer == null) {
                this.firstBuffer = buffer.copy();
                return;
            }
            if (this.firstByte) {
                if (this.request.headers().contains(HeaderValues.TE_TRAILERS)) {
                    this.headers.add(STREAM_TRAILERS);
                }
                if (this.headers.contains(HeaderNames.CONTENT_LENGTH) && (this.isNoEntityStatus || buffer.available() > 0)) {
                    LOGGER.log(System.Logger.Level.WARNING, "Content length was set after stream was requested, the response is already chunked, cannot use content-length");
                    this.headers.remove(HeaderNames.CONTENT_LENGTH);
                }
                this.sendHeadersAndPrepare();
                this.firstByte = false;
                BufferData combined = BufferData.create((BufferData[])new BufferData[]{this.firstBuffer, buffer});
                this.writeChunked(combined);
                this.firstBuffer = null;
            } else {
                this.writeChunked(buffer);
            }
        }

        private void sendFirstChunkOnly() {
            int contentLength;
            if (this.firstBuffer == null) {
                this.headers.set(HeaderValues.CONTENT_LENGTH_ZERO);
                contentLength = 0;
            } else {
                this.headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (String)String.valueOf(this.firstBuffer.available())));
                contentLength = this.firstBuffer.available();
            }
            this.isChunked = false;
            this.headers.remove(HeaderNames.TRANSFER_ENCODING);
            Status usedStatus = this.status.get();
            this.sendListener.status(this.ctx, usedStatus);
            this.sendListener.headers(this.ctx, (Headers)this.headers);
            BufferData bufferData = BufferData.growing((int)(contentLength + 256));
            Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, bufferData, this.keepAlive, this.validateHeaders);
            if (this.firstBuffer != null) {
                bufferData.write(this.firstBuffer);
            }
            this.sendListener.data(this.ctx, bufferData);
            this.responseBytesTotal += (long)bufferData.available();
            this.dataWriter.write(bufferData);
        }

        private void sendHeadersAndPrepare() {
            if (this.headers.contains(HeaderNames.CONTENT_LENGTH)) {
                this.contentLength = this.headers.contentLength().orElse(-1L);
                this.isChunked = false;
            } else {
                this.contentLength = -1L;
                if (!this.headers.contains(HeaderNames.TRANSFER_ENCODING)) {
                    this.headers.set(HeaderValues.TRANSFER_ENCODING_CHUNKED);
                } else if (!this.headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED)) {
                    this.headers.add(HeaderValues.TRANSFER_ENCODING_CHUNKED);
                }
            }
            Status usedStatus = this.status.get();
            this.sendListener.status(this.ctx, usedStatus);
            this.sendListener.headers(this.ctx, (Headers)this.headers);
            BufferData bufferData = BufferData.growing((int)256);
            Http1ServerResponse.nonEntityBytes(this.headers, usedStatus, bufferData, this.keepAlive, this.validateHeaders);
            this.sendListener.data(this.ctx, bufferData);
            this.responseBytesTotal += (long)bufferData.available();
            this.dataWriter.write(bufferData);
        }

        private void writeChunked(BufferData buffer) {
            int available = buffer.available();
            byte[] hex = Integer.toHexString(available).getBytes(StandardCharsets.US_ASCII);
            BufferData toWrite = BufferData.create((int)(available + hex.length + 4));
            toWrite.write(hex);
            toWrite.write(13);
            toWrite.write(10);
            toWrite.write(buffer);
            toWrite.write(13);
            toWrite.write(10);
            this.sendListener.data(this.ctx, toWrite);
            this.responseBytesTotal += (long)toWrite.available();
            this.dataWriter.write(toWrite);
        }

        private void checkContentLength(BufferData ignored) throws IOException {
            if (this.bytesWritten > this.contentLength && this.contentLength != -1L) {
                throw new IOException("Content length was set to " + this.contentLength + ", but you are writing additional " + (this.bytesWritten - this.contentLength) + " bytes");
            }
        }

        private void writeContent(BufferData buffer) throws IOException {
            this.bytesWritten += (long)buffer.available();
            this.checkContentLength(buffer);
            this.sendListener.data(this.ctx, buffer);
            this.responseBytesTotal += (long)buffer.available();
            this.dataWriter.write(buffer);
        }
    }
}

