/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.health;

import io.helidon.builder.api.Prototype;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckResponse;
import io.helidon.health.HealthCheckType;
import io.helidon.webserver.observe.health.HealthObserverConfig;
import java.util.function.Supplier;

final class HealthObserverSupport {
    private HealthObserverSupport() {
    }

    private static final class TypedCheck
    implements HealthCheck {
        private final HealthCheck delegate;
        private final HealthCheckType type;

        private TypedCheck(HealthCheck delegate, HealthCheckType type) {
            this.delegate = delegate;
            this.type = type;
        }

        public HealthCheckType type() {
            return this.type;
        }

        public String name() {
            return this.delegate.name();
        }

        public String path() {
            return this.delegate.path();
        }

        public HealthCheckResponse call() {
            return this.delegate.call();
        }
    }

    static final class CustomMethods {
        private CustomMethods() {
        }

        @Prototype.BuilderMethod
        static void addCheck(HealthObserverConfig.BuilderBase<?, ?> builder, HealthCheck check, HealthCheckType type) {
            if (check.type() == type) {
                builder.addCheck(check);
            } else {
                builder.addCheck(new TypedCheck(check, type));
            }
        }

        @Prototype.BuilderMethod
        static void addCheck(HealthObserverConfig.BuilderBase<?, ?> builder, final Supplier<HealthCheckResponse> responseSupplier, HealthCheckType type, final String name) {
            CustomMethods.addCheck(builder, new HealthCheck(){

                public HealthCheckResponse call() {
                    return (HealthCheckResponse)responseSupplier.get();
                }

                public String name() {
                    return name;
                }
            }, type);
        }

        @Prototype.BuilderMethod
        static void addChecks(HealthObserverConfig.BuilderBase<?, ?> builder, HealthCheck[] checks) {
            for (HealthCheck healthCheck : checks) {
                builder.addCheck(healthCheck);
            }
        }
    }
}

