/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.health;

import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckType;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.jsonp.JsonpSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.observe.health.HealthHandler;
import io.helidon.webserver.observe.health.HealthObserverConfig;
import io.helidon.webserver.observe.health.SingleCheckHandler;
import jakarta.json.JsonObject;
import java.util.List;

class HealthService
implements HttpService {
    private final boolean details;
    private final List<HealthCheck> all;
    private final List<HealthCheck> ready;
    private final List<HealthCheck> live;
    private final List<HealthCheck> start;

    HealthService(HealthObserverConfig config, List<HealthCheck> healthChecks) {
        this.details = config.details();
        this.all = List.copyOf(healthChecks);
        this.ready = healthChecks.stream().filter(it -> it.type() == HealthCheckType.READINESS).toList();
        this.live = healthChecks.stream().filter(it -> it.type() == HealthCheckType.LIVENESS).toList();
        this.start = healthChecks.stream().filter(it -> it.type() == HealthCheckType.STARTUP).toList();
    }

    public void routing(HttpRules rules) {
        EntityWriter entityWriter = JsonpSupport.serverResponseWriter();
        rules.get("/", new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.all)}).get("/" + HealthCheckType.READINESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.ready)}).get("/" + HealthCheckType.LIVENESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.live)}).get("/" + HealthCheckType.STARTUP.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.start)}).get("/" + HealthCheckType.READINESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.ready)}).get("/" + HealthCheckType.LIVENESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.live)}).get("/" + HealthCheckType.STARTUP.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.start)}).get("/check/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.all)}).head("/", new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.all)}).head("/" + HealthCheckType.READINESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.ready)}).head("/" + HealthCheckType.LIVENESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.live)}).head("/" + HealthCheckType.STARTUP.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.start)}).head("/" + HealthCheckType.READINESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.ready)}).head("/" + HealthCheckType.LIVENESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.live)}).head("/" + HealthCheckType.STARTUP.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.start)}).head("/check/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.all)});
    }
}

