/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.webserver.observe.ObserveFeature;
import io.helidon.webserver.observe.ObserveFeatureConfigBlueprint;
import io.helidon.webserver.observe.spi.ObserveProvider;
import io.helidon.webserver.observe.spi.Observer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.observe.ObserveFeatureConfigBlueprint")
public interface ObserveFeatureConfig
extends ObserveFeatureConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObserveFeatureConfig instance) {
        return (Builder)ObserveFeatureConfig.builder().from(instance);
    }

    public static ObserveFeatureConfig create(Config config) {
        return ((Builder)ObserveFeatureConfig.builder().config(config)).buildPrototype();
    }

    public static ObserveFeatureConfig create() {
        return ObserveFeatureConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ObserveFeatureConfig>
    implements io.helidon.common.Builder<Builder, ObserveFeature> {
        private Builder() {
        }

        public ObserveFeatureConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ObserveFeatureConfigImpl(this);
        }

        public ObserveFeature build() {
            return ObserveFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ObserveFeatureConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<Observer> observers = new ArrayList<Observer>();
        private final List<String> sockets = new ArrayList<String>();
        private boolean enabled = true;
        private boolean isObserversMutated;
        private boolean isSocketsMutated;
        private boolean observersDiscoverServices = true;
        private Config config;
        private CrossOriginConfig cors = CrossOriginConfig.create();
        private double weight = 80.0;
        private String endpoint = "/observe";
        private String name = "observe";

        protected BuilderBase() {
        }

        public BUILDER from(ObserveFeatureConfig prototype) {
            this.cors(prototype.cors());
            this.enabled(prototype.enabled());
            this.endpoint(prototype.endpoint());
            this.weight(prototype.weight());
            if (!this.isObserversMutated) {
                this.observers.clear();
            }
            this.addObservers(prototype.observers());
            this.observersDiscoverServices = false;
            this.config = prototype.config().orElse(null);
            if (!this.isSocketsMutated) {
                this.sockets.clear();
            }
            this.addSockets(prototype.sockets());
            this.name(prototype.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.cors(builder.cors());
            this.enabled(builder.enabled());
            this.endpoint(builder.endpoint());
            this.weight(builder.weight());
            if (this.isObserversMutated) {
                if (builder.isObserversMutated) {
                    this.addObservers(builder.observers);
                }
            } else {
                this.observers.clear();
                this.addObservers(builder.observers);
            }
            this.observersDiscoverServices = builder.observersDiscoverServices;
            builder.config().ifPresent(config -> this.config((Config)config));
            if (this.isSocketsMutated) {
                if (builder.isSocketsMutated) {
                    this.addSockets(builder.sockets);
                }
            } else {
                this.sockets.clear();
                this.addSockets(builder.sockets);
            }
            this.name(builder.name());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("cors").map(CrossOriginConfig::create).ifPresent(this::cors);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("endpoint").as(String.class).ifPresent(this::endpoint);
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("sockets").asList(String.class).ifPresent(this::sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cors(CrossOriginConfig cors) {
            Objects.requireNonNull(cors);
            this.cors = cors;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cors(Consumer<CrossOriginConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            CrossOriginConfig.Builder builder = CrossOriginConfig.builder();
            consumer.accept(builder);
            this.cors(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cors(Supplier<? extends CrossOriginConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.cors(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER endpoint(String endpoint) {
            Objects.requireNonNull(endpoint);
            this.endpoint = endpoint;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER observersDiscoverServices(boolean discoverServices) {
            this.observersDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER observers(List<? extends Observer> observers) {
            Objects.requireNonNull(observers);
            this.isObserversMutated = true;
            this.observers.clear();
            this.observers.addAll(observers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addObservers(List<? extends Observer> observers) {
            Objects.requireNonNull(observers);
            this.isObserversMutated = true;
            this.observers.addAll(observers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addObserver(Observer observer) {
            Objects.requireNonNull(observer);
            this.observers.add(observer);
            this.isObserversMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(List<String> sockets) {
            Objects.requireNonNull(sockets);
            this.isSocketsMutated = true;
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(List<String> sockets) {
            Objects.requireNonNull(sockets);
            this.isSocketsMutated = true;
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public CrossOriginConfig cors() {
            return this.cors;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public String endpoint() {
            return this.endpoint;
        }

        public double weight() {
            return this.weight;
        }

        public List<Observer> observers() {
            return this.observers;
        }

        public List<String> sockets() {
            return this.sockets;
        }

        public String name() {
            return this.name;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ObserveFeatureConfigBuilder{cors=" + String.valueOf(this.cors) + ",enabled=" + this.enabled + ",endpoint=" + this.endpoint + ",weight=" + this.weight + ",observers=" + String.valueOf(this.observers) + ",config=" + String.valueOf(this.config) + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + "}";
        }

        protected void preBuildPrototype() {
            Config config = this.config == null ? Config.empty() : this.config;
            HelidonServiceLoader serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(ObserveProvider.class));
            this.addObservers(ConfigBuilderSupport.discoverServices((Config)config, (String)"observers", (HelidonServiceLoader)serviceLoader, ObserveProvider.class, Observer.class, (boolean)this.observersDiscoverServices, this.observers));
        }

        protected void validatePrototype() {
        }

        protected static class ObserveFeatureConfigImpl
        implements ObserveFeatureConfig,
        Supplier<ObserveFeature> {
            private final boolean enabled;
            private final CrossOriginConfig cors;
            private final double weight;
            private final List<Observer> observers;
            private final List<String> sockets;
            private final Optional<Config> config;
            private final String endpoint;
            private final String name;

            protected ObserveFeatureConfigImpl(BuilderBase<?, ?> builder) {
                this.cors = builder.cors();
                this.enabled = builder.enabled();
                this.endpoint = builder.endpoint();
                this.weight = builder.weight();
                this.observers = List.copyOf(builder.observers());
                this.config = builder.config();
                this.sockets = List.copyOf(builder.sockets());
                this.name = builder.name();
            }

            public ObserveFeature build() {
                return ObserveFeature.create(this);
            }

            @Override
            public ObserveFeature get() {
                return this.build();
            }

            @Override
            public CrossOriginConfig cors() {
                return this.cors;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public String endpoint() {
                return this.endpoint;
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public List<Observer> observers() {
                return this.observers;
            }

            @Override
            public Optional<Config> config() {
                return this.config;
            }

            @Override
            public List<String> sockets() {
                return this.sockets;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                return "ObserveFeatureConfig{cors=" + String.valueOf(this.cors) + ",enabled=" + this.enabled + ",endpoint=" + this.endpoint + ",weight=" + this.weight + ",observers=" + String.valueOf(this.observers) + ",config=" + String.valueOf(this.config) + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ObserveFeatureConfig)) {
                    return false;
                }
                ObserveFeatureConfig other = (ObserveFeatureConfig)o;
                return Objects.equals(this.cors, other.cors()) && this.enabled == other.enabled() && Objects.equals(this.endpoint, other.endpoint()) && this.weight == other.weight() && Objects.equals(this.observers, other.observers()) && Objects.equals(this.config, other.config()) && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.name, other.name());
            }

            public int hashCode() {
                return Objects.hash(this.cors, this.enabled, this.endpoint, this.weight, this.observers, this.config, this.sockets, this.name);
            }
        }
    }
}

