/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type;

import io.hypersistence.utils.hibernate.type.array.BooleanArrayType;
import io.hypersistence.utils.hibernate.type.array.DateArrayType;
import io.hypersistence.utils.hibernate.type.array.DecimalArrayType;
import io.hypersistence.utils.hibernate.type.array.DoubleArrayType;
import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.ListArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateTimeArrayType;
import io.hypersistence.utils.hibernate.type.array.LongArrayType;
import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.type.array.TimestampArrayType;
import io.hypersistence.utils.hibernate.type.array.UUIDArrayType;
import io.hypersistence.utils.hibernate.type.basic.Iso8601MonthType;
import io.hypersistence.utils.hibernate.type.basic.MonthDayDateType;
import io.hypersistence.utils.hibernate.type.basic.MonthDayIntegerType;
import io.hypersistence.utils.hibernate.type.basic.NullableCharacterType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLCITextType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLEnumType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLHStoreType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLInetType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthDateType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthEpochType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthIntegerType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthTimestampType;
import io.hypersistence.utils.hibernate.type.interval.OracleIntervalDayToSecondType;
import io.hypersistence.utils.hibernate.type.interval.PostgreSQLIntervalType;
import io.hypersistence.utils.hibernate.type.interval.PostgreSQLPeriodType;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.json.JsonBlobType;
import io.hypersistence.utils.hibernate.type.json.JsonNodeStringType;
import io.hypersistence.utils.hibernate.type.json.JsonStringType;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.type.money.CurrencyUnitType;
import io.hypersistence.utils.hibernate.type.money.MonetaryAmountType;
import io.hypersistence.utils.hibernate.type.range.PostgreSQLRangeType;
import io.hypersistence.utils.hibernate.type.range.guava.PostgreSQLGuavaRangeType;
import io.hypersistence.utils.hibernate.type.search.PostgreSQLTSVectorType;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;

public class HibernateTypesContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        boolean enableJson;
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        Dialect dialect = jdbcServices.getDialect();
        boolean bl = enableJson = ReflectionUtils.getClassOrNull("com.fasterxml.jackson.databind.ObjectMapper") != null;
        if (dialect instanceof PostgreSQL82Dialect) {
            this.contributeType(typeContributions, (Object)BooleanArrayType.INSTANCE).contributeType(typeContributions, (Object)DateArrayType.INSTANCE).contributeType(typeContributions, (Object)DecimalArrayType.INSTANCE).contributeType(typeContributions, (Object)DoubleArrayType.INSTANCE).contributeType(typeContributions, (Object)EnumArrayType.INSTANCE).contributeType(typeContributions, (Object)IntArrayType.INSTANCE).contributeType(typeContributions, (Object)ListArrayType.INSTANCE).contributeType(typeContributions, (Object)LocalDateArrayType.INSTANCE).contributeType(typeContributions, (Object)LocalDateTimeArrayType.INSTANCE).contributeType(typeContributions, (Object)LongArrayType.INSTANCE).contributeType(typeContributions, (Object)StringArrayType.INSTANCE).contributeType(typeContributions, (Object)TimestampArrayType.INSTANCE).contributeType(typeContributions, (Object)UUIDArrayType.INSTANCE).contributeType(typeContributions, PostgreSQLIntervalType.INSTANCE).contributeType(typeContributions, PostgreSQLPeriodType.INSTANCE).contributeType(typeContributions, (Object)PostgreSQLTSVectorType.INSTANCE).contributeType(typeContributions, (Object)PostgreSQLEnumType.INSTANCE).contributeType(typeContributions, PostgreSQLHStoreType.INSTANCE).contributeType(typeContributions, PostgreSQLInetType.INSTANCE).contributeType(typeContributions, PostgreSQLRangeType.INSTANCE).contributeType(typeContributions, PostgreSQLCITextType.INSTANCE);
            if (ReflectionUtils.getClassOrNull("com.google.common.collect.Range") != null) {
                this.contributeType(typeContributions, PostgreSQLGuavaRangeType.INSTANCE);
            }
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonBinaryType.INSTANCE);
            }
        } else if (dialect instanceof MySQLDialect) {
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE).contributeType(typeContributions, (Object)JsonNodeStringType.INSTANCE);
            }
        } else if (dialect instanceof SQLServer2005Dialect) {
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE);
            }
        } else if (dialect instanceof Oracle8iDialect) {
            this.contributeType(typeContributions, OracleIntervalDayToSecondType.INSTANCE);
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE).contributeType(typeContributions, (Object)JsonBlobType.INSTANCE);
            }
        }
        this.contributeType(typeContributions, NullableCharacterType.INSTANCE).contributeType(typeContributions, (Object)Iso8601MonthType.INSTANCE).contributeType(typeContributions, (Object)MonthDayDateType.INSTANCE).contributeType(typeContributions, (Object)MonthDayIntegerType.INSTANCE).contributeType(typeContributions, (Object)YearMonthDateType.INSTANCE).contributeType(typeContributions, (Object)YearMonthEpochType.INSTANCE).contributeType(typeContributions, (Object)YearMonthIntegerType.INSTANCE).contributeType(typeContributions, (Object)YearMonthTimestampType.INSTANCE);
        if (enableJson) {
            this.contributeType(typeContributions, (Object)JsonType.INSTANCE);
        }
        if (ReflectionUtils.getClassOrNull("org.javamoney.moneta.Money") != null) {
            this.contributeType(typeContributions, (Object)CurrencyUnitType.INSTANCE).contributeType(typeContributions, MonetaryAmountType.INSTANCE);
        }
    }

    private HibernateTypesContributor contributeType(TypeContributions typeContributions, Object type) {
        if (type instanceof BasicType) {
            typeContributions.contributeType((BasicType)type);
        } else if (type instanceof UserType) {
            typeContributions.contributeType((UserType)type, new String[]{type.getClass().getSimpleName()});
        } else if (type instanceof CompositeUserType) {
            typeContributions.contributeType((CompositeUserType)type, new String[]{type.getClass().getSimpleName()});
        } else {
            throw new UnsupportedOperationException(String.format("The [%s] is not supported!", type.getClass()));
        }
        return this;
    }
}

