/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.hypersistence.utils.hibernate.type.util.JsonSerializer;
import io.hypersistence.utils.hibernate.type.util.JsonSerializerSupplier;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperSupplier;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperWrapper;
import io.hypersistence.utils.hibernate.util.ClassLoaderUtils;
import io.hypersistence.utils.hibernate.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.hibernate.cfg.Environment;

public class Configuration
implements Serializable {
    public static final Configuration INSTANCE = new Configuration();
    public static final String PROPERTIES_FILE_PATH = "hibernate-types.properties.path";
    public static final String PROPERTIES_FILE_NAME = "hibernate-types.properties";
    public static final String APPLICATION_PROPERTIES_FILE_NAME = "application.properties";
    private final ObjectMapperWrapper objectMapperWrapper;
    private final Properties properties = Environment.getProperties();

    private Configuration() {
        this(null);
    }

    public Configuration(Map<String, Object> settings) {
        Object jsonSerializerPropertyInstance;
        this.load();
        if (settings != null) {
            this.properties.putAll(settings);
        }
        Object objectMapperPropertyInstance = this.instantiateClass(PropertyKey.JACKSON_OBJECT_MAPPER);
        ObjectMapperWrapper objectMapperWrapper = new ObjectMapperWrapper();
        if (objectMapperPropertyInstance != null) {
            Object objectMapperSupplier;
            if (objectMapperPropertyInstance instanceof ObjectMapperSupplier) {
                objectMapperSupplier = (ObjectMapperSupplier)objectMapperPropertyInstance;
                if (objectMapperSupplier != null) {
                    objectMapperWrapper = new ObjectMapperWrapper((ObjectMapperSupplier)objectMapperSupplier);
                }
            } else if (objectMapperPropertyInstance instanceof Supplier) {
                objectMapperSupplier = (Supplier)objectMapperPropertyInstance;
                objectMapperWrapper = new ObjectMapperWrapper(() -> Configuration.lambda$new$63ef27e3$1((Supplier)objectMapperSupplier));
            } else if (objectMapperPropertyInstance instanceof ObjectMapper) {
                ObjectMapper objectMapper = (ObjectMapper)objectMapperPropertyInstance;
                objectMapperWrapper = new ObjectMapperWrapper(objectMapper);
            }
        }
        if ((jsonSerializerPropertyInstance = this.instantiateClass(PropertyKey.JSON_SERIALIZER)) != null) {
            JsonSerializer jsonSerializer = null;
            if (jsonSerializerPropertyInstance instanceof JsonSerializerSupplier) {
                jsonSerializer = ((JsonSerializerSupplier)jsonSerializerPropertyInstance).get();
            } else if (jsonSerializerPropertyInstance instanceof Supplier) {
                Supplier jsonSerializerSupplier = (Supplier)jsonSerializerPropertyInstance;
                jsonSerializer = (JsonSerializer)jsonSerializerSupplier.get();
            } else if (jsonSerializerPropertyInstance instanceof JsonSerializer) {
                jsonSerializer = (JsonSerializer)jsonSerializerPropertyInstance;
            }
            if (jsonSerializer != null) {
                objectMapperWrapper.setJsonSerializer(jsonSerializer);
            }
        }
        this.objectMapperWrapper = objectMapperWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        String[] propertiesFilePaths;
        for (String propertiesFilePath : propertiesFilePaths = new String[]{APPLICATION_PROPERTIES_FILE_NAME, PROPERTIES_FILE_NAME, System.getProperty(PROPERTIES_FILE_NAME)}) {
            if (propertiesFilePath == null) continue;
            InputStream propertiesInputStream = null;
            try {
                propertiesInputStream = this.propertiesInputStream(propertiesFilePath);
                if (propertiesInputStream == null) continue;
                this.properties.load(propertiesInputStream);
            }
            catch (IOException e) {
                LogUtils.LOGGER.error("Can't load properties", (Throwable)e);
            }
            finally {
                try {
                    if (propertiesInputStream != null) {
                        propertiesInputStream.close();
                    }
                }
                catch (IOException e) {
                    LogUtils.LOGGER.error("Can't close the properties InputStream", (Throwable)e);
                }
            }
        }
    }

    private InputStream propertiesInputStream(String propertiesFilePath) throws IOException {
        if (propertiesFilePath != null) {
            URL propertiesFileUrl;
            block6: {
                try {
                    propertiesFileUrl = new URL(propertiesFilePath);
                }
                catch (MalformedURLException ignore) {
                    File f;
                    propertiesFileUrl = ClassLoaderUtils.getResource(propertiesFilePath);
                    if (propertiesFileUrl != null || !(f = new File(propertiesFilePath)).exists() || !f.isFile()) break block6;
                    try {
                        propertiesFileUrl = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LogUtils.LOGGER.error("The property " + propertiesFilePath + " can't be resolved to either a URL, a classpath resource or a File");
                    }
                }
            }
            if (propertiesFileUrl != null) {
                return propertiesFileUrl.openStream();
            }
        }
        return ClassLoaderUtils.getResourceAsStream(propertiesFilePath);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ObjectMapperWrapper getObjectMapperWrapper() {
        return this.objectMapperWrapper;
    }

    public Integer integerProperty(PropertyKey propertyKey) {
        Integer value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Integer.valueOf(property);
        }
        return value;
    }

    public Long longProperty(PropertyKey propertyKey) {
        Long value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Long.valueOf(property);
        }
        return value;
    }

    public Boolean booleanProperty(PropertyKey propertyKey) {
        Boolean value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Boolean.valueOf(property);
        }
        return value;
    }

    public <T> Class<T> classProperty(PropertyKey propertyKey) {
        Class<T> clazz = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            try {
                return ClassLoaderUtils.loadClass(property);
            }
            catch (ClassNotFoundException e) {
                LogUtils.LOGGER.error("Couldn't load the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
        }
        return clazz;
    }

    private <T> T instantiateClass(PropertyKey propertyKey) {
        T object = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            try {
                Class clazz = ClassLoaderUtils.loadClass(property);
                LogUtils.LOGGER.debug("Instantiate {}", clazz);
                object = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LogUtils.LOGGER.error("Couldn't load the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
            catch (InstantiationException e) {
                LogUtils.LOGGER.error("Couldn't instantiate the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LogUtils.LOGGER.error("Couldn't access the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
        }
        return object;
    }

    private static /* synthetic */ ObjectMapper lambda$new$63ef27e3$1(Supplier objectMapperSupplier) {
        return (ObjectMapper)objectMapperSupplier.get();
    }

    public static enum PropertyKey {
        JACKSON_OBJECT_MAPPER("hibernate.types.jackson.object.mapper"),
        JSON_SERIALIZER("hibernate.types.json.serializer"),
        PRINT_BANNER("hibernate.types.print.banner");

        private final String key;

        private PropertyKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

