/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.hypersistence.utils.hibernate.type.util.JsonSerializer;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperJsonSerializer;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperSupplier;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.hibernate.HibernateException;

public class ObjectMapperWrapper
implements Serializable {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().findAndRegisterModules().registerModule((Module)new SimpleModule().addSerializer(OffsetDateTime.class, (com.fasterxml.jackson.databind.JsonSerializer)OffsetDateTimeSerializer.INSTANCE).addDeserializer(OffsetDateTime.class, (JsonDeserializer)OffsetDateTimeDeserializer.INSTANCE));
    public static final ObjectMapperWrapper INSTANCE = new ObjectMapperWrapper();
    private ObjectMapper objectMapper;
    private ObjectMapperSupplier objectMapperSupplier;
    private JsonSerializer jsonSerializer;

    public ObjectMapperWrapper() {
        this(OBJECT_MAPPER);
    }

    public ObjectMapperWrapper(ObjectMapperSupplier objectMapperSupplier) {
        this.objectMapperSupplier = objectMapperSupplier;
    }

    public ObjectMapperWrapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.jsonSerializer = new ObjectMapperJsonSerializer(this);
    }

    public void setJsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null && this.objectMapperSupplier != null) {
            this.objectMapper = this.objectMapperSupplier.get();
        }
        if (this.objectMapper == null) {
            throw new HibernateException("The provided ObjectMapper is null!");
        }
        return this.objectMapper;
    }

    public <T> T fromString(String string, Class<T> clazz) {
        try {
            return (T)this.getObjectMapper().readValue(string, clazz);
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException("The given string value: " + string + " cannot be transformed to Json object", e));
        }
    }

    public <T> T fromString(String string, Type type) {
        try {
            return (T)this.getObjectMapper().readValue(string, this.getObjectMapper().getTypeFactory().constructType(type));
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException("The given string value: " + string + " cannot be transformed to Json object", e));
        }
    }

    public <T> T fromBytes(byte[] value, Class<T> clazz) {
        try {
            return (T)this.getObjectMapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException("The given byte array cannot be transformed to Json object", e));
        }
    }

    public <T> T fromBytes(byte[] value, Type type) {
        try {
            return (T)this.getObjectMapper().readValue(value, this.getObjectMapper().getTypeFactory().constructType(type));
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException("The given byte array cannot be transformed to Json object", e));
        }
    }

    public String toString(Object value) {
        try {
            return this.getObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException("The given Json object value: " + value + " cannot be transformed to a String", e));
        }
    }

    public byte[] toBytes(Object value) {
        try {
            return this.getObjectMapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException("The given Json object value: " + value + " cannot be transformed to a byte array", e));
        }
    }

    public JsonNode toJsonNode(String value) {
        try {
            return this.getObjectMapper().readTree(value);
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)new IllegalArgumentException(e));
        }
    }

    public <T> T clone(T value) {
        return this.jsonSerializer.clone(value);
    }

    public static class OffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        public static final OffsetDateTimeDeserializer INSTANCE = new OffsetDateTimeDeserializer();

        public OffsetDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getText() != null) {
                try {
                    return OffsetDateTime.parse(jsonParser.getText(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                }
                catch (DateTimeParseException e) {
                    Date date = new Date((long)jsonParser.getDoubleValue() * 1000L);
                    return date.toInstant().atOffset(ZoneOffset.UTC);
                }
            }
            return null;
        }

        public Class<OffsetDateTime> handledType() {
            return OffsetDateTime.class;
        }
    }

    public static class OffsetDateTimeSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<OffsetDateTime> {
        public static final OffsetDateTimeSerializer INSTANCE = new OffsetDateTimeSerializer();

        public void serialize(OffsetDateTime offsetDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (offsetDateTime == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeString(offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
        }

        public Class<OffsetDateTime> handledType() {
            return OffsetDateTime.class;
        }
    }
}

