/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type;

import io.hypersistence.utils.common.ReflectionUtils;
import io.hypersistence.utils.hibernate.type.json.internal.JdbcTypeSetter;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.query.BindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.usertype.UserType;

public abstract class MutableType<T, JDBC extends JdbcType, JAVA extends JavaType<T>>
implements UserType<T>,
BindableType<T>,
SqmExpressible<T>,
BasicValuedMapping {
    private final Class<T> clazz;
    private final JDBC jdbcTypeDescriptor;
    private final JAVA javaTypeDescriptor;
    private final JdbcMapping jdbcMapping;
    private final Configuration configuration;

    public MutableType(Class<T> clazz, JDBC jdbcTypeDescriptor, JAVA javaTypeDescriptor) {
        this(clazz, jdbcTypeDescriptor, javaTypeDescriptor, Configuration.INSTANCE);
    }

    public MutableType(Class<T> clazz, JDBC jdbcTypeDescriptor, JAVA javaTypeDescriptor, Configuration configuration) {
        this.clazz = clazz;
        this.jdbcTypeDescriptor = jdbcTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.configuration = configuration;
        this.jdbcMapping = new BasicTypeImpl(javaTypeDescriptor, jdbcTypeDescriptor);
        ReflectionUtils.getMethodOrNull(javaTypeDescriptor, "setJdbcType", new Class[0]);
        if (javaTypeDescriptor instanceof JdbcTypeSetter) {
            JdbcTypeSetter jdbcTypeSetter = (JdbcTypeSetter)javaTypeDescriptor;
            jdbcTypeSetter.setJdbcType((JdbcType)jdbcTypeDescriptor);
        }
    }

    public JDBC getJdbcTypeDescriptor() {
        return this.jdbcTypeDescriptor;
    }

    public JAVA getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean equals(T x, T y) {
        return this.javaTypeDescriptor.areEqual(x, y);
    }

    public int hashCode(T x) {
        return this.javaTypeDescriptor.extractHashCode(x);
    }

    public T nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return (T)this.jdbcTypeDescriptor.getExtractor(this.javaTypeDescriptor).extract(rs, position, (WrapperOptions)session);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.jdbcTypeDescriptor.getBinder(this.javaTypeDescriptor).bind(st, value, index, (WrapperOptions)session);
    }

    public T deepCopy(T value) {
        return (T)this.javaTypeDescriptor.getMutabilityPlan().deepCopy(value);
    }

    public boolean isMutable() {
        return this.javaTypeDescriptor.getMutabilityPlan().isMutable();
    }

    public Serializable disassemble(T value) {
        return this.javaTypeDescriptor.getMutabilityPlan().disassemble(value, null);
    }

    public T assemble(Serializable cached, Object owner) {
        return (T)this.javaTypeDescriptor.getMutabilityPlan().assemble(cached, null);
    }

    public T replace(T detached, T managed, Object owner) {
        if (!this.isMutable() || managed != null && this.equals(detached, managed)) {
            return detached;
        }
        return this.deepCopy(detached);
    }

    public int getSqlType() {
        return this.jdbcTypeDescriptor.getJdbcTypeCode();
    }

    public Class<T> returnedClass() {
        return this.clazz;
    }

    public Class<T> getBindableJavaType() {
        return this.clazz;
    }

    public JavaType<T> getExpressibleJavaType() {
        return this.javaTypeDescriptor;
    }

    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    public MappingType getMappedType() {
        return this.jdbcMapping;
    }

    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.disassemble(value);
    }

    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, (Object)this.jdbcMapping);
        return this.getJdbcTypeCount();
    }
}

