/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.ImmutableDynamicParameterizedType;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.EnumType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.internal.NamedEnumValueConverter;
import org.hibernate.type.descriptor.converter.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLEnumType
extends ImmutableDynamicParameterizedType<Enum> {
    public static final PostgreSQLEnumType INSTANCE = new PostgreSQLEnumType();
    private EnumType enumType;
    private JdbcType jdbcType;

    public PostgreSQLEnumType() {
        super(Enum.class);
    }

    public void setParameterValues(Properties parameters) {
        this.jdbcType = new ObjectJdbcType(this.getSqlType());
        Class enumClass = ReflectionUtils.getClass(parameters.getProperty("org.hibernate.type.ParameterType.returnedClass"));
        TypeConfiguration typeConfiguration = new TypeConfiguration();
        EnumJavaType enumJavaType = (EnumJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(enumClass);
        this.enumType = new EnumType(enumClass, (EnumValueConverter)new NamedEnumValueConverter(enumJavaType, this.jdbcType, typeConfiguration.getJavaTypeRegistry().getDescriptor(String.class)), typeConfiguration);
        ReflectionUtils.setFieldValue(this.enumType, "jdbcType", this.jdbcType);
        ObjectJavaType javaType = new ObjectJavaType();
        ValueExtractor valueExtractor = this.jdbcType.getExtractor((JavaType)javaType);
        ValueBinder valueBinder = this.jdbcType.getBinder((JavaType)javaType);
        ReflectionUtils.setFieldValue(this.enumType, "jdbcValueExtractor", valueExtractor);
        ReflectionUtils.setFieldValue(this.enumType, "jdbcValueBinder", valueBinder);
    }

    @Override
    protected Enum get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return this.enumType.nullSafeGet(rs, position, session, owner);
    }

    @Override
    protected void set(PreparedStatement st, Enum value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.enumType.nullSafeSet(st, value, index, session);
    }

    public int getSqlType() {
        return 1111;
    }
}

