/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.range;

import io.hypersistence.utils.hibernate.type.ImmutableType;
import io.hypersistence.utils.hibernate.type.range.Range;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.spi.TypeBootstrapContext;
import org.hibernate.usertype.DynamicParameterizedType;

public class PostgreSQLRangeType
extends ImmutableType<Range>
implements DynamicParameterizedType {
    public static final PostgreSQLRangeType INSTANCE = new PostgreSQLRangeType();
    private Type type;

    public PostgreSQLRangeType() {
        super(Range.class);
    }

    public PostgreSQLRangeType(TypeBootstrapContext typeBootstrapContext) {
        super(Range.class, new Configuration(typeBootstrapContext.getConfigurationSettings()));
    }

    public int getSqlType() {
        return 1111;
    }

    @Override
    protected Range get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        Object pgObject = rs.getObject(position);
        if (pgObject == null) {
            return null;
        }
        String type = (String)ReflectionUtils.invokeGetter(pgObject, "type");
        String value = (String)ReflectionUtils.invokeGetter(pgObject, "value");
        switch (type) {
            case "int4range": {
                return Range.integerRange(value);
            }
            case "int8range": {
                return Range.longRange(value);
            }
            case "numrange": {
                return Range.bigDecimalRange(value);
            }
            case "tsrange": {
                return Range.localDateTimeRange(value);
            }
            case "tstzrange": {
                return Range.zonedDateTimeRange(value);
            }
            case "daterange": {
                return Range.localDateRange(value);
            }
        }
        throw new HibernateException((Throwable)new IllegalStateException("The range type [" + type + "] is not supported!"));
    }

    @Override
    protected void set(PreparedStatement st, Range range, int index, SharedSessionContractImplementor session) throws SQLException {
        if (range == null) {
            st.setNull(index, 1111);
        } else {
            Object holder = ReflectionUtils.newInstance("org.postgresql.util.PGobject");
            ReflectionUtils.invokeSetter(holder, "type", PostgreSQLRangeType.determineRangeType(range));
            ReflectionUtils.invokeSetter(holder, "value", range.asString());
            st.setObject(index, holder);
        }
    }

    private static String determineRangeType(Range<?> range) {
        Class<?> clazz = range.getClazz();
        if (clazz.equals(Integer.class)) {
            return "int4range";
        }
        if (clazz.equals(Long.class)) {
            return "int8range";
        }
        if (clazz.equals(BigDecimal.class)) {
            return "numrange";
        }
        if (clazz.equals(LocalDateTime.class)) {
            return "tsrange";
        }
        if (clazz.equals(ZonedDateTime.class)) {
            return "tstzrange";
        }
        if (clazz.equals(LocalDate.class)) {
            return "daterange";
        }
        throw new HibernateException((Throwable)new IllegalStateException("The class [" + clazz.getName() + "] is not supported!"));
    }

    public void setParameterValues(Properties parameters) {
        XProperty xProperty = (XProperty)parameters.get("org.hibernate.type.ParameterType.xproperty");
        this.type = xProperty instanceof JavaXMember ? ((JavaXMember)xProperty).getJavaType() : ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
    }

    public Class<?> getElementType() {
        return this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getActualTypeArguments()[0] : null;
    }
}

