/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.search.internal;

import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class PostgreSQLTSVectorSqlTypeDescriptor
implements JdbcType {
    public static final PostgreSQLTSVectorSqlTypeDescriptor INSTANCE = new PostgreSQLTSVectorSqlTypeDescriptor();

    public int getJdbcTypeCode() {
        return 1111;
    }

    public <X> ValueBinder<X> getBinder(final JavaType<X> JavaType2) {
        return new BasicBinder<X>(JavaType2, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Object holder = ReflectionUtils.newInstance("org.postgresql.util.PGobject");
                ReflectionUtils.invokeSetter(holder, "type", "tsvector");
                ReflectionUtils.invokeSetter(holder, "value", JavaType2.unwrap(value, String.class, options));
                st.setObject(index, holder);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Object holder = ReflectionUtils.newInstance("org.postgresql.util.PGobject");
                ReflectionUtils.invokeSetter(holder, "type", "tsvector");
                ReflectionUtils.invokeSetter(holder, "value", JavaType2.unwrap(value, String.class, options));
                st.setObject(name, holder);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> JavaType2) {
        return new BasicExtractor<X>(JavaType2, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return JavaType2.wrap((Object)rs.getString(paramIndex), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return JavaType2.wrap((Object)statement.getString(index), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return JavaType2.wrap((Object)statement.getString(name), options);
            }
        };
    }
}

