/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array.internal;

import io.hypersistence.utils.common.ReflectionUtils;
import io.hypersistence.utils.hibernate.type.array.internal.AbstractArrayTypeDescriptor;
import io.hypersistence.utils.hibernate.type.array.internal.ArrayUtil;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.hibernate.SharedSessionContract;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class ListArrayTypeDescriptor
extends AbstractArrayTypeDescriptor<Collection> {
    private String sqlArrayType;
    private Class entityClass;
    private String propertyName;
    private Class propertyClass;

    public ListArrayTypeDescriptor() {
        super(Collection.class, new MutableMutabilityPlan<Collection>(){

            protected Collection deepCopyNotNull(Collection value) {
                if (value instanceof Set) {
                    Object[] array = ((Set)value).toArray();
                    return ArrayUtil.asSet((Object[])ArrayUtil.deepCopy(array));
                }
                Object[] array = value.toArray();
                return ArrayUtil.asList((Object[])ArrayUtil.deepCopy(array));
            }

            public Collection assemble(Serializable cached, SharedSessionContract session) {
                if (cached != null && cached.getClass().isArray()) {
                    Object[] array = (Object[])cached;
                    return Arrays.asList(array);
                }
                return (Collection)super.assemble(cached, session);
            }
        });
    }

    @Override
    protected String getSqlArrayType() {
        return this.sqlArrayType;
    }

    @Override
    public Object unwrap(Collection value, Class type, WrapperOptions options) {
        return super.unwrap(value, type, options);
    }

    @Override
    public Collection wrap(Object value, WrapperOptions options) {
        Object wrappedObject = super.wrap(value, options);
        Collection list = null;
        if (wrappedObject != null) {
            list = this.newPropertyCollectionInstance();
            if (wrappedObject instanceof Object[]) {
                Object[] wrappedArray = (Object[])wrappedObject;
                Collections.addAll(list, wrappedArray);
            } else {
                throw new UnsupportedOperationException("The wrapped object " + value + " is not an Object[]!");
            }
        }
        return list;
    }

    @Override
    public boolean areEqual(Collection one, Collection another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return ArrayUtil.isEquals(one.toArray(), another.toArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameterValues(Properties parameters) {
        Class arrayElementClass;
        this.entityClass = ReflectionUtils.getClass(parameters.getProperty("org.hibernate.type.ParameterType.entityClass"));
        this.propertyName = parameters.getProperty("org.hibernate.type.ParameterType.propertyName");
        this.propertyClass = ReflectionUtils.getClass(parameters.getProperty("org.hibernate.type.ParameterType.returnedClass"));
        Type memberGenericType = ReflectionUtils.getMemberGenericTypeOrNull(this.entityClass, this.propertyName);
        if (!(memberGenericType instanceof ParameterizedType)) throw new UnsupportedOperationException("The property " + this.propertyName + " in the " + this.entityClass + " entity is not parameterized!");
        ParameterizedType parameterizedType = (ParameterizedType)memberGenericType;
        Type genericType = parameterizedType.getActualTypeArguments()[0];
        if (genericType instanceof WildcardType) {
            genericType = ((WildcardType)genericType).getUpperBounds()[0];
        }
        this.setArrayObjectClass((arrayElementClass = ReflectionUtils.getClass(genericType.getTypeName())).isArray() ? arrayElementClass : ArrayUtil.toArrayClass(arrayElementClass));
        this.sqlArrayType = parameters.getProperty("sql_array_type");
        if (this.sqlArrayType != null) return;
        if (Integer.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "integer";
            return;
        } else if (Long.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "bigint";
            return;
        } else if (Double.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "float8";
            return;
        } else if (String.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "text";
            return;
        } else if (UUID.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "uuid";
            return;
        } else if (Date.class.isAssignableFrom(arrayElementClass) || LocalDateTime.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "timestamp";
            return;
        } else if (Boolean.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "boolean";
            return;
        } else if (BigDecimal.class.isAssignableFrom(arrayElementClass)) {
            this.sqlArrayType = "decimal";
            return;
        } else {
            if (!LocalDate.class.isAssignableFrom(arrayElementClass)) throw new UnsupportedOperationException("The " + arrayElementClass + " is not supported yet!");
            this.sqlArrayType = "date";
        }
    }

    private Collection newPropertyCollectionInstance() {
        if (this.propertyClass == null || List.class.isAssignableFrom(this.propertyClass)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(this.propertyClass)) {
            return new LinkedHashSet();
        }
        throw new UnsupportedOperationException("The property " + this.propertyName + " in the " + this.entityClass + " entity is not supported by the ListArrayType!");
    }
}

