/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.fusesource.stomp.client.Callback;
import org.fusesource.stomp.client.Future;

public class Promise<T>
extends Callback<T>
implements Future<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    Throwable error;
    T value;

    @Override
    public void onFailure(Throwable value) {
        this.error = value;
        this.latch.countDown();
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        this.latch.countDown();
    }

    @Override
    public T await(long amount, TimeUnit unit) throws Exception {
        this.latch.await(amount, unit);
        return this.get();
    }

    @Override
    public T await() throws Exception {
        this.latch.await();
        return this.get();
    }

    private T get() throws Exception {
        Throwable e = this.error;
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        return this.value;
    }
}

