/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.stomp.client.Constants;

public class StompFrame {
    public static final Buffer NO_DATA = new Buffer(new byte[0]);
    private AsciiBuffer action;
    private ArrayList<HeaderEntry> headerList;
    private HashMap<AsciiBuffer, AsciiBuffer> headerMap = new HashMap(16);
    private Buffer content = NO_DATA;

    public StompFrame() {
    }

    public StompFrame(AsciiBuffer action) {
        this.action = action;
    }

    public StompFrame clone() {
        StompFrame rc = new StompFrame(this.action);
        if (this.headerList != null) {
            rc.headerList = new ArrayList<HeaderEntry>(this.headerList);
            rc.headerMap = null;
        } else {
            rc.headerMap = new HashMap<AsciiBuffer, AsciiBuffer>(this.headerMap);
            rc.headerList = null;
        }
        rc.content = this.content;
        return rc;
    }

    public AsciiBuffer action() {
        return this.action;
    }

    public StompFrame action(AsciiBuffer action) {
        assert (action != null);
        this.action = action;
        return this;
    }

    public Buffer content() {
        return this.content;
    }

    public StompFrame content(Buffer content) {
        assert (content != null);
        this.content = content;
        return this;
    }

    public String contentAsString() {
        try {
            return new String(this.content.getData(), this.content.getOffset(), this.content.getLength(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<AsciiBuffer, AsciiBuffer> headerMap() {
        return this.headerMap(Collections.EMPTY_SET);
    }

    public Map<AsciiBuffer, AsciiBuffer> headerMap(Set<AsciiBuffer> reversedHeaderHandling) {
        if (this.headerMap == null) {
            this.headerMap = new HashMap();
            for (HeaderEntry HeaderEntry2 : this.headerList) {
                AsciiBuffer key = HeaderEntry2.getKey();
                AsciiBuffer old = this.headerMap.put(key, HeaderEntry2.getValue());
                if (old == null || reversedHeaderHandling.contains(key)) continue;
                this.headerMap.put(key, old);
            }
            this.headerList = null;
        }
        return this.headerMap;
    }

    public List<HeaderEntry> headerList() {
        if (this.headerList == null) {
            for (Map.Entry<AsciiBuffer, AsciiBuffer> entry : this.headerMap.entrySet()) {
                this.headerList.add(new HeaderEntry(entry.getKey(), entry.getValue()));
            }
            this.headerMap = null;
        }
        return this.headerList;
    }

    public void addHeader(AsciiBuffer key, AsciiBuffer value) {
        if (this.headerList != null) {
            this.headerList.add(0, new HeaderEntry(key, value));
        } else {
            this.headerMap.put(key, value);
        }
    }

    public AsciiBuffer getHeader(AsciiBuffer key) {
        if (this.headerList != null) {
            for (HeaderEntry HeaderEntry2 : this.headerList) {
                if (!HeaderEntry2.getKey().equals((Buffer)key)) continue;
                return HeaderEntry2.getValue();
            }
            return null;
        }
        return this.headerMap.get(key);
    }

    public void clearHeaders() {
        if (this.headerList != null) {
            this.headerList.clear();
        } else {
            this.headerMap.clear();
        }
    }

    public void setHeaders(ArrayList<HeaderEntry> values) {
        this.headerList = values;
        this.headerMap = null;
    }

    public Buffer toBuffer() {
        return this.toBuffer(true);
    }

    public Buffer toBuffer(boolean includeBody) {
        try {
            DataByteArrayOutputStream out = new DataByteArrayOutputStream();
            this.write((DataOutput)out, includeBody);
            return out.toBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(DataOutput out, Buffer buffer) throws IOException {
        out.write(buffer.data, buffer.offset, buffer.length);
    }

    public void write(DataOutput out) throws IOException {
        this.write(out, true);
    }

    public void addContentLengthHeader() {
        this.addHeader(Constants.CONTENT_LENGTH, new AsciiBuffer(Integer.toString(this.content.length())));
    }

    public int size() {
        int rc = this.action.length() + 1;
        if (this.headerList != null) {
            for (HeaderEntry entry : this.headerList) {
                rc += entry.getKey().length() + entry.getValue().length() + 2;
            }
        } else {
            for (Map.Entry<AsciiBuffer, AsciiBuffer> entry : this.headerMap.entrySet()) {
                rc += entry.getKey().length() + entry.getValue().length() + 2;
            }
        }
        return rc += this.content.length() + 3;
    }

    public void write(DataOutput out, boolean includeBody) throws IOException {
        this.write(out, (Buffer)this.action);
        out.writeByte(10);
        if (this.headerList != null) {
            for (HeaderEntry entry : this.headerList) {
                this.write(out, (Buffer)entry.getKey());
                out.writeByte(58);
                this.write(out, (Buffer)entry.getValue());
                out.writeByte(10);
            }
        } else {
            for (Map.Entry<AsciiBuffer, AsciiBuffer> entry : this.headerMap.entrySet()) {
                this.write(out, (Buffer)entry.getKey());
                out.writeByte(58);
                this.write(out, (Buffer)entry.getValue());
                out.writeByte(10);
            }
        }
        out.writeByte(10);
        if (includeBody) {
            this.write(out, this.content);
            out.writeByte(0);
            out.writeByte(10);
        }
    }

    public String toString() {
        return this.toBuffer(false).ascii().toString();
    }

    public String errorMessage() {
        AsciiBuffer value = this.getHeader(Constants.MESSAGE_HEADER);
        if (value != null) {
            return StompFrame.decodeHeader((Buffer)value);
        }
        return this.contentAsString();
    }

    public static String decodeHeader(Buffer value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream rc = new ByteArrayOutputStream(value.length);
        Buffer pos = new Buffer(value);
        int max = value.offset + value.length;
        while (pos.offset < max) {
            if (pos.startsWith((Buffer)Constants.ESCAPE_ESCAPE_SEQ)) {
                rc.write(92);
                pos.moveHead(2);
                continue;
            }
            if (pos.startsWith((Buffer)Constants.COLON_ESCAPE_SEQ)) {
                rc.write(58);
                pos.moveHead(2);
                continue;
            }
            if (pos.startsWith((Buffer)Constants.NEWLINE_ESCAPE_SEQ)) {
                rc.write(10);
                pos.moveHead(2);
                continue;
            }
            rc.write((int)pos.data[pos.offset]);
            pos.moveHead(1);
        }
        try {
            return new String(rc.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static AsciiBuffer encodeHeader(String value) {
        if (value == null) {
            return null;
        }
        try {
            byte[] data = value.getBytes("UTF-8");
            ByteArrayOutputStream rc = new ByteArrayOutputStream(data.length);
            block7: for (byte d : data) {
                switch (d) {
                    case 92: {
                        rc.write((Buffer)Constants.ESCAPE_ESCAPE_SEQ);
                        continue block7;
                    }
                    case 58: {
                        rc.write((Buffer)Constants.COLON_ESCAPE_SEQ);
                        continue block7;
                    }
                    case 10: {
                        rc.write((Buffer)Constants.COLON_ESCAPE_SEQ);
                        continue block7;
                    }
                    default: {
                        rc.write((int)d);
                    }
                }
            }
            return rc.toBuffer().ascii();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<AsciiBuffer, AsciiBuffer> encodeHeaders(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<AsciiBuffer, AsciiBuffer> rc = new HashMap<AsciiBuffer, AsciiBuffer>(headers.size());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            rc.put(StompFrame.encodeHeader(entry.getKey()), StompFrame.encodeHeader(entry.getValue()));
        }
        return rc;
    }

    public static class HeaderEntry {
        public final AsciiBuffer key;
        public final AsciiBuffer value;

        public HeaderEntry(AsciiBuffer key, AsciiBuffer value) {
            this.key = key;
            this.value = value;
        }

        public AsciiBuffer getKey() {
            return this.key;
        }

        public AsciiBuffer getValue() {
            return this.value;
        }

        public String toString() {
            return "" + this.key + "=" + this.value;
        }
    }
}

