/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import org.fusesource.stomp.jms.StompJmsDestination;
import org.fusesource.stomp.jms.StompJmsSession;
import org.fusesource.stomp.jms.message.StompJmsMessageTransformation;

public class StompJmsMessageProducer
implements MessageProducer {
    protected final StompJmsSession session;
    protected StompJmsDestination destination;
    protected final boolean flexibleDestination;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected boolean closed;
    protected boolean disableMessageId;
    protected boolean disableTimestamp;

    protected StompJmsMessageProducer(StompJmsSession s, StompJmsDestination dest) {
        this.session = s;
        this.destination = dest;
        this.flexibleDestination = dest == null;
    }

    public void close() {
        this.closed = true;
        this.session.remove(this);
    }

    public long getDeliveryDelay() throws JMSException {
        throw new UnsupportedOperationException("getDeliveryDelay() is not supported");
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        throw new UnsupportedOperationException("setDeliveryDelay(deliveryDelay) is not supported");
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageId;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableTimestamp;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    public void send(Message message) throws JMSException {
        this.send(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        if (!this.flexibleDestination && !destination.equals(this.destination)) {
            throw new UnsupportedOperationException("This producer can only send messages to: " + this.destination.getName());
        }
        this.session.send(destination, message, deliveryMode, priority, timeToLive, this.disableMessageId);
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(message, completionListener) is not supported");
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(destination, message, completionListener) is not supported");
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(message, deliveryMode, priority, timeToLive, completionListener) is not supported");
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new UnsupportedOperationException("send(destination, message, deliveryMode, priority, timeToLive, completionListener) is not supported");
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        this.deliveryMode = deliveryMode;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageId = value;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableTimestamp = value;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        this.priority = defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.timeToLive = timeToLive;
    }

    public void setDestination(Destination destination) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        if (!this.flexibleDestination && !destination.equals(this.destination)) {
            throw new UnsupportedOperationException("This producer can only send messages to: " + this.destination.getName());
        }
        this.destination = StompJmsMessageTransformation.transformDestination(this.session.connection, destination);
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The MessageProducer is closed");
        }
    }
}

