/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.message;

import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.stomp.jms.message.StompJmsMessage;
import org.fusesource.stomp.jms.util.StompTranslator;

public class StompJmsMapMessage
extends StompJmsMessage
implements MapMessage {
    protected transient Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public StompJmsMessage.JmsMsgType getMsgType() {
        return StompJmsMessage.JmsMsgType.MAP;
    }

    @Override
    public StompJmsMessage copy() throws JMSException {
        StompJmsMapMessage other = new StompJmsMapMessage();
        other.copy(this);
        return other;
    }

    public void copy(StompJmsMapMessage other) throws JMSException {
        other.storeContent();
        super.copy(other);
    }

    @Override
    public void storeContent() throws JMSException {
        Buffer buffer = this.getContent();
        if (buffer == null && !this.map.isEmpty()) {
            buffer = StompTranslator.writeBufferFromObject(this.map);
            this.setContent(buffer);
        }
    }

    private void loadContent() throws JMSException {
        Buffer buffer = this.getContent();
        if (buffer != null && this.map.isEmpty()) {
            this.map = (Map)StompTranslator.readObjectFromBuffer(buffer);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.map.clear();
    }

    public boolean getBoolean(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a boolean from " + value.getClass().getName());
    }

    public byte getByte(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a byte from " + value.getClass().getName());
    }

    public short getShort(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String) {
            return Short.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a short from " + value.getClass().getName());
    }

    public char getChar(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException(" cannot read a short from " + value.getClass().getName());
    }

    public int getInt(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read an int from " + value.getClass().getName());
    }

    public long getLong(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a long from " + value.getClass().getName());
    }

    public float getFloat(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString()).floatValue();
        }
        throw new MessageFormatException(" cannot read a float from " + value.getClass().getName());
    }

    public double getDouble(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString()).floatValue();
        }
        throw new MessageFormatException(" cannot read a double from " + value.getClass().getName());
    }

    public String getString(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            throw new MessageFormatException("Use getBytes to read a byte array");
        }
        return value.toString();
    }

    public byte[] getBytes(String name) throws JMSException {
        this.initializeReading();
        Object value = this.map.get(name);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageFormatException(" cannot read a byte[] from " + value.getClass().getName());
    }

    public Object getObject(String name) throws JMSException {
        this.initializeReading();
        return this.map.get(name);
    }

    public Enumeration<String> getMapNames() throws JMSException {
        this.initializeReading();
        return Collections.enumeration(this.map.keySet());
    }

    protected void put(String name, Object value) throws JMSException {
        if (name == null) {
            throw new IllegalArgumentException("The name of the property cannot be null.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The name of the property cannot be an emprty string.");
        }
        this.map.put(name, value);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.initializeWriting();
        this.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        this.initializeWriting();
        this.put(name, Character.valueOf(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Double(value));
    }

    public void setString(String name, String value) throws JMSException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.initializeWriting();
        if (value != null) {
            this.put(name, value);
        } else {
            this.map.remove(name);
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        byte[] data = new byte[length];
        System.arraycopy(value, offset, data, 0, length);
        this.put(name, data);
    }

    public void setObject(String name, Object value) throws JMSException {
        this.initializeWriting();
        if (value != null) {
            if (!(value instanceof byte[])) {
                this.checkValidObject(value);
            }
            this.put(name, value);
        } else {
            this.put(name, null);
        }
    }

    public boolean itemExists(String name) throws JMSException {
        this.initializeReading();
        return this.map.containsKey(name);
    }

    private void initializeReading() throws JMSException {
        this.loadContent();
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkReadOnlyBody();
        this.setContent(null);
    }

    public String toString() {
        return super.toString() + " ActiveMQMapMessage{ theTable = " + this.map + " }";
    }

    public Map<String, Object> getContentMap() throws JMSException {
        this.initializeReading();
        return this.map;
    }
}

