/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.message;

import jakarta.jms.JMSException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TextMessage;
import java.io.UnsupportedEncodingException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.message.StompJmsMessage;

public class StompJmsTextMessage
extends StompJmsMessage
implements TextMessage {
    protected String text;

    @Override
    public StompJmsMessage.JmsMsgType getMsgType() {
        if (this.text == null) {
            return StompJmsMessage.JmsMsgType.TEXT_NULL;
        }
        return StompJmsMessage.JmsMsgType.TEXT;
    }

    @Override
    public StompJmsMessage copy() throws JMSException {
        StompJmsTextMessage other = new StompJmsTextMessage();
        other.copy(this);
        return other;
    }

    private void copy(StompJmsTextMessage other) {
        super.copy(other);
        this.text = other.text;
    }

    public void setText(String text) throws MessageNotWriteableException {
        this.checkReadOnlyBody();
        this.text = text;
        this.setContent(null);
    }

    public String getText() throws JMSException {
        Buffer buffer = this.getContent();
        if (this.text == null && buffer != null) {
            this.text = new String(buffer.getData(), buffer.getOffset(), buffer.getLength());
            this.setContent(null);
        }
        return this.text;
    }

    @Override
    public void storeContent() throws JMSException {
        try {
            if (this.text == null) {
                this.setContent(new Buffer(0));
            } else {
                this.setContent(new Buffer(this.text.getBytes("UTF-8")));
            }
            this.getHeaderMap().put(Constants.TRANSFORMATION, this.getMsgType().buffer);
        }
        catch (UnsupportedEncodingException e) {
            throw StompJmsExceptionSupport.create(e.getMessage(), e);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public String toString() {
        return super.toString() + ":text=" + this.text;
    }
}

