/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.enforcer;

import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;

@Named(value="requireExtensionVersion")
public class RequireExtensionVersion
extends AbstractEnforcerRule {
    private static final Pattern ID_PATTERN = Pattern.compile("\\QcoreExtension>io.jenkins.tools.incrementals:git-changelist-maven-extension:\\E(.+)");
    private String version;
    private final PlexusContainer container;

    @Inject
    public RequireExtensionVersion(PlexusContainer container) {
        this.container = Objects.requireNonNull(container);
    }

    public void execute() throws EnforcerRuleException {
        List participants;
        try {
            participants = this.container.lookupList(AbstractMavenLifecycleParticipant.class);
        }
        catch (ComponentLookupException x) {
            this.getLog().warn((CharSequence)x.getMessage());
            return;
        }
        for (AbstractMavenLifecycleParticipant participant : participants) {
            Matcher m;
            ClassLoader loader = participant.getClass().getClassLoader();
            if (!(loader instanceof ClassRealm) || !(m = ID_PATTERN.matcher(((ClassRealm)loader).getId())).matches()) continue;
            this.enforceVersion("git-changelist-maven-extension", this.getVersion(), (ArtifactVersion)new DefaultArtifactVersion(m.group(1)));
        }
    }

    private void enforceVersion(String variableName, String requiredVersionRange, ArtifactVersion actualVersion) throws EnforcerRuleException {
        if (StringUtils.isEmpty((String)requiredVersionRange)) {
            throw new EnforcerRuleException(variableName + " version can't be empty.");
        }
        String msg = "Detected " + variableName + " Version: " + actualVersion;
        if (actualVersion.toString().equals(requiredVersionRange)) {
            this.getLog().debug((CharSequence)(msg + " is allowed in the range " + requiredVersionRange + "."));
        } else {
            try {
                VersionRange vr = VersionRange.createFromVersionSpec((String)requiredVersionRange);
                if (!RequireExtensionVersion.containsVersion(vr, actualVersion)) {
                    throw new EnforcerRuleException(msg + " is not in the allowed range " + RequireExtensionVersion.toString(vr) + ".");
                }
                this.getLog().debug((CharSequence)(msg + " is allowed in the range " + RequireExtensionVersion.toString(vr) + "."));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new EnforcerRuleException("The requested " + variableName + " version " + requiredVersionRange + " is invalid.", (Exception)((Object)e));
            }
        }
    }

    private static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            return allowedRange.containsVersion(theVersion);
        }
        int compareTo = recommendedVersion.compareTo((Object)theVersion);
        return compareTo <= 0;
    }

    private static String toString(VersionRange vr) {
        if (vr.getRecommendedVersion() != null) {
            return "[" + vr.getRecommendedVersion().toString() + ",)";
        }
        return vr.toString();
    }

    public String getCacheId() {
        if (StringUtils.isNotEmpty((String)this.version)) {
            return "" + this.version.hashCode();
        }
        return "0";
    }

    public final String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }
}

