/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.tools.incrementals.maven.util.PluginRef;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;

public class PluginRefList
extends ArrayList<PluginRef> {
    public static PluginRefList fromFile(File file) throws IOException {
        PluginRefList plugins = new PluginRefList();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line) || line.startsWith("#")) {
                    plugins.add(PluginRef.forComment(line));
                    continue;
                }
                plugins.add(PluginRef.fromString(line));
            }
        }
        return plugins;
    }

    @NonNull
    public List<Dependency> toDependencyList() {
        ArrayList<Dependency> depList = new ArrayList<Dependency>(this.size());
        for (PluginRef plugin : this) {
            depList.add(plugin.toDependency());
        }
        return depList;
    }

    public void writeToFile(@NonNull File dest) throws IOException {
        ArrayList<String> outputLines = new ArrayList<String>(this.size());
        for (PluginRef ref : this) {
            outputLines.add(ref.toPluginsTxtString());
        }
        FileUtils.writeLines((File)dest, outputLines);
    }
}

