/*
 * Decompiled with CFR 0.152.
 */
package akka.kamon.instrumentation;

import akka.actor.ActorCell;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cell;
import akka.kamon.instrumentation.ActorMonitor;
import akka.kamon.instrumentation.ActorMonitors;
import akka.kamon.instrumentation.ActorMonitors$;
import akka.kamon.instrumentation.CellInfo;
import akka.kamon.instrumentation.CellInfo$;
import java.io.Serializable;
import kamon.akka.Metrics;
import kamon.akka.Metrics$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class ActorMonitor$ {
    public static ActorMonitor$ MODULE$;

    static {
        new ActorMonitor$();
    }

    public ActorMonitor createActorMonitor(Cell cell, ActorSystem system, ActorRef ref, ActorRef parent, boolean actorCellCreation) {
        CellInfo cellInfo = CellInfo$.MODULE$.cellInfoFor(cell, system, ref, parent, actorCellCreation);
        if (cell instanceof ActorCell) {
            Metrics$.MODULE$.forSystem(system.name()).activeActors().increment();
        }
        ActorMonitor monitor = cellInfo.isRouter() ? ActorMonitors$.MODULE$.ContextPropagationOnly(cellInfo) : (cellInfo.isRoutee() && cellInfo.isTracked() ? this.createRouteeMonitor(cellInfo) : this.createRegularActorMonitor(cellInfo));
        return cellInfo.isTraced() ? new ActorMonitors.TracedMonitor(cellInfo, monitor) : monitor;
    }

    public ActorMonitor createRegularActorMonitor(CellInfo cellInfo) {
        ActorMonitor actorMonitor;
        if (cellInfo.isTracked() || !cellInfo.trackingGroups().isEmpty()) {
            None$ actorMetrics = cellInfo.isTracked() ? new Some((Object)Metrics$.MODULE$.forActor(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorClass().getName())) : None$.MODULE$;
            actorMonitor = new ActorMonitors.TrackedActor((Option<Metrics.ActorMetrics>)actorMetrics, this.trackingGroupMetrics(cellInfo), cellInfo.actorCellCreation(), cellInfo);
        } else {
            actorMonitor = ActorMonitors$.MODULE$.ContextPropagationOnly(cellInfo);
        }
        return actorMonitor;
    }

    public ActorMonitor createRouteeMonitor(CellInfo cellInfo) {
        Metrics.RouterMetrics routerMetrics = Metrics$.MODULE$.forRouter(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorClass().getName());
        return new ActorMonitors.TrackedRoutee(routerMetrics, this.trackingGroupMetrics(cellInfo), cellInfo.actorCellCreation(), cellInfo);
    }

    private Seq<Metrics.ActorGroupMetrics> trackingGroupMetrics(CellInfo cellInfo) {
        return (Seq)cellInfo.trackingGroups().map((Function1 & Serializable & scala.Serializable)groupName -> Metrics$.MODULE$.forGroup((String)groupName, cellInfo.systemName()), Seq$.MODULE$.canBuildFrom());
    }

    private ActorMonitor$() {
        MODULE$ = this;
    }
}

