/*
 * Decompiled with CFR 0.152.
 */
package kamon.akka;

import kamon.Kamon$;
import kamon.akka.Metrics;
import kamon.metric.Counter;
import kamon.metric.CounterMetric;
import kamon.metric.Histogram;
import kamon.metric.HistogramMetric;
import kamon.metric.MeasurementUnit$;
import kamon.metric.RangeSampler;
import kamon.metric.RangeSamplerMetric;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class Metrics$ {
    public static Metrics$ MODULE$;
    private final HistogramMetric actorTimeInMailboxMetric;
    private final HistogramMetric actorProcessingTimeMetric;
    private final RangeSamplerMetric actorMailboxSizeMetric;
    private final CounterMetric actorErrorsMetric;
    private final HistogramMetric routerRoutingTime;
    private final HistogramMetric routerTimeInMailbox;
    private final HistogramMetric routerProcessingTime;
    private final RangeSamplerMetric routerPendingMessages;
    private final RangeSamplerMetric routerMembers;
    private final CounterMetric routerErrors;
    private final HistogramMetric groupTimeInMailbox;
    private final HistogramMetric groupProcessingTime;
    private final RangeSamplerMetric groupPendingMessages;
    private final RangeSamplerMetric groupMembers;
    private final CounterMetric groupErrors;
    private final CounterMetric systemDeadLetters;
    private final CounterMetric systemUnhandledMessages;
    private final CounterMetric systemProcessedMessages;
    private final RangeSamplerMetric systemActiveActors;

    static {
        new Metrics$();
    }

    public HistogramMetric actorTimeInMailboxMetric() {
        return this.actorTimeInMailboxMetric;
    }

    public HistogramMetric actorProcessingTimeMetric() {
        return this.actorProcessingTimeMetric;
    }

    public RangeSamplerMetric actorMailboxSizeMetric() {
        return this.actorMailboxSizeMetric;
    }

    public CounterMetric actorErrorsMetric() {
        return this.actorErrorsMetric;
    }

    public Metrics.ActorMetrics forActor(String path, String system, String dispatcher, String actorClass) {
        Map actorTags = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"system"), (Object)system), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dispatcher"), (Object)dispatcher), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)actorClass)}));
        return new Metrics.ActorMetrics((Map<String, String>)actorTags, (Histogram)this.actorTimeInMailboxMetric().refine(actorTags), (Histogram)this.actorProcessingTimeMetric().refine(actorTags), (RangeSampler)this.actorMailboxSizeMetric().refine(actorTags), (Counter)this.actorErrorsMetric().refine(actorTags));
    }

    public HistogramMetric routerRoutingTime() {
        return this.routerRoutingTime;
    }

    public HistogramMetric routerTimeInMailbox() {
        return this.routerTimeInMailbox;
    }

    public HistogramMetric routerProcessingTime() {
        return this.routerProcessingTime;
    }

    public RangeSamplerMetric routerPendingMessages() {
        return this.routerPendingMessages;
    }

    public RangeSamplerMetric routerMembers() {
        return this.routerMembers;
    }

    public CounterMetric routerErrors() {
        return this.routerErrors;
    }

    public Metrics.RouterMetrics forRouter(String path, String system, String dispatcher, String routerClass, String routeeClass) {
        Map routerTags = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"system"), (Object)system), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dispatcher"), (Object)dispatcher), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routerClass"), (Object)routerClass), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"routeeClass"), (Object)routeeClass)}));
        return new Metrics.RouterMetrics((Map<String, String>)routerTags, (Histogram)this.routerRoutingTime().refine(routerTags), (Histogram)this.routerTimeInMailbox().refine(routerTags), (Histogram)this.routerProcessingTime().refine(routerTags), (RangeSampler)this.routerPendingMessages().refine(routerTags), (RangeSampler)this.routerMembers().refine(routerTags), (Counter)this.routerErrors().refine(routerTags));
    }

    public HistogramMetric groupTimeInMailbox() {
        return this.groupTimeInMailbox;
    }

    public HistogramMetric groupProcessingTime() {
        return this.groupProcessingTime;
    }

    public RangeSamplerMetric groupPendingMessages() {
        return this.groupPendingMessages;
    }

    public RangeSamplerMetric groupMembers() {
        return this.groupMembers;
    }

    public CounterMetric groupErrors() {
        return this.groupErrors;
    }

    public Metrics.ActorGroupMetrics forGroup(String group, String system) {
        Map actorTags = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group"), (Object)group), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"system"), (Object)system)}));
        return new Metrics.ActorGroupMetrics((Map<String, String>)actorTags, (Histogram)this.groupTimeInMailbox().refine(actorTags), (Histogram)this.groupProcessingTime().refine(actorTags), (RangeSampler)this.groupPendingMessages().refine(actorTags), (RangeSampler)this.groupMembers().refine(actorTags), (Counter)this.groupErrors().refine(actorTags));
    }

    public CounterMetric systemDeadLetters() {
        return this.systemDeadLetters;
    }

    public CounterMetric systemUnhandledMessages() {
        return this.systemUnhandledMessages;
    }

    public CounterMetric systemProcessedMessages() {
        return this.systemProcessedMessages;
    }

    public RangeSamplerMetric systemActiveActors() {
        return this.systemActiveActors;
    }

    public Metrics.ActorSystemMetrics forSystem(String name) {
        Map systemTags = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"system"), (Object)name)}));
        return new Metrics.ActorSystemMetrics((Map<String, String>)systemTags, (Counter)this.systemDeadLetters().refine(systemTags), (Counter)this.systemUnhandledMessages().refine(systemTags), (Counter)this.systemProcessedMessages().refine(systemTags.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tracked"), (Object)"true"))), (Counter)this.systemProcessedMessages().refine(systemTags.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tracked"), (Object)"false"))), (RangeSampler)this.systemActiveActors().refine(systemTags));
    }

    private Metrics$() {
        MODULE$ = this;
        this.actorTimeInMailboxMetric = Kamon$.MODULE$.histogram("akka.actor.time-in-mailbox", MeasurementUnit$.MODULE$.time().nanoseconds());
        this.actorProcessingTimeMetric = Kamon$.MODULE$.histogram("akka.actor.processing-time", MeasurementUnit$.MODULE$.time().nanoseconds());
        this.actorMailboxSizeMetric = Kamon$.MODULE$.rangeSampler("akka.actor.mailbox-size");
        this.actorErrorsMetric = Kamon$.MODULE$.counter("akka.actor.errors");
        this.routerRoutingTime = Kamon$.MODULE$.histogram("akka.router.routing-time", MeasurementUnit$.MODULE$.time().nanoseconds());
        this.routerTimeInMailbox = Kamon$.MODULE$.histogram("akka.router.time-in-mailbox", MeasurementUnit$.MODULE$.time().nanoseconds());
        this.routerProcessingTime = Kamon$.MODULE$.histogram("akka.router.processing-time", MeasurementUnit$.MODULE$.time().nanoseconds());
        this.routerPendingMessages = Kamon$.MODULE$.rangeSampler("akka.router.pending-messages");
        this.routerMembers = Kamon$.MODULE$.rangeSampler("akka.router.members");
        this.routerErrors = Kamon$.MODULE$.counter("akka.router.errors");
        this.groupTimeInMailbox = Kamon$.MODULE$.histogram("akka.group.time-in-mailbox", MeasurementUnit$.MODULE$.time().nanoseconds());
        this.groupProcessingTime = Kamon$.MODULE$.histogram("akka.group.processing-time", MeasurementUnit$.MODULE$.time().nanoseconds());
        this.groupPendingMessages = Kamon$.MODULE$.rangeSampler("akka.group.pending-messages");
        this.groupMembers = Kamon$.MODULE$.rangeSampler("akka.group.members");
        this.groupErrors = Kamon$.MODULE$.counter("akka.group.errors");
        this.systemDeadLetters = Kamon$.MODULE$.counter("akka.system.dead-letters");
        this.systemUnhandledMessages = Kamon$.MODULE$.counter("akka.system.unhandled-messages");
        this.systemProcessedMessages = Kamon$.MODULE$.counter("akka.system.processed-messages");
        this.systemActiveActors = Kamon$.MODULE$.rangeSampler("akka.system.active-actors");
    }
}

