/*
 * Decompiled with CFR 0.152.
 */
package kamon.akka.http.instrumentation;

import akka.NotUsed;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.Attributes;
import akka.stream.BidiShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kamon.Kamon$;
import kamon.akka.http.AkkaHttp$;
import kamon.akka.http.AkkaHttpMetrics$;
import kamon.akka.http.instrumentation.ServerFlowWrapper$;
import kamon.akka.http.instrumentation.ServerFlowWrapper$$anon$1$;
import kamon.context.Context;
import kamon.context.TextMap;
import kamon.metric.RangeSampler;
import kamon.trace.Span;
import kamon.trace.Span$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ServerFlowWrapper$ {
    public static ServerFlowWrapper$ MODULE$;

    static {
        new ServerFlowWrapper$();
    }

    public GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>> wrap(String string, int port) {
        return new GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>>(string, port){
            private final RangeSampler openConnections;
            private final RangeSampler activeRequests;
            private final Inlet<HttpRequest> requestIn;
            private final Outlet<HttpRequest> requestOut;
            private final Inlet<HttpResponse> responseIn;
            private final Outlet<HttpResponse> responseOut;
            private final BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape;

            public RangeSampler openConnections() {
                return this.openConnections;
            }

            public RangeSampler activeRequests() {
                return this.activeRequests;
            }

            public Inlet<HttpRequest> requestIn() {
                return this.requestIn;
            }

            public Outlet<HttpRequest> requestOut() {
                return this.requestOut;
            }

            public Inlet<HttpResponse> responseIn() {
                return this.responseIn;
            }

            public Outlet<HttpResponse> responseOut() {
                return this.responseOut;
            }

            public BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new GraphStageLogic(this){
                    private final /* synthetic */ anon.1 $outer;

                    public void preStart() {
                        this.$outer.openConnections().increment();
                    }

                    public void postStop() {
                        this.$outer.openConnections().decrement();
                    }

                    public /* synthetic */ anon.1 kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.setHandler($outer.requestIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                            }

                            public void onPush() {
                                HttpRequest request = (HttpRequest)this.$outer.grab(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                                Context parentContext = ServerFlowWrapper$.MODULE$.kamon$akka$http$instrumentation$ServerFlowWrapper$$extractContext(request);
                                Span span = Kamon$.MODULE$.buildSpan(AkkaHttp$.MODULE$.serverOperationName(request)).asChildOf((Span)parentContext.get(Span$.MODULE$.ContextKey())).withMetricTag("span.kind", "server").withTag("component", "akka.http.server").withTag("http.method", request.method().value()).withTag("http.url", request.uri().toString()).start();
                                this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().activeRequests().increment();
                                Kamon$.MODULE$.storeContext(parentContext.withKey(Span$.MODULE$.ContextKey(), (Object)span));
                                this.$outer.push(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().requestOut(), request);
                            }

                            public void onUpstreamFinish() {
                                this.$outer.complete(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().requestOut());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.$init$((InHandler)this);
                            }
                        });
                        this.setHandler($outer.requestOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                            }

                            public void onDownstreamFinish() {
                                this.$outer.cancel(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.$init$((OutHandler)this);
                            }
                        });
                        this.setHandler($outer.responseIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                            }

                            public void onPush() {
                                HttpResponse response = (HttpResponse)this.$outer.grab(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                                int status = response.status().intValue();
                                Span span = AkkaHttp$.MODULE$.addHttpStatusCodeAsMetricTag() ? Kamon$.MODULE$.currentSpan().tagMetric("http.status_code", ((Object)BoxesRunTime.boxToInteger((int)status)).toString()) : Kamon$.MODULE$.currentSpan().tag("http.status_code", (long)status);
                                Object object = status == 404 ? span.setOperationName("unhandled") : BoxedUnit.UNIT;
                                Object object2 = status >= 500 && status <= 599 ? span.addError(response.status().reason()) : BoxedUnit.UNIT;
                                this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().activeRequests().decrement();
                                span.finish();
                                this.$outer.push(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().responseOut(), ServerFlowWrapper$.MODULE$.kamon$akka$http$instrumentation$ServerFlowWrapper$$includeTraceToken(response, Kamon$.MODULE$.currentContext()));
                            }

                            public void onUpstreamFinish() {
                                this.$outer.completeStage();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.$init$((InHandler)this);
                            }
                        });
                        this.setHandler($outer.responseOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                            }

                            public void onDownstreamFinish() {
                                this.$outer.cancel(this.$outer.kamon$akka$http$instrumentation$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.$init$((OutHandler)this);
                            }
                        });
                    }
                };
            }
            {
                this.openConnections = (RangeSampler)AkkaHttpMetrics$.MODULE$.OpenConnections().refine((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interface"), (Object)interface$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"port"), (Object)((Object)BoxesRunTime.boxToInteger((int)port$1)).toString())}));
                this.activeRequests = (RangeSampler)AkkaHttpMetrics$.MODULE$.ActiveRequests().refine((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interface"), (Object)interface$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"port"), (Object)((Object)BoxesRunTime.boxToInteger((int)port$1)).toString())}));
                this.requestIn = Inlet$.MODULE$.create("request.in");
                this.requestOut = Outlet$.MODULE$.create("request.out");
                this.responseIn = Inlet$.MODULE$.create("response.in");
                this.responseOut = Outlet$.MODULE$.create("response.out");
                this.shape = new BidiShape(this.requestIn(), this.requestOut(), this.responseIn(), this.responseOut());
            }
        };
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> apply(Flow<HttpRequest, HttpResponse, NotUsed> flow, String string, int port) {
        return BidiFlow$.MODULE$.fromGraph(this.wrap(string, port)).join(flow);
    }

    public HttpResponse kamon$akka$http$instrumentation$ServerFlowWrapper$$includeTraceToken(HttpResponse response, Context context) {
        HttpResponse httpResponse;
        HttpResponse httpResponse2 = response;
        if (httpResponse2 != null) {
            HttpResponse httpResponse3 = httpResponse2;
            httpResponse = httpResponse3.withHeaders((scala.collection.immutable.Seq)httpResponse3.headers().$plus$plus((GenTraversableOnce)((TextMap)Kamon$.MODULE$.contextCodec().HttpHeaders().encode(context)).values().map((Function1 & Serializable & scala.Serializable)k -> new RawHeader((String)k._1(), (String)k._2())), Seq$.MODULE$.canBuildFrom()));
        } else {
            httpResponse = httpResponse2;
        }
        return httpResponse;
    }

    public Context kamon$akka$http$instrumentation$ServerFlowWrapper$$extractContext(HttpRequest request) {
        return Kamon$.MODULE$.contextCodec().HttpHeaders().decode((Object)new TextMap(request){
            private final Map<String, String> headersKeyValueMap;

            private Map<String, String> headersKeyValueMap() {
                return this.headersKeyValueMap;
            }

            public Iterator<Tuple2<String, String>> values() {
                return this.headersKeyValueMap().iterator();
            }

            public Option<String> get(String key) {
                return this.headersKeyValueMap().get((Object)key);
            }

            public void put(String key, String value) {
            }
            {
                this.headersKeyValueMap = ((TraversableOnce)request$1.headers().map((Function1 & Serializable & scala.Serializable)h -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.name()), (Object)h.value()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$headersKeyValueMap$1(akka.http.scaladsl.model.HttpHeader )}, serializedLambda);
            }
        });
    }

    private ServerFlowWrapper$() {
        MODULE$ = this;
    }
}

