/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.kamon.instrumentation.akka.instrumentations.akka_26.remote;

import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.OutboundEnvelope;
import akka.serialization.Serialization;
import java.nio.ByteBuffer;
import kamon.Kamon$;
import kamon.context.BinaryPropagation;
import kamon.context.Context;
import kamon.instrumentation.akka.AkkaRemoteMetrics;
import kamon.instrumentation.akka.AkkaRemoteMetrics$;
import kamon.instrumentation.context.HasContext;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public final class SerializeForArteryAdvice$ {
    public static SerializeForArteryAdvice$ MODULE$;

    static {
        new SerializeForArteryAdvice$();
    }

    @Advice.OnMethodEnter
    public long enter() {
        return System.nanoTime();
    }

    @Advice.OnMethodExit
    public void exit(@Advice.Argument(value=0) Serialization serialization, @Advice.Argument(value=1) OutboundEnvelope envelope, @Advice.Argument(value=3) EnvelopeBuffer envelopeBuffer, @Advice.Enter long startTime) {
        AkkaRemoteMetrics.SerializationInstruments instruments = AkkaRemoteMetrics$.MODULE$.serializationInstruments(serialization.system().name());
        ByteBuffer messageBuffer = envelopeBuffer.byteBuffer();
        Context context = ((HasContext)envelope).context();
        int positionBeforeContext = messageBuffer.position();
        if (context.nonEmpty()) {
            Kamon$.MODULE$.defaultBinaryPropagation().write(context, (Object)this.byteBufferWriter(messageBuffer));
        }
        instruments.serializationTime().record(System.nanoTime() - startTime);
        instruments.outboundMessageSize().record((long)positionBeforeContext);
        int contextSize = messageBuffer.position() - positionBeforeContext;
        messageBuffer.putInt(contextSize);
    }

    public BinaryPropagation.ByteStreamWriter byteBufferWriter(ByteBuffer bb) {
        return new BinaryPropagation.ByteStreamWriter(bb){
            private final ByteBuffer bb$1;

            public void write(byte[] bytes) {
                this.bb$1.put(bytes);
            }

            public void write(byte[] bytes, int offset, int count) {
                this.bb$1.put(bytes, offset, count);
            }

            public void write(int n) {
                this.bb$1.put((byte)n);
            }
            {
                this.bb$1 = bb$1;
            }
        };
    }

    private SerializeForArteryAdvice$() {
        MODULE$ = this;
    }
}

