/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.mongo;

import com.mongodb.MongoNamespace;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import kamon.Kamon;
import kamon.context.Context;
import kamon.instrumentation.context.HasContext;
import kamon.instrumentation.mongo.MongoClientInstrumentation;
import kamon.trace.Span;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public class ExecuteAsyncOperationAdvice {
    @Advice.OnMethodEnter
    public static <T> void enter(@Advice.This Object object, @Advice.FieldValue(value="namespace") MongoNamespace mongoNamespace, @Advice.Origin(value="#t") String string, @Advice.Argument(value=1, readOnly=false) SingleResultCallback<T> singleResultCallback) {
        String string2 = object instanceof MongoClientInstrumentation.HasOperationName ? ((MongoClientInstrumentation.HasOperationName)object).name() : string;
        Span span = MongoClientInstrumentation.clientSpanBuilder(mongoNamespace, string2).start();
        singleResultCallback = ExecuteAsyncOperationAdvice.spanCompletingCallback(singleResultCallback, Kamon.currentContext().withEntry(Span.Key(), (Object)span));
    }

    public static <T> SingleResultCallback<T> spanCompletingCallback(final SingleResultCallback<T> singleResultCallback, final Context context) {
        return new SingleResultCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResult(T t, Throwable throwable) {
                try {
                    Span span = (Span)context.get(Span.Key());
                    if (t != null) {
                        if (t instanceof BulkWriteResult) {
                            BulkWriteResult bulkWriteResult = (BulkWriteResult)t;
                            span.tag("mongo.bulk.ack", bulkWriteResult.wasAcknowledged()).tag("mongo.bulk.inserted", (long)bulkWriteResult.getInsertedCount()).tag("mongo.bulk.modified", (long)bulkWriteResult.getModifiedCount()).tag("mongo.bulk.matched", (long)bulkWriteResult.getMatchedCount()).tag("mongo.bulk.deleted", (long)bulkWriteResult.getDeletedCount());
                        }
                        if (t instanceof AsyncBatchCursor && t instanceof HasContext) {
                            ((HasContext)t).setContext(Context.of((Context.Key)Span.Key(), (Object)span));
                        }
                        span.finish();
                    } else {
                        span.fail(throwable).finish();
                    }
                }
                finally {
                    singleResultCallback.onResult(t, throwable);
                }
            }
        };
    }
}

