/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.function.Supplier;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.freebsd.FreeBsdBaseboard;
import oshi.hardware.platform.unix.freebsd.FreeBsdFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

final class FreeBsdComputerSystem
extends AbstractComputerSystem {
    private final Supplier<DmidecodeStrings> readDmiDecode = Memoizer.memoize(this::readDmiDecode);

    FreeBsdComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.readDmiDecode.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.readDmiDecode.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.readDmiDecode.get().serialNumber;
    }

    @Override
    public Firmware createFirmware() {
        return new FreeBsdFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new FreeBsdBaseboard(this.readDmiDecode.get().manufacturer, this.readDmiDecode.get().model, this.readDmiDecode.get().serialNumber, this.readDmiDecode.get().version);
    }

    private DmidecodeStrings readDmiDecode() {
        String manufacturer = null;
        String model = null;
        String version = null;
        String serialNumber = null;
        String manufacturerMarker = "Manufacturer:";
        String productNameMarker = "Product Name:";
        String versionMarker = "Version:";
        String serialNumMarker = "Serial Number:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            if (checkLine.contains("Manufacturer:")) {
                manufacturer = checkLine.split("Manufacturer:")[1].trim();
            }
            if (checkLine.contains("Product Name:")) {
                model = checkLine.split("Product Name:")[1].trim();
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
            }
            if (!checkLine.contains("Serial Number:")) continue;
            serialNumber = checkLine.split("Serial Number:")[1].trim();
        }
        if (Util.isBlank(serialNumber)) {
            serialNumber = this.getSystemSerialNumber();
        }
        return new DmidecodeStrings(manufacturer, model, version, serialNumber);
    }

    private String getSystemSerialNumber() {
        String marker = "system.hardware.serial =";
        for (String checkLine : ExecutingCommand.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            return ParseUtil.getSingleQuoteStringValue(checkLine);
        }
        return "unknown";
    }

    private static final class DmidecodeStrings {
        private final String manufacturer;
        private final String model;
        private final String version;
        private final String serialNumber;

        private DmidecodeStrings(String manufacturer, String model, String version, String serialNumber) {
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = Util.isBlank(model) ? "unknown" : model;
            this.version = Util.isBlank(version) ? "unknown" : version;
            this.serialNumber = Util.isBlank(serialNumber) ? "unknown" : serialNumber;
        }
    }
}

