/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.futures.scala;

import java.io.Serializable;
import java.time.Instant;
import kamon.Kamon$;
import kamon.instrumentation.futures.scala.CallbackRunnableRunInstrumentation$;
import kamon.instrumentation.futures.scala.ScalaFutureInstrumentation;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanBuilder;
import kamon.util.CallingThreadExecutionContext$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class ScalaFutureInstrumentation$ {
    public static ScalaFutureInstrumentation$ MODULE$;
    private final String Component;

    static {
        new ScalaFutureInstrumentation$();
    }

    public String Component() {
        return this.Component;
    }

    public <T> Future<T> trace(String operationName, TagSet tags, TagSet metricTags, Function0<Future<T>> future, ScalaFutureInstrumentation.Settings settings) {
        SpanBuilder spanBuilder = Kamon$.MODULE$.internalSpanBuilder(operationName, this.Component());
        if (tags.nonEmpty()) {
            spanBuilder.tag(tags);
        }
        if (metricTags.nonEmpty()) {
            spanBuilder.tagMetrics(metricTags);
        }
        return this.trace(spanBuilder, future, settings);
    }

    public <T> Future<T> trace(SpanBuilder spanBuilder, Function0<Future<T>> future, ScalaFutureInstrumentation.Settings settings) {
        if (settings.trackMetrics()) {
            spanBuilder.trackMetrics();
        } else {
            spanBuilder.doNotTrackMetrics();
        }
        Span futureSpan = spanBuilder.start();
        Future evaluatedFuture = (Future)Kamon$.MODULE$.runWithSpan(futureSpan, false, future);
        evaluatedFuture.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScalaFutureInstrumentation$.$anonfun$trace$1(futureSpan, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
        return evaluatedFuture;
    }

    public <T> TagSet trace$default$2() {
        return TagSet$.MODULE$.Empty();
    }

    public <T> TagSet trace$default$3() {
        return TagSet$.MODULE$.Empty();
    }

    public <S> S traceBody(String operationName, TagSet tags, TagSet metricTags, Function0<S> body, ScalaFutureInstrumentation.Settings settings) {
        SpanBuilder spanBuilder = Kamon$.MODULE$.internalSpanBuilder(operationName, this.Component());
        if (tags.nonEmpty()) {
            spanBuilder.tag(tags);
        }
        if (metricTags.nonEmpty()) {
            spanBuilder.tagMetrics(metricTags);
        }
        return this.traceBody(spanBuilder, body, settings);
    }

    public <S> S traceBody(SpanBuilder spanBuilder, Function0<S> body, ScalaFutureInstrumentation.Settings settings) {
        Object object;
        Span span = this.startedSpan(spanBuilder, settings);
        Kamon$.MODULE$.storeContext(Kamon$.MODULE$.currentContext().withEntry(Span$.MODULE$.Key(), (Object)span));
        try {
            try {
                object = body.apply();
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable error = (Throwable)option.get();
                    span.fail(error.getMessage(), error);
                    throw error;
                }
                throw throwable;
            }
        }
        finally {
            span.finish();
        }
        return (S)object;
    }

    public <S> TagSet traceBody$default$2() {
        return TagSet$.MODULE$.Empty();
    }

    public <S> TagSet traceBody$default$3() {
        return TagSet$.MODULE$.Empty();
    }

    public <T, S> Function1<T, S> traceFunc(String operationName, TagSet tags, TagSet metricTags, Function1<T, S> body, ScalaFutureInstrumentation.Settings settings) {
        SpanBuilder spanBuilder = Kamon$.MODULE$.internalSpanBuilder(operationName, this.Component());
        if (tags.nonEmpty()) {
            spanBuilder.tag(tags);
        }
        if (metricTags.nonEmpty()) {
            spanBuilder.tagMetrics(metricTags);
        }
        return this.traceFunc(spanBuilder, body, settings);
    }

    public <T, S> Function1<T, S> traceFunc(SpanBuilder spanBuilder, Function1<T, S> body, ScalaFutureInstrumentation.Settings settings) {
        return (Function1 & Serializable & scala.Serializable)t -> {
            Object object;
            Span span = MODULE$.startedSpan(spanBuilder, settings);
            Kamon$.MODULE$.storeContext(Kamon$.MODULE$.currentContext().withEntry(Span$.MODULE$.Key(), (Object)span));
            try {
                try {
                    object = body.apply(t);
                }
                catch (Throwable throwable) {
                    Option option = NonFatal$.MODULE$.unapply(throwable);
                    if (!option.isEmpty()) {
                        Throwable error = (Throwable)option.get();
                        span.fail(error.getMessage(), error);
                        throw error;
                    }
                    throw throwable;
                }
            }
            finally {
                span.finish();
            }
            return object;
        };
    }

    public <T, S> TagSet traceFunc$default$2() {
        return TagSet$.MODULE$.Empty();
    }

    public <T, S> TagSet traceFunc$default$3() {
        return TagSet$.MODULE$.Empty();
    }

    private Span startedSpan(SpanBuilder spanBuilder, ScalaFutureInstrumentation.Settings settings) {
        Span span;
        Option<Object> option = CallbackRunnableRunInstrumentation$.MODULE$.currentRunnableScheduleTimestamp();
        if (option instanceof Some) {
            long timestamp = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            Instant scheduledAt = Kamon$.MODULE$.clock().toInstant(timestamp);
            Span.Delayed span2 = spanBuilder.delay(scheduledAt);
            if (!settings.trackMetrics()) {
                span2.doNotTrackMetrics();
            }
            if (!settings.trackDelayedSpanMetrics()) {
                span2.doNotTrackDelayedSpanMetrics();
            }
            span = span2.start();
        } else if (None$.MODULE$.equals(option)) {
            if (!settings.trackMetrics()) {
                spanBuilder.doNotTrackMetrics();
            }
            span = spanBuilder.start();
        } else {
            throw new MatchError(option);
        }
        return span;
    }

    public static final /* synthetic */ void $anonfun$trace$1(Span futureSpan$1, Try x0$1) {
        if (x0$1 instanceof Success) {
            futureSpan$1.finish();
            return;
        }
        if (x0$1 instanceof Failure) {
            Throwable failure = ((Failure)x0$1).exception();
            futureSpan$1.fail(failure).finish();
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    private ScalaFutureInstrumentation$() {
        MODULE$ = this;
        this.Component = "scala.future";
    }
}

