/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import java.time.Instant;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.DatabaseTags;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.HasDatabaseTags;
import kamon.instrumentation.jdbc.JdbcMetrics$;
import kamon.instrumentation.jdbc.StatementMonitor;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import kamon.metric.RangeSampler;
import kamon.tag.Lookups$;
import kamon.tag.Tag;
import kamon.tag.TagSet$;
import kamon.trace.SpanBuilder;
import kanela.agent.bootstrap.stack.CallStackDepth;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public final class StatementMonitor$
implements LoggingSupport {
    public static StatementMonitor$ MODULE$;
    private final Logger logger;

    static {
        new StatementMonitor$();
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport.logInfo$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport.logWarn$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport.logError$(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport.logTrace$(this, msg);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Option<StatementMonitor.Invocation> start(Object statement, String sql, String statementType) {
        if (CallStackDepth.incrementFor((Object)statement) == 0) {
            void var10_10;
            void var9_9;
            Tuple2 tuple2;
            HasConnectionPoolTelemetry hasConnectionPoolTelemetry;
            Instant startTimestamp = Kamon$.MODULE$.clock().instant();
            if (statement instanceof HasConnectionPoolTelemetry && (hasConnectionPoolTelemetry = (HasConnectionPoolTelemetry)statement).connectionPoolTelemetry() != null && hasConnectionPoolTelemetry.connectionPoolTelemetry().get() != null) {
                ConnectionPoolTelemetry poolTelemetry = hasConnectionPoolTelemetry.connectionPoolTelemetry().get();
                tuple2 = new Tuple2((Object)poolTelemetry.instruments().inFlightStatements(), (Object)poolTelemetry.databaseTags());
            } else {
                HasDatabaseTags hasDatabaseTags;
                tuple2 = statement instanceof HasDatabaseTags && (hasDatabaseTags = (HasDatabaseTags)statement).databaseTags() != null ? new Tuple2(JdbcMetrics$.MODULE$.InFlightStatements().withTags(hasDatabaseTags.databaseTags().metricTags()), (Object)hasDatabaseTags.databaseTags()) : new Tuple2((Object)JdbcMetrics$.MODULE$.InFlightStatements().withoutTags(), (Object)new DatabaseTags(TagSet$.MODULE$.Empty(), TagSet$.MODULE$.Empty()));
            }
            RangeSampler inFlightRangeSampler = (RangeSampler)tuple2._1();
            DatabaseTags databaseTags = (DatabaseTags)tuple2._2();
            if (inFlightRangeSampler == null || databaseTags == null) {
                throw new MatchError((Object)tuple2);
            }
            void inFlightRangeSampler2 = var9_9;
            void databaseTags2 = var10_10;
            SpanBuilder clientSpan = Kamon$.MODULE$.clientSpanBuilder(statementType, "jdbc").tag("db.statement", sql);
            databaseTags2.spanTags().iterator().foreach(arg_0 -> StatementMonitor$.$anonfun$start$1(clientSpan, (DatabaseTags)databaseTags2, arg_0));
            databaseTags2.metricTags().iterator().foreach(arg_0 -> StatementMonitor$.$anonfun$start$2(clientSpan, (DatabaseTags)databaseTags2, arg_0));
            inFlightRangeSampler2.increment();
            return new Some((Object)new StatementMonitor.Invocation(statement, clientSpan.start(startTimestamp), sql, startTimestamp, (RangeSampler)inFlightRangeSampler2));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ SpanBuilder $anonfun$start$1(SpanBuilder clientSpan$1, DatabaseTags databaseTags$1, Tag t) {
        return clientSpan$1.tag(t.key(), (String)databaseTags$1.spanTags().get(Lookups$.MODULE$.coerce(t.key())));
    }

    public static final /* synthetic */ SpanBuilder $anonfun$start$2(SpanBuilder clientSpan$1, DatabaseTags databaseTags$1, Tag t) {
        return clientSpan$1.tagMetrics(t.key(), (String)databaseTags$1.metricTags().get(Lookups$.MODULE$.coerce(t.key())));
    }

    private StatementMonitor$() {
        MODULE$ = this;
        LoggingSupport.$init$(this);
    }
}

