/*
 * Decompiled with CFR 0.152.
 */
package kamon.annotation.instrumentation.advisor;

import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import kamon.annotation.instrumentation.cache.AnnotationCache;
import kamon.annotation.util.Hooks;
import kamon.metric.RangeSampler;
import kamon.util.CallingThreadExecutionContext$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import kanela.agent.libs.net.bytebuddy.implementation.bytecode.assign.Assigner;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public final class TrackConcurrencyAnnotationAdvisor {
    public static final ExecutionContext CallingThreadEC = CallingThreadExecutionContext$.MODULE$;

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void increment(@Advice.This(optional=true) Object object, @Advice.Origin Class<?> clazz, @Advice.Origin Method method, @Advice.Origin(value="#t") String string, @Advice.Origin(value="#m") String string2, @Advice.Local(value="rangeSampler") RangeSampler rangeSampler) {
        RangeSampler rangeSampler2 = AnnotationCache.getRangeSampler(method, object, clazz, string, string2);
        rangeSampler2.increment();
        rangeSampler = rangeSampler2;
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    public static void decrement(@Advice.Local(value="rangeSampler") RangeSampler rangeSampler, @Advice.Return(typing=Assigner.Typing.DYNAMIC) Object object) {
        if (object instanceof Future) {
            Hooks.decrementRangeSamplerOnComplete((Future)object, rangeSampler);
        } else if (object instanceof CompletionStage) {
            ((CompletionStage)object).handle(new CompletionStageCompleteFunction(rangeSampler));
        } else {
            rangeSampler.decrement();
        }
    }

    public static class CompletionStageCompleteFunction<T>
    implements BiFunction<T, Throwable, Object> {
        private final RangeSampler rangeSampler;

        public CompletionStageCompleteFunction(RangeSampler rangeSampler) {
            this.rangeSampler = rangeSampler;
        }

        @Override
        public Object apply(T t, Throwable throwable) {
            this.rangeSampler.decrement();
            return null;
        }
    }
}

