/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.instrumentations;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.Envelope;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.akka.AkkaMetrics;
import kamon.instrumentation.akka.AkkaMetrics$;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo$;
import kamon.instrumentation.akka.instrumentations.ActorMonitor$;
import kamon.instrumentation.akka.instrumentations.AkkaPrivateAccess;
import kamon.metric.Counter;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.util.Clock;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\r\rga\u00026l!\u0003\r\n\u0001\u001e\u0005\u0006w\u00021\t\u0001 \u0005\b\u0003\u000f\u0001a\u0011AA\u0005\u0011\u001d\t\t\u0002\u0001D\u0001\u0003\u0013Aq!a\u0005\u0001\r\u0003\t)\u0002C\u0004\u00026\u00011\t!a\u000e\t\u000f\u0005-\u0003A\"\u0001\u0002N!9\u00111\u000e\u0001\u0007\u0002\u00055\u0004bBA:\u0001\u0019\u0005\u0011Q\u000f\u0005\b\u0003o\u0002a\u0011AA;\u000f\u001d\tIh\u001bE\u0001\u0003w2aA[6\t\u0002\u0005}\u0004bBAA\u0017\u0011\u0005\u00111\u0011\u0005\b\u0003\u000b[A\u0011AAD\u0011\u001d\tik\u0003C\u0005\u0003_Cq!!<\f\t\u0013\ty\u000fC\u0004\u0002v.!I!a>\u0007\r\t52\u0002\u0001B\u0018\u0011)\t\u0019,\u0005B\u0001B\u0003%\u0011Q\u0017\u0005\u000b\u0005c\t\"\u0011!Q\u0001\n\u0005}\u0006B\u0003B\u001a#\t\u0005\t\u0015!\u0003\u0002\n\"9\u0011\u0011Q\t\u0005\u0002\tU\u0002\"\u0003B!#\t\u0007I\u0011\u0002B\"\u0011!\u0011\u0019&\u0005Q\u0001\n\t\u0015\u0003\"\u0003B+#\t\u0007I\u0011\u0002B,\u0011!\u0011I&\u0005Q\u0001\n\u0005e\bbBA\u0004#\u0011\u0005\u0013\u0011\u0002\u0005\u0006wF!\t\u0005 \u0005\b\u0003#\tB\u0011IA\u0005\u0011\u001d\t\u0019\"\u0005C!\u00057Bq!!\u000e\u0012\t\u0003\u0012\u0019\u0007C\u0004\u0002LE!\tE!\u001c\t\u000f\u0005-\u0014\u0003\"\u0011\u0003r!9\u00111O\t\u0005B\u0005U\u0004bBA<#\u0011\u0005\u0013Q\u000f\u0005\b\u0005k\nB\u0011\u0002B<\u0011\u001d\u0011)*\u0005C\u0005\u0005/3aA!)\u0012\t\t\r\u0006B\u0003BSK\t\u0015\r\u0011\"\u0001\u0003(\"Q!qV\u0013\u0003\u0002\u0003\u0006IA!+\t\u0015\tEVE!b\u0001\n\u0003\u0011\u0019\f\u0003\u0006\u00036\u0016\u0012\t\u0011)A\u0005\u0003/Aq!!!&\t\u0003\u00119L\u0002\u0004\u0003B.\u0001!1\u0019\u0005\u000b\u0003g[#\u0011!Q\u0001\n\u0005U\u0006BCAdW\t\u0005\t\u0015!\u0003\u0002@\"Q!QY\u0016\u0003\u0002\u0003\u0006I!a0\t\u000f\u0005\u00055\u0006\"\u0001\u0003H\"I!\u0011[\u0016C\u0002\u0013%!1\u001b\u0005\t\u0005?\\\u0003\u0015!\u0003\u0003V\"9\u0011qA\u0016\u0005B\u0005%\u0001\"B>,\t\u0003b\bbBA\tW\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003'YC\u0011\tBq\u0011\u001d\t)d\u000bC!\u0005SDq!a\u0013,\t\u0003\u0012\u0019\u0010C\u0004\u0002l-\"\tEa>\t\u000f\u0005M4\u0006\"\u0011\u0002v!9\u0011qO\u0016\u0005\u0002\u0005UdA\u0002B~\u0017\u0001\u0011i\u0010\u0003\u0006\u0004Pm\u0012\t\u0011)A\u0005\u0007#B!\"a3<\u0005\u0003\u0005\u000b\u0011BAg\u0011)\t\u0019l\u000fB\u0001B\u0003%\u0011Q\u0017\u0005\b\u0003\u0003[D\u0011AB/\u0011%\u00199g\u000fb\u0001\n\u0013\u0019I\u0007\u0003\u0005\u0004xm\u0002\u000b\u0011BB6\u0011\u001d\t9a\u000fC!\u0003\u0013AQa_\u001e\u0005BqDq!a\u0005<\t\u0003\u001aI\bC\u0004\u00026m\"\te!!\t\u000f\u0005-3\b\"\u0011\u0004\f\"9\u0011qO\u001e\u0005B\u0005UdABBH\u0017\u0001\u0019\t\n\u0003\u0006\u0004\u0014\"\u0013\t\u0011)A\u0005\u0007+C!\"a3I\u0005\u0003\u0005\u000b\u0011BAg\u0011)\t\u0019\f\u0013B\u0001B\u0003%\u0011Q\u0017\u0005\b\u0003\u0003CE\u0011ABN\u0011%\u0019)\u000b\u0013b\u0001\n\u0013\u0019I\u0007\u0003\u0005\u0004(\"\u0003\u000b\u0011BB6\u0011\u0015Y\b\n\"\u0011}\u0011\u001d\t\u0019\u0002\u0013C!\u0007SCq!!\u000eI\t\u0003\u001a\t\fC\u0004\u0002L!#\tea/\t\u000f\u0005-\u0004\n\"\u0011\u0004@\"9\u0011q\u000f%\u0005B\u0005UdaBB\u0001\u0017\u0005\u000511\u0001\u0005\u000b\u0003\u0017,&\u0011!Q\u0001\n\u00055\u0007BCAZ+\n\u0005\t\u0015!\u0003\u00026\"9\u0011\u0011Q+\u0005\u0002\r\u0015\u0001\"CB\u0006+\u0002\u0007I\u0011BB\u0007\u0011%\u0019y!\u0016a\u0001\n\u0013\u0019\t\u0002\u0003\u0005\u0004\u0018U\u0003\u000b\u0015BA`\u0011%\u0019\t#\u0016b\u0001\n\u0013\u0019i\u0001\u0003\u0005\u0004$U\u0003\u000b\u0011BA`\u0011%\u0019)#\u0016b\u0001\n#\u00199\u0003\u0003\u0005\u00046U\u0003\u000b\u0011BB\u0015\u0011%\u00199$\u0016b\u0001\n#\u0011\u0019\u000e\u0003\u0005\u0004:U\u0003\u000b\u0011\u0002Bk\u0011\u001d\t9!\u0016C!\u0003\u0013AQa_+\u0005BqDq!!\u0005V\t\u0003\nI\u0001C\u0004\u0002LU#\tea\u000f\t\u000f\u0005-T\u000b\"\u0011\u0004@!911I+\u0005\u0012\r\u0015\u0003bBA:+\u0012\u0005\u0013Q\u000f\u0005\b\u0003o*F\u0011AA;\u00051\t5\r^8s\u001b>t\u0017\u000e^8s\u0015\taW.\u0001\tj]N$(/^7f]R\fG/[8og*\u0011an\\\u0001\u0005C.\\\u0017M\u0003\u0002qc\u0006y\u0011N\\:ueVlWM\u001c;bi&|gNC\u0001s\u0003\u0015Y\u0017-\\8o\u0007\u0001\u0019\"\u0001A;\u0011\u0005YLX\"A<\u000b\u0003a\fQa]2bY\u0006L!A_<\u0003\r\u0005s\u0017PU3g\u0003Y\u0019\u0017\r\u001d;ve\u0016,eN^3m_B,7i\u001c8uKb$H#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!]\u0001\bG>tG/\u001a=u\u0013\r\t)a \u0002\b\u0007>tG/\u001a=u\u0003a\u0019\u0017\r\u001d;ve\u0016,eN^3m_B,G+[7fgR\fW\u000e\u001d\u000b\u0003\u0003\u0017\u00012A^A\u0007\u0013\r\tya\u001e\u0002\u0005\u0019>tw-A\u0010dCB$XO]3Qe>\u001cWm]:j]\u001e\u001cF/\u0019:u)&lWm\u001d;b[B\f\u0001d\u001c8NKN\u001c\u0018mZ3Qe>\u001cWm]:j]\u001e\u001cF/\u0019:u)!\t9\"!\b\u0002 \u0005\r\u0002c\u0001<\u0002\u001a%\u0019\u00111D<\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002\u0002\u0011\u0001\r! \u0005\b\u0003C!\u0001\u0019AA\u0006\u0003E)gN^3m_B,G+[7fgR\fW\u000e\u001d\u0005\b\u0003K!\u0001\u0019AA\u0014\u0003!)gN^3m_B,\u0007\u0003BA\u0015\u0003ci!!a\u000b\u000b\t\u00055\u0012qF\u0001\tI&\u001c\b/\u0019;dQ*\ta.\u0003\u0003\u00024\u0005-\"\u0001C#om\u0016dw\u000e]3\u0002-=tW*Z:tC\u001e,\u0007K]8dKN\u001c\u0018N\\4F]\u0012$\"\"!\u000f\u0002@\u0005\u0005\u00131IA$!\r1\u00181H\u0005\u0004\u0003{9(\u0001B+oSRDa!!\u0001\u0006\u0001\u0004i\bbBA\u0011\u000b\u0001\u0007\u00111\u0002\u0005\b\u0003\u000b*\u0001\u0019AA\u0006\u0003a\u0001(o\\2fgNLgnZ*uCJ$H+[7fgR\fW\u000e\u001d\u0005\b\u0003\u0013*\u0001\u0019AA\f\u00039\u0019H/\u0019;f\rJ|Wn\u0015;beR\f\u0011b\u001c8GC&dWO]3\u0015\t\u0005e\u0012q\n\u0005\b\u0003#2\u0001\u0019AA*\u0003\u001d1\u0017-\u001b7ve\u0016\u0004B!!\u0016\u0002f9!\u0011qKA1\u001d\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/g\u00061AH]8pizJ\u0011\u0001_\u0005\u0004\u0003G:\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003O\nIGA\u0005UQJ|w/\u00192mK*\u0019\u00111M<\u0002#=tGI]8qa\u0016$W*Z:tC\u001e,7\u000f\u0006\u0003\u0002:\u0005=\u0004bBA9\u000f\u0001\u0007\u00111B\u0001\u0006G>,h\u000e^\u0001\u0013_:$VM]7j]\u0006$\u0018n\u001c8Ti\u0006\u0014H\u000f\u0006\u0002\u0002:\u000591\r\\3b]V\u0004\u0018\u0001D!di>\u0014Xj\u001c8ji>\u0014\bcAA?\u00175\t1n\u0005\u0002\fk\u00061A(\u001b8jiz\"\"!a\u001f\u0002\t\u0019\u0014x.\u001c\u000b\u000b\u0003\u0013\u000bY)a$\u0002 \u0006\r\u0006cAA?\u0001!9\u0011QR\u0007A\u0002\u0005]\u0011!C1di>\u00148)\u001a7m\u0011\u001d\t\t*\u0004a\u0001\u0003'\u000b1A]3g!\u0011\t)*a'\u000e\u0005\u0005]%\u0002BAM\u0003_\tQ!Y2u_JLA!!(\u0002\u0018\nA\u0011i\u0019;peJ+g\rC\u0004\u0002\"6\u0001\r!a%\u0002\rA\f'/\u001a8u\u0011\u001d\t)+\u0004a\u0001\u0003O\u000baa]=ti\u0016l\u0007\u0003BAK\u0003SKA!a+\u0002\u0018\nY\u0011i\u0019;peNK8\u000f^3n\u0003e\u0019'/Z1uKJ+w-\u001e7be\u0006\u001bGo\u001c:N_:LGo\u001c:\u0015\u0015\u0005%\u0015\u0011WA^\u0003\u000b\fI\rC\u0004\u00024:\u0001\r!!.\u0002\u0011\r,G\u000e\\%oM>\u0004B!! \u00028&\u0019\u0011\u0011X6\u0003\u001b\u0005\u001bGo\u001c:DK2d\u0017J\u001c4p\u0011\u001d\tiL\u0004a\u0001\u0003\u007f\u000b\u0011\"[:Ue\u0006\u001c7.\u001a3\u0011\u0007Y\f\t-C\u0002\u0002D^\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002H:\u0001\r!a0\u0002+A\f'\u000f^5dSB\fG/Z:J]R\u0013\u0018mY5oO\"9\u00111\u001a\bA\u0002\u00055\u0017\u0001D4s_V\u0004X*\u001a;sS\u000e\u001c\bCBA+\u0003\u001f\f\u0019.\u0003\u0003\u0002R\u0006%$aA*fcB!\u0011Q[At\u001d\u0011\t9.a9\u000f\t\u0005e\u0017\u0011\u001d\b\u0005\u00037\fyN\u0004\u0003\u0002Z\u0005u\u0017\"\u0001:\n\u0005A\f\u0018B\u00018p\u0013\r\t)/\\\u0001\f\u0003.\\\u0017-T3ue&\u001c7/\u0003\u0003\u0002j\u0006-(!F!di>\u0014xI]8va&s7\u000f\u001e:v[\u0016tGo\u001d\u0006\u0004\u0003Kl\u0017aE2sK\u0006$XMU8vi\u0016,Wj\u001c8ji>\u0014HCBAE\u0003c\f\u0019\u0010C\u0004\u00024>\u0001\r!!.\t\u000f\u0005-w\u00021\u0001\u0002N\u00069\"/Z:pYZ,\u0017)\u001e;p\u000fJ|W\u000f]5oOB\u000bG\u000f\u001b\u000b\u000b\u0003s\u0014IA!\n\u0003(\t%\u0002\u0003BA~\u0005\u0007qA!!@\u0002\u0000B\u0019\u0011\u0011L<\n\u0007\t\u0005q/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u000b\u00119A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u00039\bb\u0002B\u0006!\u0001\u0007!QB\u0001\u000bC\u000e$xN]\"mCN\u001c\b\u0007\u0002B\b\u00053\u0001b!a?\u0003\u0012\tU\u0011\u0002\u0002B\n\u0005\u000f\u0011Qa\u00117bgN\u0004BAa\u0006\u0003\u001a1\u0001A\u0001\u0004B\u000e\u0005\u0013\t\t\u0011!A\u0003\u0002\tu!aA0%cE!!qDA\f!\r1(\u0011E\u0005\u0004\u0005G9(a\u0002(pi\"Lgn\u001a\u0005\b\u0003#\u0003\u0002\u0019AAJ\u0011\u001d\t\t\u000b\u0005a\u0001\u0003'CqAa\u000b\u0011\u0001\u0004\tI0\u0001\u0006tsN$X-\u001c(b[\u0016\u0014Q\u0002\u0016:bG\u0016$Wj\u001c8ji>\u00148\u0003B\tv\u0003\u0013\u000b1b\u001d;beR\u001cHK]1dK\u00069Qn\u001c8ji>\u0014H\u0003\u0003B\u001c\u0005w\u0011iDa\u0010\u0011\u0007\te\u0012#D\u0001\f\u0011\u001d\t\u0019,\u0006a\u0001\u0003kCqA!\r\u0016\u0001\u0004\ty\fC\u0004\u00034U\u0001\r!!#\u0002\u001f}\u000b7\r^8s\u00072\f7o\u001d(b[\u0016,\"A!\u0012\u0011\t\t\u001d#\u0011K\u0007\u0003\u0005\u0013RAAa\u0013\u0003N\u0005!A.\u00198h\u0015\t\u0011y%\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0003\u0005\u0013\n\u0001cX1di>\u00148\t\\1tg:\u000bW.\u001a\u0011\u0002+}\u000b7\r^8s'&l\u0007\u000f\\3DY\u0006\u001c8OT1nKV\u0011\u0011\u0011`\u0001\u0017?\u0006\u001cGo\u001c:TS6\u0004H.Z\"mCN\u001ch*Y7fAQA\u0011q\u0003B/\u0005?\u0012\t\u0007\u0003\u0004\u0002\u0002u\u0001\r! \u0005\b\u0003Ci\u0002\u0019AA\u0006\u0011\u001d\t)#\ba\u0001\u0003O!\"\"!\u000f\u0003f\t\u001d$\u0011\u000eB6\u0011\u0019\t\tA\ba\u0001{\"9\u0011\u0011\u0005\u0010A\u0002\u0005-\u0001bBA#=\u0001\u0007\u00111\u0002\u0005\b\u0003\u0013r\u0002\u0019AA\f)\u0011\tIDa\u001c\t\u000f\u0005Es\u00041\u0001\u0002TQ!\u0011\u0011\bB:\u0011\u001d\t\t\b\ta\u0001\u0003\u0017\t\u0011BY;jY\u0012\u001c\u0006/\u00198\u0015\u0015\te$Q\u0012BH\u0005#\u0013\u0019\n\u0005\u0003\u0003|\t\u001de\u0002\u0002B?\u0005\u0007k!Aa \u000b\u0007\t\u0005\u0015/A\u0003ue\u0006\u001cW-\u0003\u0003\u0003\u0006\n}\u0014\u0001B*qC:LAA!#\u0003\f\n9A)\u001a7bs\u0016$'\u0002\u0002BC\u0005\u007fBq!a-$\u0001\u0004\t)\f\u0003\u0004\u0002\u0002\r\u0002\r! \u0005\b\u0003C\u0019\u0003\u0019AA\u0006\u0011\u001d\t)c\ta\u0001\u0003O\tQb\u001c9fe\u0006$\u0018n\u001c8OC6,GCBA}\u00053\u0013i\nC\u0004\u0003\u001c\u0012\u0002\r!!?\u0002\u00195,7o]1hK\u000ec\u0017m]:\t\u000f\t}E\u00051\u0001\u0002\u0014\u000611/\u001a8eKJ\u00141c\u00159b]\u0006sG-T8oSR|'o\u0015;bi\u0016\u001c\"!J;\u0002\tM\u0004\u0018M\\\u000b\u0003\u0005S\u0003BA! \u0003,&!!Q\u0016B@\u0005\u0011\u0019\u0006/\u00198\u0002\u000bM\u0004\u0018M\u001c\u0011\u0002']\u0014\u0018\r\u001d9fI6{g.\u001b;peN#\u0018\r^3\u0016\u0005\u0005]\u0011\u0001F<sCB\u0004X\rZ'p]&$xN]*uCR,\u0007\u0005\u0006\u0004\u0003:\nu&q\u0018\t\u0004\u0005w+S\"A\t\t\u000f\t\u0015&\u00061\u0001\u0003*\"9!\u0011\u0017\u0016A\u0002\u0005]!AF\"p]R,\u0007\u0010\u001e)s_B\fw-\u0019;j_:|e\u000e\\=\u0014\t-*\u0018\u0011R\u0001\u0012iJ\f7m[!di&4X-Q2u_J\u001cH\u0003\u0003Be\u0005\u0017\u0014iMa4\u0011\u0007\te2\u0006C\u0004\u00024>\u0002\r!!.\t\u000f\u0005\u001dw\u00061\u0001\u0002@\"9!QY\u0018A\u0002\u0005}\u0016AD0tsN$X-\\'fiJL7m]\u000b\u0003\u0005+\u0004BAa6\u0003\\:!!\u0011\\Ar\u001b\u0005i\u0017\u0002\u0002Bo\u0003W\u0014a#Q2u_J\u001c\u0016p\u001d;f[&s7\u000f\u001e:v[\u0016tGo]\u0001\u0010?NL8\u000f^3n\u001b\u0016$(/[2tAQA\u0011q\u0003Br\u0005K\u00149\u000f\u0003\u0004\u0002\u0002U\u0002\r! \u0005\b\u0003C)\u0004\u0019AA\u0006\u0011\u001d\t)#\u000ea\u0001\u0003O!\"\"!\u000f\u0003l\n5(q\u001eBy\u0011\u0019\t\tA\u000ea\u0001{\"9\u0011\u0011\u0005\u001cA\u0002\u0005-\u0001bBA#m\u0001\u0007\u00111\u0002\u0005\b\u0003\u00132\u0004\u0019AA\f)\u0011\tID!>\t\u000f\u0005Es\u00071\u0001\u0002TQ!\u0011\u0011\bB}\u0011\u001d\t\t\b\u000fa\u0001\u0003\u0017\u0011A\u0002\u0016:bG.,G-Q2u_J\u001c2a\u000fB\u0000!\r\u0011I$\u0016\u0002\u001a\u000fJ|W\u000f]'fiJL7m\u001d+sC\u000e\\\u0017N\\4BGR|'o\u0005\u0003Vk\u0006%EC\u0002B\u0000\u0007\u000f\u0019I\u0001C\u0004\u0002Lb\u0003\r!!4\t\u000f\u0005M\u0006\f1\u0001\u00026\u0006Aq,[:BY&4X-\u0006\u0002\u0002@\u0006aq,[:BY&4Xm\u0018\u0013fcR!\u0011\u0011HB\n\u0011%\u0019)BWA\u0001\u0002\u0004\ty,A\u0002yIE\n\u0011bX5t\u00032Lg/\u001a\u0011)\u0007m\u001bY\u0002E\u0002w\u0007;I1aa\bx\u0005!1x\u000e\\1uS2,\u0017\u0001G0tQ>,H\u000e\u001a+sC\u000e\\\u0017i\u0019;jm\u0016\f5\r^8sg\u0006Irl\u001d5pk2$GK]1dW\u0006\u001bG/\u001b<f\u0003\u000e$xN]:!\u0003\u0015\u0019Gn\\2l+\t\u0019I\u0003\u0005\u0003\u0004,\rERBAB\u0017\u0015\r\u0019y#]\u0001\u0005kRLG.\u0003\u0003\u00044\r5\"!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%A\u0007tsN$X-\\'fiJL7m]\u0001\u000fgf\u001cH/Z7NKR\u0014\u0018nY:!)\u0011\tId!\u0010\t\u000f\u0005ES\r1\u0001\u0002TQ!\u0011\u0011HB!\u0011\u001d\t\tH\u001aa\u0001\u0003\u0017\t!C]3d_J$wI]8va6+GO]5dgR1\u0011\u0011HB$\u0007\u0017Bqa!\u0013h\u0001\u0004\tY!\u0001\bqe>\u001cWm]:j]\u001e$\u0016.\\3\t\u000f\r5s\r1\u0001\u0002\f\u0005iA/[7f\u0013:l\u0015-\u001b7c_b\fA\"Y2u_JlU\r\u001e:jGN\u0004RA^B*\u0007/J1a!\u0016x\u0005\u0019y\u0005\u000f^5p]B!\u0011Q[B-\u0013\u0011\u0019Y&a;\u0003!\u0005\u001bGo\u001c:J]N$(/^7f]R\u001cH\u0003CB0\u0007C\u001a\u0019g!\u001a\u0011\u0007\te2\bC\u0004\u0004P}\u0002\ra!\u0015\t\u000f\u0005-w\b1\u0001\u0002N\"9\u00111W A\u0002\u0005U\u0016!G0qe>\u001cWm]:fI6+7o]1hKN\u001cu.\u001e8uKJ,\"aa\u001b\u0011\t\r541O\u0007\u0003\u0007_R1a!\u001dr\u0003\u0019iW\r\u001e:jG&!1QOB8\u0005\u001d\u0019u.\u001e8uKJ\f!d\u00189s_\u000e,7o]3e\u001b\u0016\u001c8/Y4fg\u000e{WO\u001c;fe\u0002\"\u0002\"a\u0006\u0004|\ru4q\u0010\u0005\u0007\u0003\u0003!\u0005\u0019A?\t\u000f\u0005\u0005B\t1\u0001\u0002\f!9\u0011Q\u0005#A\u0002\u0005\u001dBCCA\u001d\u0007\u0007\u001b)ia\"\u0004\n\"1\u0011\u0011A#A\u0002uDq!!\tF\u0001\u0004\tY\u0001C\u0004\u0002F\u0015\u0003\r!a\u0003\t\u000f\u0005%S\t1\u0001\u0002\u0018Q!\u0011\u0011HBG\u0011\u001d\t\tF\u0012a\u0001\u0003'\u0012Q\u0002\u0016:bG.,GMU8vi\u0016,7c\u0001%\u0003\u0000\u0006i!o\\;uKJlU\r\u001e:jGN\u0004B!!6\u0004\u0018&!1\u0011TAv\u0005E\u0011v.\u001e;fe&s7\u000f\u001e:v[\u0016tGo\u001d\u000b\t\u0007;\u001byj!)\u0004$B\u0019!\u0011\b%\t\u000f\rME\n1\u0001\u0004\u0016\"9\u00111\u001a'A\u0002\u00055\u0007bBAZ\u0019\u0002\u0007\u0011QW\u0001\u0019aJ|7-Z:tK\u0012lUm]:bO\u0016\u001c8i\\;oi\u0016\u0014\u0018!\u00079s_\u000e,7o]3e\u001b\u0016\u001c8/Y4fg\u000e{WO\u001c;fe\u0002\"\u0002\"a\u0006\u0004,\u000e56q\u0016\u0005\u0007\u0003\u0003\u0001\u0006\u0019A?\t\u000f\u0005\u0005\u0002\u000b1\u0001\u0002\f!9\u0011Q\u0005)A\u0002\u0005\u001dBCCA\u001d\u0007g\u001b)la.\u0004:\"1\u0011\u0011A)A\u0002uDq!!\tR\u0001\u0004\tY\u0001C\u0004\u0002FE\u0003\r!a\u0003\t\u000f\u0005%\u0013\u000b1\u0001\u0002\u0018Q!\u0011\u0011HB_\u0011\u001d\t\tF\u0015a\u0001\u0003'\"B!!\u000f\u0004B\"9\u0011\u0011O*A\u0002\u0005-\u0001")
public interface ActorMonitor {
    public static ActorMonitor from(Object object, ActorRef actorRef, ActorRef actorRef2, ActorSystem actorSystem) {
        return ActorMonitor$.MODULE$.from(object, actorRef, actorRef2, actorSystem);
    }

    public Context captureEnvelopeContext();

    public long captureEnvelopeTimestamp();

    public long captureProcessingStartTimestamp();

    public Object onMessageProcessingStart(Context var1, long var2, Envelope var4);

    public void onMessageProcessingEnd(Context var1, long var2, long var4, Object var6);

    public void onFailure(Throwable var1);

    public void onDroppedMessages(long var1);

    public void onTerminationStart();

    public void cleanup();

    public static class ContextPropagationOnly
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean participatesInTracing;
        private final boolean trackActiveActors;
        private final AkkaMetrics.ActorSystemInstruments _systemMetrics;

        private AkkaMetrics.ActorSystemInstruments _systemMetrics() {
            return this._systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.participatesInTracing ? Kamon$.MODULE$.clock().nanos() : 0L;
        }

        @Override
        public Context captureEnvelopeContext() {
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.participatesInTracing ? Kamon$.MODULE$.clock().nanos() : 0L;
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._systemMetrics().processedMessagesByNonTracked().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            ((Storage.Scope)stateFromStart).close();
        }

        @Override
        public void onFailure(Throwable failure) {
        }

        @Override
        public void onDroppedMessages(long count) {
        }

        @Override
        public void onTerminationStart() {
        }

        @Override
        public void cleanup() {
            block0: {
                if (!this.trackActiveActors || this.cellInfo.isTemporary()) break block0;
                this._systemMetrics().activeActors().decrement();
            }
        }

        public ContextPropagationOnly(ActorCellInfo cellInfo, boolean participatesInTracing, boolean trackActiveActors) {
            this.cellInfo = cellInfo;
            this.participatesInTracing = participatesInTracing;
            this.trackActiveActors = trackActiveActors;
            this._systemMetrics = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName());
            Object object = trackActiveActors && !cellInfo.isTemporary() ? this._systemMetrics().activeActors().increment() : BoxedUnit.UNIT;
        }
    }

    public static abstract class GroupMetricsTrackingActor
    implements ActorMonitor {
        private final Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics;
        private final ActorCellInfo cellInfo;
        private volatile boolean _isAlive;
        private final boolean _shouldTrackActiveActors;
        private final Clock clock;
        private final AkkaMetrics.ActorSystemInstruments systemMetrics;

        private boolean _isAlive() {
            return this._isAlive;
        }

        private void _isAlive_$eq(boolean x$1) {
            this._isAlive = x$1;
        }

        private boolean _shouldTrackActiveActors() {
            return this._shouldTrackActiveActors;
        }

        public Clock clock() {
            return this.clock;
        }

        public AkkaMetrics.ActorSystemInstruments systemMetrics() {
            return this.systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public Context captureEnvelopeContext() {
            block0: {
                if (!this._isAlive() || this.cellInfo.isTemporary()) break block0;
                this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.pendingMessages().increment());
            }
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public void onFailure(Throwable failure) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.errors().increment());
        }

        @Override
        public void onDroppedMessages(long count) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.pendingMessages().decrement(count));
        }

        public void recordGroupMetrics(long processingTime, long timeInMailbox) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> {
                gm.processingTime().record(processingTime);
                gm.timeInMailbox().record(timeInMailbox);
                return gm.pendingMessages().decrement();
            });
        }

        @Override
        public void onTerminationStart() {
            this._isAlive_$eq(false);
        }

        @Override
        public void cleanup() {
            block0: {
                if (!this._shouldTrackActiveActors()) break block0;
                this.systemMetrics().activeActors().decrement();
                this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.members().decrement());
            }
        }

        public GroupMetricsTrackingActor(Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            block0: {
                this.groupMetrics = groupMetrics;
                this.cellInfo = cellInfo;
                this._isAlive = true;
                this._shouldTrackActiveActors = !cellInfo.isTemporary();
                this.clock = Kamon$.MODULE$.clock();
                this.systemMetrics = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName());
                if (!this._shouldTrackActiveActors()) break block0;
                this.systemMetrics().activeActors().increment();
                groupMetrics.foreach((Function1 & Serializable)gm -> gm.members().increment());
            }
        }
    }

    public static class TracedMonitor
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean startsTrace;
        private final ActorMonitor monitor;
        private final String _actorClassName;
        private final String _actorSimpleClassName;

        private String _actorClassName() {
            return this._actorClassName;
        }

        private String _actorSimpleClassName() {
            return this._actorSimpleClassName;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.monitor.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            return this.monitor.captureEnvelopeContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.monitor.captureProcessingStartTimestamp();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            SpanAndMonitorState spanAndMonitorState;
            Context incomingContext = context;
            if (((Span)incomingContext.get(Span$.MODULE$.Key())).isEmpty() && !this.startsTrace) {
                spanAndMonitorState = new SpanAndMonitorState(this, null, this.monitor.onMessageProcessingStart(context, envelopeTimestamp, envelope));
            } else {
                Span.Delayed messageSpan = this.buildSpan(this.cellInfo, context, envelopeTimestamp, envelope).start();
                Context contextWithMessageSpan = incomingContext.withEntry(Span$.MODULE$.Key(), (Object)messageSpan);
                spanAndMonitorState = new SpanAndMonitorState(this, (Span)messageSpan, this.monitor.onMessageProcessingStart(contextWithMessageSpan, envelopeTimestamp, envelope));
            }
            return spanAndMonitorState;
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            block0: {
                SpanAndMonitorState spanAndMonitor = (SpanAndMonitorState)stateFromStart;
                this.monitor.onMessageProcessingEnd(context, envelopeTimestamp, processingStartTimestamp, spanAndMonitor.wrappedMonitorState());
                if (spanAndMonitor.span() == null) break block0;
                spanAndMonitor.span().finish();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.monitor.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            this.monitor.onDroppedMessages(count);
        }

        @Override
        public void onTerminationStart() {
            this.monitor.onTerminationStart();
        }

        @Override
        public void cleanup() {
            this.monitor.cleanup();
        }

        private Span.Delayed buildSpan(ActorCellInfo cellInfo, Context context, long envelopeTimestamp, Envelope envelope) {
            String messageClass = ActorCellInfo$.MODULE$.simpleClassName(envelope.message().getClass());
            Span parentSpan = (Span)context.get(Span$.MODULE$.Key());
            return Kamon$.MODULE$.internalSpanBuilder(this.operationName(messageClass, envelope.sender()), "akka.actor").asChildOf(parentSpan).doNotTrackMetrics().tag("akka.system", cellInfo.systemName()).tag("akka.actor.path", cellInfo.path()).tag("akka.actor.class", this._actorClassName()).tag("akka.actor.message-class", messageClass).delay(Kamon$.MODULE$.clock().toInstant(envelopeTimestamp));
        }

        private String operationName(String messageClass, ActorRef sender) {
            String operationType = AkkaPrivateAccess.isPromiseActorRef(sender) ? "ask(" : "tell(";
            return package$.MODULE$.StringBuilder().newBuilder().append(operationType).append(this._actorSimpleClassName()).append(", ").append(messageClass).append(")").result();
        }

        public TracedMonitor(ActorCellInfo cellInfo, boolean startsTrace, ActorMonitor monitor) {
            this.cellInfo = cellInfo;
            this.startsTrace = startsTrace;
            this.monitor = monitor;
            this._actorClassName = cellInfo.actorOrRouterClass().getName();
            this._actorSimpleClassName = ActorCellInfo$.MODULE$.simpleClassName(cellInfo.actorOrRouterClass());
        }

        public class SpanAndMonitorState {
            private final Span span;
            private final Object wrappedMonitorState;
            public final /* synthetic */ TracedMonitor $outer;

            public Span span() {
                return this.span;
            }

            public Object wrappedMonitorState() {
                return this.wrappedMonitorState;
            }

            public /* synthetic */ TracedMonitor kamon$instrumentation$akka$instrumentations$ActorMonitor$TracedMonitor$SpanAndMonitorState$$$outer() {
                return this.$outer;
            }

            public SpanAndMonitorState(TracedMonitor $outer, Span span, Object wrappedMonitorState) {
                this.span = span;
                this.wrappedMonitorState = wrappedMonitorState;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }

    public static class TrackedActor
    extends GroupMetricsTrackingActor {
        private final Option<AkkaMetrics.ActorInstruments> actorMetrics;
        private final Counter _processedMessagesCounter;

        private Counter _processedMessagesCounter() {
            return this._processedMessagesCounter;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return super.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            this.actorMetrics.foreach((Function1 & Serializable)am -> am.mailboxSize().increment());
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = this.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.actorMetrics.foreach((Function1 & Serializable)am -> {
                    am.processingTime().record(processingTime);
                    am.timeInMailbox().record(timeInMailbox);
                    return am.mailboxSize().decrement();
                });
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.actorMetrics.foreach((Function1 & Serializable)am -> am.errors().increment());
            super.onFailure(failure);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.actorMetrics.foreach((Function1 & Serializable)x$2 -> {
                x$2.remove();
                return BoxedUnit.UNIT;
            });
        }

        public TrackedActor(Option<AkkaMetrics.ActorInstruments> actorMetrics, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.actorMetrics = actorMetrics;
            super(groupMetrics, cellInfo);
            this._processedMessagesCounter = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }

    public static class TrackedRoutee
    extends GroupMetricsTrackingActor {
        private final AkkaMetrics.RouterInstruments routerMetrics;
        private final Counter processedMessagesCounter;

        private Counter processedMessagesCounter() {
            return this.processedMessagesCounter;
        }

        @Override
        public Context captureEnvelopeContext() {
            this.routerMetrics.pendingMessages().increment();
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this.processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = Kamon$.MODULE$.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.routerMetrics.processingTime().record(processingTime);
                this.routerMetrics.timeInMailbox().record(timeInMailbox);
                this.routerMetrics.pendingMessages().decrement();
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.routerMetrics.errors().increment();
            super.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            super.onDroppedMessages(count);
            this.routerMetrics.pendingMessages().decrement(count);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.routerMetrics.members().decrement();
        }

        public TrackedRoutee(AkkaMetrics.RouterInstruments routerMetrics, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.routerMetrics = routerMetrics;
            super(groupMetrics, cellInfo);
            routerMetrics.members().increment();
            this.processedMessagesCounter = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }
}

