/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.instrumentations;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.Envelope;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.akka.AkkaMetrics;
import kamon.instrumentation.akka.AkkaMetrics$;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo$;
import kamon.instrumentation.akka.instrumentations.ActorMonitor$;
import kamon.instrumentation.akka.instrumentations.AkkaPrivateAccess;
import kamon.metric.Counter;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanBuilder;
import kamon.util.Clock;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\r\u0005fa\u00024h!\u0003\r\n\u0001\u001d\u0005\u0006o\u00021\t\u0001\u001f\u0005\u0007\u007f\u00021\t!!\u0001\t\u000f\u0005%\u0001A\"\u0001\u0002\u0002!9\u00111\u0002\u0001\u0007\u0002\u00055\u0001bBA\u0017\u0001\u0019\u0005\u0011q\u0006\u0005\b\u0003\u0007\u0002a\u0011AA#\u0011\u001d\t\u0019\u0007\u0001D\u0001\u0003KBq!a\u001b\u0001\r\u0003\ti\u0007C\u0004\u0002p\u00011\t!!\u001c\b\u000f\u0005Et\r#\u0001\u0002t\u00191am\u001aE\u0001\u0003oBq!!\u001f\f\t\u0003\tY\bC\u0004\u0002~-!\t!a \t\u000f\u0005\u00156\u0002\"\u0003\u0002(\"9\u0011Q]\u0006\u0005\n\u0005\u001d\bbBAw\u0017\u0011%\u0011q\u001e\u0004\u0007\u0005KY\u0001Aa\n\t\u0015\u0005-\u0016C!A!\u0002\u0013\ti\u000b\u0003\u0006\u0003*E\u0011\t\u0011)A\u0005\u0003oC!Ba\u000b\u0012\u0005\u0003\u0005\u000b\u0011BAA\u0011\u001d\tI(\u0005C\u0001\u0005[Aaa`\t\u0005B\u0005\u0005\u0001\"B<\u0012\t\u0003B\bbBA\u0005#\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u0017\tB\u0011\tB\u001d\u0011\u001d\ti#\u0005C!\u0005\u0003Bq!a\u0011\u0012\t\u0003\u0012Y\u0005C\u0004\u0002dE!\tEa\u0014\t\u000f\u0005-\u0014\u0003\"\u0011\u0002n!9\u0011qN\t\u0005B\u00055\u0004b\u0002B*#\u0011%!Q\u000b\u0005\b\u0005g\nB\u0011\u0002B;\r\u0019\u0011y(\u0005\u0003\u0003\u0002\"Q!1Q\u0011\u0003\u0006\u0004%\tA!\"\t\u0015\t5\u0015E!A!\u0002\u0013\u00119\t\u0003\u0006\u0003\u0010\u0006\u0012)\u0019!C\u0001\u0005#C!Ba%\"\u0005\u0003\u0005\u000b\u0011BA\b\u0011\u001d\tI(\tC\u0001\u0005+3aAa(\f\u0001\t\u0005\u0006BCAVO\t\u0005\t\u0015!\u0003\u0002.\"Q\u0011qX\u0014\u0003\u0002\u0003\u0006I!a.\t\u0015\t\rvE!A!\u0002\u0013\t9\fC\u0004\u0002z\u001d\"\tA!*\t\u0013\t=vE1A\u0005\n\tE\u0006\u0002\u0003B_O\u0001\u0006IAa-\t\r}<C\u0011IA\u0001\u0011\u00159x\u0005\"\u0011y\u0011\u001d\tIa\nC!\u0003\u0003Aq!a\u0003(\t\u0003\u0012y\fC\u0004\u0002.\u001d\"\tEa2\t\u000f\u0005\rs\u0005\"\u0011\u0003R\"9\u00111M\u0014\u0005B\tU\u0007bBA6O\u0011\u0005\u0013Q\u000e\u0005\b\u0003_:C\u0011AA7\r\u0019\u0011In\u0003\u0001\u0003\\\"Q1QF\u001c\u0003\u0002\u0003\u0006Iaa\f\t\u0015\u0005\rwG!A!\u0002\u0013\t)\r\u0003\u0006\u0002,^\u0012\t\u0011)A\u0005\u0003[Cq!!\u001f8\t\u0003\u0019Y\u0004C\u0005\u0004F]\u0012\r\u0011\"\u0003\u0004H!A1QK\u001c!\u0002\u0013\u0019I\u0005\u0003\u0004\u0000o\u0011\u0005\u0013\u0011\u0001\u0005\u0006o^\"\t\u0005\u001f\u0005\b\u0003\u00179D\u0011IB,\u0011\u001d\tic\u000eC!\u0007?Bq!a\u00118\t\u0003\u001aI\u0007C\u0004\u0002p]\"\t%!\u001c\u0007\r\r54\u0002AB8\u0011)\u0019\t\b\u0012B\u0001B\u0003%11\u000f\u0005\u000b\u0003\u0007$%\u0011!Q\u0001\n\u0005\u0015\u0007BCAV\t\n\u0005\t\u0015!\u0003\u0002.\"9\u0011\u0011\u0010#\u0005\u0002\re\u0004\"CBB\t\n\u0007I\u0011BB$\u0011!\u0019)\t\u0012Q\u0001\n\r%\u0003\"B<E\t\u0003B\bbBA\u0006\t\u0012\u00053q\u0011\u0005\b\u0003[!E\u0011IBH\u0011\u001d\t\u0019\u0005\u0012C!\u00073Cq!a\u0019E\t\u0003\u001ai\nC\u0004\u0002p\u0011#\t%!\u001c\u0007\u000f\t}7\"!\u0001\u0003b\"Q\u00111Y)\u0003\u0002\u0003\u0006I!!2\t\u0015\u0005-\u0016K!A!\u0002\u0013\ti\u000bC\u0004\u0002zE#\tAa9\t\u0013\t%\u0018\u000b1A\u0005\n\t-\b\"\u0003Bw#\u0002\u0007I\u0011\u0002Bx\u0011!\u0011)0\u0015Q!\n\u0005]\u0006\"\u0003B\u0000#\n\u0007I\u0011\u0002Bv\u0011!\u0019\t!\u0015Q\u0001\n\u0005]\u0006\"CB\u0002#\n\u0007I\u0011CB\u0003\u0011!\u0019\u0019\"\u0015Q\u0001\n\r\u001d\u0001\"CB\u000b#\n\u0007I\u0011\u0003BY\u0011!\u00199\"\u0015Q\u0001\n\tM\u0006BB@R\t\u0003\n\t\u0001C\u0003x#\u0012\u0005\u0003\u0010C\u0004\u0002\nE#\t%!\u0001\t\u000f\u0005\r\u0013\u000b\"\u0011\u0004\u001a!9\u00111M)\u0005B\ru\u0001bBB\u0011#\u0012E11\u0005\u0005\b\u0003W\nF\u0011IA7\u0011\u001d\ty'\u0015C\u0001\u0003[\u0012A\"Q2u_JluN\\5u_JT!\u0001[5\u0002!%t7\u000f\u001e:v[\u0016tG/\u0019;j_:\u001c(B\u00016l\u0003\u0011\t7n[1\u000b\u00051l\u0017aD5ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u000b\u00039\fQa[1n_:\u001c\u0001a\u0005\u0002\u0001cB\u0011!/^\u0007\u0002g*\tA/A\u0003tG\u0006d\u0017-\u0003\u0002wg\n1\u0011I\\=SK\u001a\facY1qiV\u0014X-\u00128wK2|\u0007/Z\"p]R,\u0007\u0010\u001e\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011A0\\\u0001\bG>tG/\u001a=u\u0013\tq8PA\u0004D_:$X\r\u001f;\u00021\r\f\u0007\u000f^;sK\u0016sg/\u001a7pa\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0002\u0002\u0004A\u0019!/!\u0002\n\u0007\u0005\u001d1O\u0001\u0003M_:<\u0017aH2baR,(/\u001a)s_\u000e,7o]5oON#\u0018M\u001d;US6,7\u000f^1na\u0006ArN\\'fgN\fw-\u001a)s_\u000e,7o]5oON#\u0018M\u001d;\u0015\u0011\u0005=\u0011QCA\f\u00037\u00012A]A\t\u0013\r\t\u0019b\u001d\u0002\u0004\u0003:L\b\"\u0002?\u0005\u0001\u0004I\bbBA\r\t\u0001\u0007\u00111A\u0001\u0012K:4X\r\\8qKRKW.Z:uC6\u0004\bbBA\u000f\t\u0001\u0007\u0011qD\u0001\tK:4X\r\\8qKB!\u0011\u0011EA\u0015\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001\u00033jgB\fGo\u00195\u000b\u0003)LA!a\u000b\u0002$\tAQI\u001c<fY>\u0004X-\u0001\fp]6+7o]1hKB\u0013xnY3tg&tw-\u00128e))\t\t$a\u000e\u0002:\u0005m\u0012q\b\t\u0004e\u0006M\u0012bAA\u001bg\n!QK\\5u\u0011\u0015aX\u00011\u0001z\u0011\u001d\tI\"\u0002a\u0001\u0003\u0007Aq!!\u0010\u0006\u0001\u0004\t\u0019!\u0001\rqe>\u001cWm]:j]\u001e\u001cF/\u0019:u)&lWm\u001d;b[BDq!!\u0011\u0006\u0001\u0004\ty!\u0001\bti\u0006$XM\u0012:p[N#\u0018M\u001d;\u0002\u0013=tg)Y5mkJ,G\u0003BA\u0019\u0003\u000fBq!!\u0013\u0007\u0001\u0004\tY%A\u0004gC&dWO]3\u0011\t\u00055\u0013Q\f\b\u0005\u0003\u001f\nIF\u0004\u0003\u0002R\u0005]SBAA*\u0015\r\t)f\\\u0001\u0007yI|w\u000e\u001e \n\u0003QL1!a\u0017t\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0018\u0002b\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u00037\u001a\u0018!E8o\tJ|\u0007\u000f]3e\u001b\u0016\u001c8/Y4fgR!\u0011\u0011GA4\u0011\u001d\tIg\u0002a\u0001\u0003\u0007\tQaY8v]R\f!c\u001c8UKJl\u0017N\\1uS>t7\u000b^1siR\u0011\u0011\u0011G\u0001\bG2,\u0017M\\;q\u00031\t5\r^8s\u001b>t\u0017\u000e^8s!\r\t)hC\u0007\u0002ON\u00111\"]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005M\u0014\u0001\u00024s_6$\"\"!!\u0002\u0004\u0006\u001d\u0015qSAN!\r\t)\b\u0001\u0005\b\u0003\u000bk\u0001\u0019AA\b\u0003%\t7\r^8s\u0007\u0016dG\u000eC\u0004\u0002\n6\u0001\r!a#\u0002\u0007I,g\r\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\u0011\t\t*a\n\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005U\u0015q\u0012\u0002\t\u0003\u000e$xN\u001d*fM\"9\u0011\u0011T\u0007A\u0002\u0005-\u0015A\u00029be\u0016tG\u000fC\u0004\u0002\u001e6\u0001\r!a(\u0002\rML8\u000f^3n!\u0011\ti)!)\n\t\u0005\r\u0016q\u0012\u0002\f\u0003\u000e$xN]*zgR,W.A\rde\u0016\fG/\u001a*fOVd\u0017M]!di>\u0014Xj\u001c8ji>\u0014HCCAA\u0003S\u000b\u0019,!0\u0002B\"9\u00111\u0016\bA\u0002\u00055\u0016\u0001C2fY2LeNZ8\u0011\t\u0005U\u0014qV\u0005\u0004\u0003c;'!D!di>\u00148)\u001a7m\u0013:4w\u000eC\u0004\u00026:\u0001\r!a.\u0002\u0013%\u001cHK]1dW\u0016$\u0007c\u0001:\u0002:&\u0019\u00111X:\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0018\bA\u0002\u0005]\u0016!\u00069beRL7-\u001b9bi\u0016\u001c\u0018J\u001c+sC\u000eLgn\u001a\u0005\b\u0003\u0007t\u0001\u0019AAc\u000319'o\\;q\u001b\u0016$(/[2t!\u0019\ti%a2\u0002L&!\u0011\u0011ZA1\u0005\r\u0019V-\u001d\t\u0005\u0003\u001b\fyN\u0004\u0003\u0002P\u0006mg\u0002BAi\u00033tA!a5\u0002X:!\u0011\u0011KAk\u0013\u0005q\u0017B\u00017n\u0013\tQ7.C\u0002\u0002^&\f1\"Q6lC6+GO]5dg&!\u0011\u0011]Ar\u0005U\t5\r^8s\u000fJ|W\u000f]%ogR\u0014X/\\3oiNT1!!8j\u0003M\u0019'/Z1uKJ{W\u000f^3f\u001b>t\u0017\u000e^8s)\u0019\t\t)!;\u0002l\"9\u00111V\bA\u0002\u00055\u0006bBAb\u001f\u0001\u0007\u0011QY\u0001\u0018e\u0016\u001cx\u000e\u001c<f\u0003V$xn\u0012:pkBLgn\u001a)bi\"$\"\"!=\u0003\u0002\tu!q\u0004B\u0011!\u0011\t\u00190a?\u000f\t\u0005U\u0018q\u001f\t\u0004\u0003#\u001a\u0018bAA}g\u00061\u0001K]3eK\u001aLA!!@\u0002\u0000\n11\u000b\u001e:j]\u001eT1!!?t\u0011\u001d\u0011\u0019\u0001\u0005a\u0001\u0005\u000b\t!\"Y2u_J\u001cE.Y:ta\u0011\u00119A!\u0005\u0011\r\u0005M(\u0011\u0002B\u0007\u0013\u0011\u0011Y!a@\u0003\u000b\rc\u0017m]:\u0011\t\t=!\u0011\u0003\u0007\u0001\t1\u0011\u0019B!\u0001\u0002\u0002\u0003\u0005)\u0011\u0001B\u000b\u0005\ryF%M\t\u0005\u0005/\ty\u0001E\u0002s\u00053I1Aa\u0007t\u0005\u001dqu\u000e\u001e5j]\u001eDq!!#\u0011\u0001\u0004\tY\tC\u0004\u0002\u001aB\u0001\r!a#\t\u000f\t\r\u0002\u00031\u0001\u0002r\u0006Q1/_:uK6t\u0015-\\3\u0003\u001bQ\u0013\u0018mY3e\u001b>t\u0017\u000e^8s'\u0011\t\u0012/!!\u0002\u0017M$\u0018M\u001d;t)J\f7-Z\u0001\b[>t\u0017\u000e^8s)!\u0011yCa\r\u00036\t]\u0002c\u0001B\u0019#5\t1\u0002C\u0004\u0002,V\u0001\r!!,\t\u000f\t%R\u00031\u0001\u00028\"9!1F\u000bA\u0002\u0005\u0005E\u0003CA\b\u0005w\u0011iDa\u0010\t\u000bqL\u0002\u0019A=\t\u000f\u0005e\u0011\u00041\u0001\u0002\u0004!9\u0011QD\rA\u0002\u0005}ACCA\u0019\u0005\u0007\u0012)Ea\u0012\u0003J!)AP\u0007a\u0001s\"9\u0011\u0011\u0004\u000eA\u0002\u0005\r\u0001bBA\u001f5\u0001\u0007\u00111\u0001\u0005\b\u0003\u0003R\u0002\u0019AA\b)\u0011\t\tD!\u0014\t\u000f\u0005%3\u00041\u0001\u0002LQ!\u0011\u0011\u0007B)\u0011\u001d\tI\u0007\ba\u0001\u0003\u0007\t\u0011BY;jY\u0012\u001c\u0006/\u00198\u0015\u0015\t]#1\u000eB7\u0005_\u0012\t\b\u0005\u0003\u0003Z\t\u0015d\u0002\u0002B.\u0005Cj!A!\u0018\u000b\u0007\t}S.A\u0003ue\u0006\u001cW-\u0003\u0003\u0003d\tu\u0013\u0001B*qC:LAAa\u001a\u0003j\t9A)\u001a7bs\u0016$'\u0002\u0002B2\u0005;Bq!a+ \u0001\u0004\ti\u000bC\u0003}?\u0001\u0007\u0011\u0010C\u0004\u0002\u001a}\u0001\r!a\u0001\t\u000f\u0005uq\u00041\u0001\u0002 \u0005iq\u000e]3sCRLwN\u001c(b[\u0016$b!!=\u0003x\tm\u0004b\u0002B=A\u0001\u0007\u0011\u0011_\u0001\r[\u0016\u001c8/Y4f\u00072\f7o\u001d\u0005\b\u0005{\u0002\u0003\u0019AAF\u0003\u0019\u0019XM\u001c3fe\n\u00192\u000b]1o\u0003:$Wj\u001c8ji>\u00148\u000b^1uKN\u0011\u0011%]\u0001\u0005gB\fg.\u0006\u0002\u0003\bB!!1\fBE\u0013\u0011\u0011YI!\u0018\u0003\tM\u0003\u0018M\\\u0001\u0006gB\fg\u000eI\u0001\u0014oJ\f\u0007\u000f]3e\u001b>t\u0017\u000e^8s'R\fG/Z\u000b\u0003\u0003\u001f\tAc\u001e:baB,G-T8oSR|'o\u0015;bi\u0016\u0004CC\u0002BL\u00057\u0013i\nE\u0002\u0003\u001a\u0006j\u0011!\u0005\u0005\b\u0005\u00073\u0003\u0019\u0001BD\u0011\u001d\u0011yI\na\u0001\u0003\u001f\u0011acQ8oi\u0016DH\u000f\u0015:pa\u0006<\u0017\r^5p]>sG._\n\u0005OE\f\t)A\tue\u0006\u001c7.Q2uSZ,\u0017i\u0019;peN$\u0002Ba*\u0003*\n-&Q\u0016\t\u0004\u0005c9\u0003bBAVW\u0001\u0007\u0011Q\u0016\u0005\b\u0003\u007f[\u0003\u0019AA\\\u0011\u001d\u0011\u0019k\u000ba\u0001\u0003o\u000babX:zgR,W.T3ue&\u001c7/\u0006\u0002\u00034B!!Q\u0017B]\u001d\u0011\u00119,a7\u000e\u0003%LAAa/\u0002d\n1\u0012i\u0019;peNK8\u000f^3n\u0013:\u001cHO];nK:$8/A\b`gf\u001cH/Z7NKR\u0014\u0018nY:!)!\tyA!1\u0003D\n\u0015\u0007\"\u0002?2\u0001\u0004I\bbBA\rc\u0001\u0007\u00111\u0001\u0005\b\u0003;\t\u0004\u0019AA\u0010))\t\tD!3\u0003L\n5'q\u001a\u0005\u0006yJ\u0002\r!\u001f\u0005\b\u00033\u0011\u0004\u0019AA\u0002\u0011\u001d\tiD\ra\u0001\u0003\u0007Aq!!\u00113\u0001\u0004\ty\u0001\u0006\u0003\u00022\tM\u0007bBA%g\u0001\u0007\u00111\n\u000b\u0005\u0003c\u00119\u000eC\u0004\u0002jQ\u0002\r!a\u0001\u0003\u0019Q\u0013\u0018mY6fI\u0006\u001bGo\u001c:\u0014\u0007]\u0012i\u000eE\u0002\u00032E\u0013\u0011d\u0012:pkBlU\r\u001e:jGN$&/Y2lS:<\u0017i\u0019;peN!\u0011+]AA)\u0019\u0011iN!:\u0003h\"9\u00111\u0019+A\u0002\u0005\u0015\u0007bBAV)\u0002\u0007\u0011QV\u0001\t?&\u001c\u0018\t\\5wKV\u0011\u0011qW\u0001\r?&\u001c\u0018\t\\5wK~#S-\u001d\u000b\u0005\u0003c\u0011\t\u0010C\u0005\u0003tZ\u000b\t\u00111\u0001\u00028\u0006\u0019\u0001\u0010J\u0019\u0002\u0013}K7/\u00117jm\u0016\u0004\u0003fA,\u0003zB\u0019!Oa?\n\u0007\tu8O\u0001\u0005w_2\fG/\u001b7f\u0003ay6\u000f[8vY\u0012$&/Y2l\u0003\u000e$\u0018N^3BGR|'o]\u0001\u001a?NDw.\u001e7e)J\f7m[!di&4X-Q2u_J\u001c\b%A\u0003dY>\u001c7.\u0006\u0002\u0004\bA!1\u0011BB\b\u001b\t\u0019YAC\u0002\u0004\u000e5\fA!\u001e;jY&!1\u0011CB\u0006\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005i1/_:uK6lU\r\u001e:jGN\fab]=ti\u0016lW*\u001a;sS\u000e\u001c\b\u0005\u0006\u0003\u00022\rm\u0001bBA%C\u0002\u0007\u00111\n\u000b\u0005\u0003c\u0019y\u0002C\u0004\u0002j\t\u0004\r!a\u0001\u0002%I,7m\u001c:e\u000fJ|W\u000f]'fiJL7m\u001d\u000b\u0007\u0003c\u0019)c!\u000b\t\u000f\r\u001d2\r1\u0001\u0002\u0004\u0005q\u0001O]8dKN\u001c\u0018N\\4US6,\u0007bBB\u0016G\u0002\u0007\u00111A\u0001\u000ei&lW-\u00138NC&d'm\u001c=\u0002\u0019\u0005\u001cGo\u001c:NKR\u0014\u0018nY:\u0011\u000bI\u001c\td!\u000e\n\u0007\rM2O\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001b\u001c9$\u0003\u0003\u0004:\u0005\r(\u0001E!di>\u0014\u0018J\\:ueVlWM\u001c;t)!\u0019ida\u0010\u0004B\r\r\u0003c\u0001B\u0019o!91QF\u001eA\u0002\r=\u0002bBAbw\u0001\u0007\u0011Q\u0019\u0005\b\u0003W[\u0004\u0019AAW\u0003ey\u0006O]8dKN\u001cX\rZ'fgN\fw-Z:D_VtG/\u001a:\u0016\u0005\r%\u0003\u0003BB&\u0007#j!a!\u0014\u000b\u0007\r=S.\u0001\u0004nKR\u0014\u0018nY\u0005\u0005\u0007'\u001aiEA\u0004D_VtG/\u001a:\u00025}\u0003(o\\2fgN,G-T3tg\u0006<Wm]\"pk:$XM\u001d\u0011\u0015\u0011\u0005=1\u0011LB.\u0007;BQ\u0001 !A\u0002eDq!!\u0007A\u0001\u0004\t\u0019\u0001C\u0004\u0002\u001e\u0001\u0003\r!a\b\u0015\u0015\u0005E2\u0011MB2\u0007K\u001a9\u0007C\u0003}\u0003\u0002\u0007\u0011\u0010C\u0004\u0002\u001a\u0005\u0003\r!a\u0001\t\u000f\u0005u\u0012\t1\u0001\u0002\u0004!9\u0011\u0011I!A\u0002\u0005=A\u0003BA\u0019\u0007WBq!!\u0013C\u0001\u0004\tYEA\u0007Ue\u0006\u001c7.\u001a3S_V$X-Z\n\u0004\t\nu\u0017!\u0004:pkR,'/T3ue&\u001c7\u000f\u0005\u0003\u0002N\u000eU\u0014\u0002BB<\u0003G\u0014\u0011CU8vi\u0016\u0014\u0018J\\:ueVlWM\u001c;t)!\u0019Yh! \u0004\u0000\r\u0005\u0005c\u0001B\u0019\t\"91\u0011\u000f%A\u0002\rM\u0004bBAb\u0011\u0002\u0007\u0011Q\u0019\u0005\b\u0003WC\u0005\u0019AAW\u0003a\u0001(o\\2fgN,G-T3tg\u0006<Wm]\"pk:$XM]\u0001\u001aaJ|7-Z:tK\u0012lUm]:bO\u0016\u001c8i\\;oi\u0016\u0014\b\u0005\u0006\u0005\u0002\u0010\r%51RBG\u0011\u0015aH\n1\u0001z\u0011\u001d\tI\u0002\u0014a\u0001\u0003\u0007Aq!!\bM\u0001\u0004\ty\u0002\u0006\u0006\u00022\rE51SBK\u0007/CQ\u0001`'A\u0002eDq!!\u0007N\u0001\u0004\t\u0019\u0001C\u0004\u0002>5\u0003\r!a\u0001\t\u000f\u0005\u0005S\n1\u0001\u0002\u0010Q!\u0011\u0011GBN\u0011\u001d\tIE\u0014a\u0001\u0003\u0017\"B!!\r\u0004 \"9\u0011\u0011N(A\u0002\u0005\r\u0001")
public interface ActorMonitor {
    public static ActorMonitor from(Object object, ActorRef actorRef, ActorRef actorRef2, ActorSystem actorSystem) {
        return ActorMonitor$.MODULE$.from(object, actorRef, actorRef2, actorSystem);
    }

    public Context captureEnvelopeContext();

    public long captureEnvelopeTimestamp();

    public long captureProcessingStartTimestamp();

    public Object onMessageProcessingStart(Context var1, long var2, Envelope var4);

    public void onMessageProcessingEnd(Context var1, long var2, long var4, Object var6);

    public void onFailure(Throwable var1);

    public void onDroppedMessages(long var1);

    public void onTerminationStart();

    public void cleanup();

    public static class ContextPropagationOnly
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean participatesInTracing;
        private final boolean trackActiveActors;
        private final AkkaMetrics.ActorSystemInstruments _systemMetrics;

        private AkkaMetrics.ActorSystemInstruments _systemMetrics() {
            return this._systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.participatesInTracing ? Kamon$.MODULE$.clock().nanos() : 0L;
        }

        @Override
        public Context captureEnvelopeContext() {
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.participatesInTracing ? Kamon$.MODULE$.clock().nanos() : 0L;
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._systemMetrics().processedMessagesByNonTracked().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            ((Storage.Scope)stateFromStart).close();
        }

        @Override
        public void onFailure(Throwable failure) {
        }

        @Override
        public void onDroppedMessages(long count) {
        }

        @Override
        public void onTerminationStart() {
        }

        @Override
        public void cleanup() {
            block0: {
                if (!this.trackActiveActors || this.cellInfo.isTemporary()) break block0;
                this._systemMetrics().activeActors().decrement();
            }
        }

        public ContextPropagationOnly(ActorCellInfo cellInfo, boolean participatesInTracing, boolean trackActiveActors) {
            this.cellInfo = cellInfo;
            this.participatesInTracing = participatesInTracing;
            this.trackActiveActors = trackActiveActors;
            this._systemMetrics = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName());
            Object object = trackActiveActors && !cellInfo.isTemporary() ? this._systemMetrics().activeActors().increment() : BoxedUnit.UNIT;
        }
    }

    public static abstract class GroupMetricsTrackingActor
    implements ActorMonitor {
        private final Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics;
        private final ActorCellInfo cellInfo;
        private volatile boolean _isAlive;
        private final boolean _shouldTrackActiveActors;
        private final Clock clock;
        private final AkkaMetrics.ActorSystemInstruments systemMetrics;

        private boolean _isAlive() {
            return this._isAlive;
        }

        private void _isAlive_$eq(boolean x$1) {
            this._isAlive = x$1;
        }

        private boolean _shouldTrackActiveActors() {
            return this._shouldTrackActiveActors;
        }

        public Clock clock() {
            return this.clock;
        }

        public AkkaMetrics.ActorSystemInstruments systemMetrics() {
            return this.systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public Context captureEnvelopeContext() {
            block0: {
                if (!this._isAlive() || this.cellInfo.isTemporary()) break block0;
                this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.pendingMessages().increment());
            }
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public void onFailure(Throwable failure) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.errors().increment());
        }

        @Override
        public void onDroppedMessages(long count) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.pendingMessages().decrement(count));
        }

        public void recordGroupMetrics(long processingTime, long timeInMailbox) {
            this.groupMetrics.foreach((Function1 & Serializable)gm -> {
                gm.processingTime().record(processingTime);
                gm.timeInMailbox().record(timeInMailbox);
                return gm.pendingMessages().decrement();
            });
        }

        @Override
        public void onTerminationStart() {
            this._isAlive_$eq(false);
        }

        @Override
        public void cleanup() {
            block0: {
                if (!this._shouldTrackActiveActors()) break block0;
                this.systemMetrics().activeActors().decrement();
                this.groupMetrics.foreach((Function1 & Serializable)gm -> gm.members().decrement());
            }
        }

        public GroupMetricsTrackingActor(Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            block0: {
                this.groupMetrics = groupMetrics;
                this.cellInfo = cellInfo;
                this._isAlive = true;
                this._shouldTrackActiveActors = !cellInfo.isTemporary();
                this.clock = Kamon$.MODULE$.clock();
                this.systemMetrics = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName());
                if (!this._shouldTrackActiveActors()) break block0;
                this.systemMetrics().activeActors().increment();
                groupMetrics.foreach((Function1 & Serializable)gm -> gm.members().increment());
            }
        }
    }

    public static class TracedMonitor
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean startsTrace;
        private final ActorMonitor monitor;

        @Override
        public long captureEnvelopeTimestamp() {
            return this.monitor.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            return this.monitor.captureEnvelopeContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.monitor.captureProcessingStartTimestamp();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            SpanAndMonitorState spanAndMonitorState;
            Context incomingContext = context;
            if (((Span)incomingContext.get(Span$.MODULE$.Key())).isEmpty() && !this.startsTrace) {
                spanAndMonitorState = new SpanAndMonitorState(this, null, this.monitor.onMessageProcessingStart(context, envelopeTimestamp, envelope));
            } else {
                Span.Delayed messageSpan = this.buildSpan(this.cellInfo, context, envelopeTimestamp, envelope).start();
                Context contextWithMessageSpan = incomingContext.withEntry(Span$.MODULE$.Key(), (Object)messageSpan);
                spanAndMonitorState = new SpanAndMonitorState(this, (Span)messageSpan, this.monitor.onMessageProcessingStart(contextWithMessageSpan, envelopeTimestamp, envelope));
            }
            return spanAndMonitorState;
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            block0: {
                SpanAndMonitorState spanAndMonitor = (SpanAndMonitorState)stateFromStart;
                this.monitor.onMessageProcessingEnd(context, envelopeTimestamp, processingStartTimestamp, spanAndMonitor.wrappedMonitorState());
                if (spanAndMonitor.span() == null) break block0;
                spanAndMonitor.span().finish();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.monitor.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            this.monitor.onDroppedMessages(count);
        }

        @Override
        public void onTerminationStart() {
            this.monitor.onTerminationStart();
        }

        @Override
        public void cleanup() {
            this.monitor.cleanup();
        }

        private Span.Delayed buildSpan(ActorCellInfo cellInfo, Context context, long envelopeTimestamp, Envelope envelope) {
            String messageClass = ActorCellInfo$.MODULE$.simpleClassName(envelope.message().getClass());
            Span parentSpan = (Span)context.get(Span$.MODULE$.Key());
            SpanBuilder spanBuilder = Kamon$.MODULE$.internalSpanBuilder(this.operationName(messageClass, envelope.sender()), "akka.actor").asChildOf(parentSpan).doNotTrackMetrics().tag("akka.system", cellInfo.systemName()).tag("akka.actor.path", cellInfo.path()).tag("akka.actor.message-class", messageClass);
            Object object = !ActorCellInfo$.MODULE$.isTyped(cellInfo.actorOrRouterClass()) ? spanBuilder.tag("akka.actor.class", cellInfo.actorOrRouterClass().getName()) : BoxedUnit.UNIT;
            return spanBuilder.delay(Kamon$.MODULE$.clock().toInstant(envelopeTimestamp));
        }

        private String operationName(String messageClass, ActorRef sender) {
            String operationType = AkkaPrivateAccess.isPromiseActorRef(sender) ? "ask" : "tell";
            return package$.MODULE$.StringBuilder().newBuilder().append(operationType).append("(").append(messageClass).append(")").result();
        }

        public TracedMonitor(ActorCellInfo cellInfo, boolean startsTrace, ActorMonitor monitor) {
            this.cellInfo = cellInfo;
            this.startsTrace = startsTrace;
            this.monitor = monitor;
        }

        public class SpanAndMonitorState {
            private final Span span;
            private final Object wrappedMonitorState;
            public final /* synthetic */ TracedMonitor $outer;

            public Span span() {
                return this.span;
            }

            public Object wrappedMonitorState() {
                return this.wrappedMonitorState;
            }

            public /* synthetic */ TracedMonitor kamon$instrumentation$akka$instrumentations$ActorMonitor$TracedMonitor$SpanAndMonitorState$$$outer() {
                return this.$outer;
            }

            public SpanAndMonitorState(TracedMonitor $outer, Span span, Object wrappedMonitorState) {
                this.span = span;
                this.wrappedMonitorState = wrappedMonitorState;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }

    public static class TrackedActor
    extends GroupMetricsTrackingActor {
        private final Option<AkkaMetrics.ActorInstruments> actorMetrics;
        private final Counter _processedMessagesCounter;

        private Counter _processedMessagesCounter() {
            return this._processedMessagesCounter;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return super.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            this.actorMetrics.foreach((Function1 & Serializable)am -> am.mailboxSize().increment());
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = this.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.actorMetrics.foreach((Function1 & Serializable)am -> {
                    am.processingTime().record(processingTime);
                    am.timeInMailbox().record(timeInMailbox);
                    return am.mailboxSize().decrement();
                });
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.actorMetrics.foreach((Function1 & Serializable)am -> am.errors().increment());
            super.onFailure(failure);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.actorMetrics.foreach((Function1 & Serializable)x$2 -> {
                x$2.remove();
                return BoxedUnit.UNIT;
            });
        }

        public TrackedActor(Option<AkkaMetrics.ActorInstruments> actorMetrics, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.actorMetrics = actorMetrics;
            super(groupMetrics, cellInfo);
            this._processedMessagesCounter = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }

    public static class TrackedRoutee
    extends GroupMetricsTrackingActor {
        private final AkkaMetrics.RouterInstruments routerMetrics;
        private final Counter processedMessagesCounter;

        private Counter processedMessagesCounter() {
            return this.processedMessagesCounter;
        }

        @Override
        public Context captureEnvelopeContext() {
            this.routerMetrics.pendingMessages().increment();
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this.processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = Kamon$.MODULE$.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.routerMetrics.processingTime().record(processingTime);
                this.routerMetrics.timeInMailbox().record(timeInMailbox);
                this.routerMetrics.pendingMessages().decrement();
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.routerMetrics.errors().increment();
            super.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            super.onDroppedMessages(count);
            this.routerMetrics.pendingMessages().decrement(count);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.routerMetrics.members().decrement();
        }

        public TrackedRoutee(AkkaMetrics.RouterInstruments routerMetrics, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.routerMetrics = routerMetrics;
            super(groupMetrics, cellInfo);
            routerMetrics.members().increment();
            this.processedMessagesCounter = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }
}

