/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.process;

import com.sun.jna.Platform;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kamon.Kamon$;
import kamon.instrumentation.system.process.ProcessMetrics;
import kamon.metric.Timer;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tee\u0001\u0002\u001e<\u0001\u0011C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u00061\u0002!\t!\u0017\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u00199\u0007\u0001)A\u0005?\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007B\u00029\u0001A\u0003%!\u000eC\u0004r\u0001\t\u0007I\u0011\u0002:\t\u000f\u0005-\u0001\u0001)A\u0005g\"I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002\u0012!I\u0011Q\u0014\u0001C\u0002\u0013%\u0011q\u0014\u0005\t\u0003s\u0003\u0001\u0015!\u0003\u0002\"\"I\u0011\u0011\u001a\u0001C\u0002\u0013%\u00111\u001a\u0005\t\u0005s\u0001\u0001\u0015!\u0003\u0002N\"9!1\b\u0001\u0005B\u0005U\u0005b\u0002B\u001f\u0001\u0011\u0005#q\b\u0005\b\u00053\u0002A\u0011\u0002B.\u0011\u001d\u00119\u0007\u0001C\u0005\u0005S2a!!\u0006\u0001\t\u0005]\u0001B\u0002-\u0014\t\u0003\tI\u0002C\u0005\u0002\u001cM\u0011\r\u0011\"\u0003\u0002\u001e!A\u00111F\n!\u0002\u0013\ty\u0002C\u0005\u0002.M\u0011\r\u0011\"\u0003\u00020!A\u0011QH\n!\u0002\u0013\t\t\u0004C\u0005\u0002@M\u0011\r\u0011\"\u0003\u0002B!A\u00111K\n!\u0002\u0013\t\u0019\u0005C\u0005\u0002VM\u0011\r\u0011\"\u0003\u0002X!A\u0011qL\n!\u0002\u0013\tI\u0006C\u0005\u0002bM\u0011\r\u0011\"\u0003\u0002d!A\u00111N\n!\u0002\u0013\t)\u0007C\u0005\u0002nM\u0001\r\u0011\"\u0003\u0002p!I\u0011QP\nA\u0002\u0013%\u0011q\u0010\u0005\t\u0003\u0017\u001b\u0002\u0015)\u0003\u0002r!9\u0011QR\n\u0005\u0002\u0005=\u0005bBAJ'\u0011\u0005\u0011Q\u0013\u0005\b\u0003/\u001bB\u0011BAK\u0011\u001d\tIj\u0005C\u0005\u0003+3a!a4\u0001\u0005\u0005E\u0007BCAmM\t\u0005\t\u0015!\u0003\u0002\\\"Q\u0011q\u001d\u0014\u0003\u0002\u0003\u0006I!!;\t\ra3C\u0011AA{\u0011%\tYP\na\u0001\n\u0013\ti\u0010C\u0005\u0002\u0000\u001a\u0002\r\u0011\"\u0003\u0003\u0002!A!Q\u0001\u0014!B\u0013\t9\bC\u0005\u0003\u0010\u0019\u0002\r\u0011\"\u0003\u0003\u0012!I!\u0011\u0004\u0014A\u0002\u0013%!1\u0004\u0005\t\u0005?1\u0003\u0015)\u0003\u0003\u0014!9!1\u0005\u0014\u0005B\u0005U\u0005b\u0002B\u0013M\u0011\u0005!q\u0005\u0005\b\u0005c1C\u0011AAK\u0011\u001d\u0011\u0019D\nC\u0001\u0005k9qAa\u001b<\u0011\u0003\u0011iG\u0002\u0004;w!\u0005!q\u000e\u0005\u00071V\"\tA!\u001d\u0007\r\tMT\u0007\u0001B;\u0011\u0019Av\u0007\"\u0001\u0003~!9!1Q\u001c\u0005B\t\u0015%a\u0006)s_\u000e,7o]'fiJL7m]\"pY2,7\r^8s\u0015\taT(A\u0004qe>\u001cWm]:\u000b\u0005yz\u0014AB:zgR,WN\u0003\u0002A\u0003\u0006y\u0011N\\:ueVlWM\u001c;bi&|gNC\u0001C\u0003\u0015Y\u0017-\\8o\u0007\u0001\u00192\u0001A#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fMB\u0011AjT\u0007\u0002\u001b*\u0011a*Q\u0001\u0007[>$W\u000f\\3\n\u0005Ak%AB'pIVdW-\u0001\u0002fGB\u00111KV\u0007\u0002)*\u0011QkR\u0001\u000bG>t7-\u001e:sK:$\u0018BA,U\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u00035r\u0003\"a\u0017\u0001\u000e\u0003mBQ!\u0015\u0002A\u0002I\u000b1c\u00185jG\u000e,\b/\u00138uKJ4\u0018\r\u001c)bi\",\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fA\u0001\\1oO*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005\u0019\u0019FO]5oO\u0006!r\f[5dGV\u0004\u0018J\u001c;feZ\fG\u000eU1uQ\u0002\nAb\u00183fM\u0006,H\u000e\u001e+bON,\u0012A\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u0006\u000b1\u0001^1h\u0013\tyGN\u0001\u0004UC\u001e\u001cV\r^\u0001\u000e?\u0012,g-Y;miR\u000bwm\u001d\u0011\u0002-}\u0003(o\\2fgN\u001c\u0005/^%ogR\u0014X/\\3oiN,\u0012a\u001d\t\u0004i\u0006\u0015abA;\u0002\u00029\u0011ao \b\u0003ozt!\u0001_?\u000f\u0005edX\"\u0001>\u000b\u0005m\u001c\u0015A\u0002\u001fs_>$h(C\u0001C\u0013\t\u0001\u0015)\u0003\u0002?\u007f%\u0011A(P\u0005\u0004\u0003\u0007Y\u0014A\u0004)s_\u000e,7o]'fiJL7m]\u0005\u0005\u0003\u000f\tIA\u0001\nQe>\u001cWm]:J]N$(/^7f]R\u001c(bAA\u0002w\u00059r\f\u001d:pG\u0016\u001c8o\u00119v\u0013:\u001cHO];nK:$8\u000fI\u0001\u0010?\u000e|G\u000e\\3di&|g\u000eV1tWV\u0011\u0011\u0011\u0003\t\u0004\u0003'\u0019R\"\u0001\u0001\u0003+5+GO]5dg\u000e{G\u000e\\3di&|g\u000eV1tWN\u00111#\u0012\u000b\u0003\u0003#\t1bX:zgR,W.\u00138g_V\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0011\u0011QE\u0001\u0005_ND\u0017.\u0003\u0003\u0002*\u0005\r\"AC*zgR,W.\u00138g_\u0006aql]=ti\u0016l\u0017J\u001c4pA\u0005!q\f[1m+\t\t\t\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\u0011\t9$a\t\u0002\u0011!\f'\u000fZ<be\u0016LA!a\u000f\u00026\tA\u0002*\u0019:eo\u0006\u0014X-\u00112tiJ\f7\r^5p]2\u000b\u00170\u001a:\u0002\u000b}C\u0017\r\u001c\u0011\u0002\u0007}{7/\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013AA8t\u0015\u0011\ti%a\t\u0002\u0011M|g\r^<be\u0016LA!!\u0015\u0002H\tyq\n]3sCRLgnZ*zgR,W.\u0001\u0003`_N\u0004\u0013\u0001B0qS\u0012,\"!!\u0017\u0011\u0007\u0019\u000bY&C\u0002\u0002^\u001d\u00131!\u00138u\u0003\u0015y\u0006/\u001b3!\u0003=y\u0006O]8dKN\u001cxN]\"pk:$XCAA3!\r1\u0015qM\u0005\u0004\u0003S:%A\u0002#pk\ndW-\u0001\t`aJ|7-Z:t_J\u001cu.\u001e8uA\u00059r\f\u001d:fm&|Wo\u001d)s_\u000e,7o]\"qkRKW.Z\u000b\u0003\u0003c\u0002RARA:\u0003oJ1!!\u001eH\u0005\u0015\t%O]1z!\r1\u0015\u0011P\u0005\u0004\u0003w:%\u0001\u0002'p]\u001e\f1d\u00189sKZLw.^:Qe>\u001cWm]:DaV$\u0016.\\3`I\u0015\fH\u0003BAA\u0003\u000f\u00032ARAB\u0013\r\t)i\u0012\u0002\u0005+:LG\u000fC\u0005\u0002\n\u0002\n\t\u00111\u0001\u0002r\u0005\u0019\u0001\u0010J\u0019\u00021}\u0003(/\u001a<j_V\u001c\bK]8dKN\u001c8\t];US6,\u0007%\u0001\u0005tG\",G-\u001e7f)\u0011\t\t)!%\t\u000bE\u0013\u0003\u0019\u0001*\u0002\u000f\rdW-\u00198vaR\u0011\u0011\u0011Q\u0001\u0011e\u0016\u001cwN\u001d3Qe>\u001cWm]:DaV\fAC]3d_J$\u0007K]8dKN\u001cX\u000bT5nSR\u001c\u0018\u0001E0d_2dWm\u0019;j_:$\u0016m]6!\u0003My6m\u001c7mK\u000e$\u0018n\u001c8TG\",G-\u001e7f+\t\t\t\u000b\r\u0003\u0002$\u0006U\u0006CBAS\u0003[\u000b\t,\u0004\u0002\u0002(*\u0019Q+!+\u000b\u0007\u0005-6-\u0001\u0003vi&d\u0017\u0002BAX\u0003O\u0013qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0005\u0003g\u000b)\f\u0004\u0001\u0005\u0017\u0005]F\"!A\u0001\u0002\u000b\u0005\u00111\u0018\u0002\u0003\u007fA\nAcX2pY2,7\r^5p]N\u001b\u0007.\u001a3vY\u0016\u0004\u0013\u0003BA_\u0003\u0007\u00042ARA`\u0013\r\t\tm\u0012\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0017QY\u0005\u0004\u0003\u000f\f'AB(cU\u0016\u001cG/\u0001\b`Q&\u001c7-\u001e9N_:LGo\u001c:\u0016\u0005\u00055\u0007cAA\nM\ti\u0001*[2dkBluN\\5u_J\u001c2AJAj!\r\u0001\u0017Q[\u0005\u0004\u0003/\f'A\u0002+ie\u0016\fG-\u0001\tiS\u000e\u001cW\u000f\u001d+j[\u0016lU\r\u001e:jGB!\u0011Q\\Ar\u001b\t\tyNC\u0002\u0002b\u0006\u000ba!\\3ue&\u001c\u0017\u0002BAs\u0003?\u0014Q\u0001V5nKJ\f\u0001\u0002Z;sCRLwN\u001c\t\u0005\u0003W\f\t0\u0004\u0002\u0002n*\u0019\u0011q^2\u0002\tQLW.Z\u0005\u0005\u0003g\fiO\u0001\u0005EkJ\fG/[8o)\u0019\ti-a>\u0002z\"9\u0011\u0011\\\u0015A\u0002\u0005m\u0007bBAtS\u0001\u0007\u0011\u0011^\u0001\r?\"L7mY;q\u001d\u0006twn]\u000b\u0003\u0003o\n\u0001c\u00185jG\u000e,\bOT1o_N|F%Z9\u0015\t\u0005\u0005%1\u0001\u0005\n\u0003\u0013[\u0013\u0011!a\u0001\u0003o\nQb\u00185jG\u000e,\bOT1o_N\u0004\u0003f\u0001\u0017\u0003\nA\u0019aIa\u0003\n\u0007\t5qI\u0001\u0005w_2\fG/\u001b7f\u0003\u0019yFm\u001c*v]V\u0011!1\u0003\t\u0004\r\nU\u0011b\u0001B\f\u000f\n9!i\\8mK\u0006t\u0017AC0e_J+hn\u0018\u0013fcR!\u0011\u0011\u0011B\u000f\u0011%\tIILA\u0001\u0002\u0004\u0011\u0019\"A\u0004`I>\u0014VO\u001c\u0011)\u0007=\u0012I!A\u0002sk:\faA]3d_J$GCBAA\u0005S\u0011i\u0003C\u0004\u0003,E\u0002\r!a\u001e\u0002\u000bY\fG.^3\t\u000f\t=\u0012\u00071\u0001\u0002x\u0005\u0019S\r\u001f9fGR,G-\u00138uKJ4\u0018\r\u001c\"fi^,WM\u001c,bYV,7+Y7qY\u0016\u001c\u0018!\u0003;fe6Lg.\u0019;f\u00039)\b\u000fZ1uK&sG/\u001a:wC2$B!!!\u00038!9\u0011q]\u001aA\u0002\u0005%\u0018aD0iS\u000e\u001cW\u000f]'p]&$xN\u001d\u0011\u0002\tM$x\u000e]\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0003\u0002\u0002\n\u0005\u0003b\u0002B\"!\u0001\u0007!QI\u0001\n]\u0016<8i\u001c8gS\u001e\u0004BAa\u0012\u0003V5\u0011!\u0011\n\u0006\u0005\u0005\u0017\u0012i%\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0005\u001f\u0012\t&\u0001\u0005usB,7/\u00194f\u0015\t\u0011\u0019&A\u0002d_6LAAa\u0016\u0003J\t11i\u001c8gS\u001e\f!c]2iK\u0012,H.Z(o\u001b>$W\u000f\\3F\u0007R!!Q\fB2!\r\u0001'qL\u0005\u0004\u0005C\n'\u0001\u0003*v]:\f'\r\\3\t\u000f\t\u0015\u0014\u00031\u0001\u0002\u0012\u0005!A/Y:l\u0003I\u0019H/\u0019:u\u0011&\u001c7-\u001e9N_:LGo\u001c:\u0015\u0005\u00055\u0017a\u0006)s_\u000e,7o]'fiJL7m]\"pY2,7\r^8s!\tYVg\u0005\u00026\u000bR\u0011!Q\u000e\u0002\b\r\u0006\u001cGo\u001c:z'\u00119TIa\u001e\u0011\u00071\u0013I(C\u0002\u0003|5\u0013Q\"T8ek2,g)Y2u_JLHC\u0001B@!\r\u0011\tiN\u0007\u0002k\u000511M]3bi\u0016$2a\u0013BD\u0011\u001d\u0011I)\u000fa\u0001\u0005\u0017\u000b\u0001b]3ui&twm\u001d\t\u0005\u0005\u001b\u0013\u0019JD\u0002M\u0005\u001fK1A!%N\u00035iu\u000eZ;mK\u001a\u000b7\r^8ss&!!Q\u0013BL\u0005!\u0019V\r\u001e;j]\u001e\u001c(b\u0001BI\u001b\u0002")
public class ProcessMetricsCollector
implements Module {
    public final ExecutionContext kamon$instrumentation$system$process$ProcessMetricsCollector$$ec;
    private final String _hiccupIntervalPath;
    private final TagSet _defaultTags;
    private final ProcessMetrics.ProcessInstruments kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments;
    private final MetricsCollectionTask _collectionTask;
    private final ScheduledFuture<?> _collectionSchedule;
    private final HiccupMonitor _hiccupMonitor;

    private String _hiccupIntervalPath() {
        return this._hiccupIntervalPath;
    }

    private TagSet _defaultTags() {
        return this._defaultTags;
    }

    public ProcessMetrics.ProcessInstruments kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments() {
        return this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments;
    }

    private MetricsCollectionTask _collectionTask() {
        return this._collectionTask;
    }

    private ScheduledFuture<?> _collectionSchedule() {
        return this._collectionSchedule;
    }

    private HiccupMonitor _hiccupMonitor() {
        return this._hiccupMonitor;
    }

    public void stop() {
        this._hiccupMonitor().terminate();
        this._collectionSchedule().cancel(false);
        this._collectionTask().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this._hiccupMonitor().updateInterval(newConfig.getDuration(this._hiccupIntervalPath()));
    }

    private Runnable scheduleOnModuleEC(MetricsCollectionTask task) {
        return new Runnable(this, task){
            private final /* synthetic */ ProcessMetricsCollector $outer;
            private final MetricsCollectionTask task$1;

            public void run() {
                this.task$1.schedule(this.$outer.kamon$instrumentation$system$process$ProcessMetricsCollector$$ec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private HiccupMonitor startHiccupMonitor() {
        void var2_2;
        Duration interval = Kamon$.MODULE$.config().getDuration(this._hiccupIntervalPath());
        HiccupMonitor monitorThread = new HiccupMonitor(this, this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().hiccups(), interval);
        monitorThread.setDaemon(true);
        monitorThread.setName("hiccup-monitor");
        monitorThread.start();
        return var2_2;
    }

    public ProcessMetricsCollector(ExecutionContext ec) {
        this.kamon$instrumentation$system$process$ProcessMetricsCollector$$ec = ec;
        this._hiccupIntervalPath = "kamon.instrumentation.system.process.hiccup-monitor-interval";
        this._defaultTags = TagSet$.MODULE$.of("component", "process");
        this.kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments = new ProcessMetrics.ProcessInstruments(this._defaultTags());
        this._collectionTask = new MetricsCollectionTask();
        this._collectionSchedule = Kamon$.MODULE$.scheduler().scheduleAtFixedRate(this.scheduleOnModuleEC(this._collectionTask()), 1L, 1L, TimeUnit.SECONDS);
        this._hiccupMonitor = this.startHiccupMonitor();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new ProcessMetricsCollector(settings.executionContext());
        }
    }

    public final class HiccupMonitor
    extends Thread {
        private final Timer hiccupTimeMetric;
        private volatile long _hiccupNanos;
        private volatile boolean _doRun;

        private long _hiccupNanos() {
            return this._hiccupNanos;
        }

        private void _hiccupNanos_$eq(long x$1) {
            this._hiccupNanos = x$1;
        }

        private boolean _doRun() {
            return this._doRun;
        }

        private void _doRun_$eq(boolean x$1) {
            this._doRun = x$1;
        }

        @Override
        public void run() {
            LongRef shortestObservedDelta = LongRef.create((long)Long.MAX_VALUE);
            while (this._doRun()) {
                long hiccupTime = HiccupMonitor.hic$1(this._hiccupNanos(), shortestObservedDelta);
                this.record(hiccupTime, this._hiccupNanos());
            }
        }

        public void record(long value, long expectedIntervalBetweenValueSamples) {
            this.hiccupTimeMetric.record(value);
            if (expectedIntervalBetweenValueSamples > 0L) {
                for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
                    this.hiccupTimeMetric.record(missingValue);
                }
            }
        }

        public void terminate() {
            this._doRun_$eq(false);
        }

        public void updateInterval(Duration duration) {
            this._hiccupNanos_$eq(duration.toNanos());
        }

        private static final long hic$1(long resolution, LongRef shortestObservedDelta$1) {
            long delta;
            block0: {
                long start = System.nanoTime();
                TimeUnit.NANOSECONDS.sleep(resolution);
                delta = System.nanoTime() - start;
                if (delta >= shortestObservedDelta$1.elem) break block0;
                shortestObservedDelta$1.elem = delta;
            }
            return delta - shortestObservedDelta$1.elem;
        }

        public HiccupMonitor(ProcessMetricsCollector $outer, Timer hiccupTimeMetric, Duration duration) {
            this.hiccupTimeMetric = hiccupTimeMetric;
            this._hiccupNanos = duration.toNanos();
            this._doRun = true;
        }
    }

    public class MetricsCollectionTask {
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final int _pid;
        private final double _processorCount;
        private long[] _previousProcessCpuTime;

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private int _pid() {
            return this._pid;
        }

        private double _processorCount() {
            return this._processorCount;
        }

        private long[] _previousProcessCpuTime() {
            return this._previousProcessCpuTime;
        }

        private void _previousProcessCpuTime_$eq(long[] x$1) {
            this._previousProcessCpuTime = x$1;
        }

        public void schedule(ExecutionContext ec) {
            Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.recordProcessCpu();
                this.recordProcessULimits();
            }, ec);
        }

        public void cleanup() {
            this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().remove();
        }

        private void recordProcessCpu() {
            BoxedUnit boxedUnit;
            OSProcess process = this._os().getProcess(this._pid());
            long[] previous = this._previousProcessCpuTime();
            long[] current = new long[]{process.getKernelTime(), process.getUserTime(), process.getUpTime()};
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.longArrayOps(previous))) {
                long kernelTime = package$.MODULE$.max(0L, current[0] - previous[0]);
                long userTime = package$.MODULE$.max(0L, current[1] - previous[1]);
                long totalTime = package$.MODULE$.max(0L, current[2] - previous[2]);
                this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().user().record(this.toPercent$1(userTime, totalTime));
                this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().system().record(this.toPercent$1(kernelTime, totalTime));
                boxedUnit = this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().combined().record(this.toPercent$1(userTime + kernelTime, totalTime));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this._previousProcessCpuTime_$eq(current);
        }

        private void recordProcessULimits() {
            OSProcess process = this._os().getProcess(this._pid());
            this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().openFilesCurrent().update((double)Math.max(process.getOpenFiles(), 0L));
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                BoxedUnit boxedUnit;
                if (Platform.isLinux()) {
                    List allLimits = FileUtil.readFile((String)String.format(new StringBuilder(13).append("/proc/").append(this._pid()).append("/limits").toString(), new Object[0]));
                    boxedUnit = ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)allLimits).asScala()).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsCollectionTask.$anonfun$recordProcessULimits$2(x$1))).map((Function1 & Serializable)openFilesLimitLine -> {
                        int openFilesLimit = ParseUtil.getNthIntValue((String)openFilesLimitLine, (int)1);
                        return this.kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer().kamon$instrumentation$system$process$ProcessMetricsCollector$$_processCpuInstruments().openFilesLimit().update((double)openFilesLimit);
                    });
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }

        public /* synthetic */ ProcessMetricsCollector kamon$instrumentation$system$process$ProcessMetricsCollector$MetricsCollectionTask$$$outer() {
            return ProcessMetricsCollector.this;
        }

        private final long toPercent$1(long value, long totalTime$1) {
            return totalTime$1 > 0L ? (long)(100.0 * (double)value / (double)totalTime$1 / this._processorCount()) : 0L;
        }

        public static final /* synthetic */ boolean $anonfun$recordProcessULimits$2(String x$1) {
            return x$1.toLowerCase().startsWith("max open files");
        }

        public MetricsCollectionTask() {
            if (ProcessMetricsCollector.this == null) {
                throw null;
            }
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._pid = this._os().getProcessId();
            this._processorCount = this._hal().getProcessor().getLogicalProcessorCount();
            this._previousProcessCpuTime = (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long());
        }
    }
}

