/*
 * Decompiled with CFR 0.152.
 */
package kamon.annotation.instrumentation.advisor;

import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import kamon.Kamon;
import kamon.annotation.instrumentation.cache.AnnotationCache;
import kamon.annotation.util.Hooks;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.trace.Span;
import kamon.trace.SpanBuilder;
import kamon.util.CallingThreadExecutionContext$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import kanela.agent.libs.net.bytebuddy.implementation.bytecode.assign.Assigner;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public final class TraceAnnotationAdvisor {
    public static final ExecutionContext CallingThreadEC = CallingThreadExecutionContext$.MODULE$;

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void startSpan(@Advice.This(optional=true) Object object, @Advice.Origin Class<?> clazz, @Advice.Origin Method method, @Advice.Origin(value="#t") String string, @Advice.Origin(value="#m") String string2, @Advice.Local(value="span") Span span, @Advice.Local(value="scope") Storage.Scope scope) {
        SpanBuilder spanBuilder = AnnotationCache.getSpanBuilder(method, object, clazz, string, string2);
        span = spanBuilder.start();
        scope = Kamon.storeContext((Context)Kamon.currentContext().withEntry(span.Key(), (Object)span));
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void stopSpan(@Advice.Local(value="span") Span span, @Advice.Local(value="scope") Storage.Scope scope, @Advice.Thrown Throwable throwable, @Advice.Return(typing=Assigner.Typing.DYNAMIC) Object object) {
        scope.close();
        if (object instanceof Future) {
            Hooks.finishSpanOnComplete((Future)object, span);
        } else if (object instanceof CompletionStage) {
            ((CompletionStage)object).handle(new CompletionStageCompleteFunction(span));
        } else {
            if (throwable != null) {
                span.fail(throwable.getMessage(), throwable);
            }
            span.finish();
        }
    }

    public static class CompletionStageCompleteFunction<T>
    implements BiFunction<T, Throwable, Object> {
        private final Span span;

        public CompletionStageCompleteFunction(Span span) {
            this.span = span;
        }

        @Override
        public Object apply(T t, Throwable throwable) {
            if (throwable == null) {
                this.span.finish();
            } else {
                this.span.fail(throwable).finish();
            }
            return null;
        }
    }
}

