/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.play;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import kamon.Kamon$;
import kamon.instrumentation.context.HasTimestamp;
import kamon.instrumentation.http.HttpMessage;
import kamon.instrumentation.http.HttpServerInstrumentation;
import kamon.instrumentation.play.HasServerInstrumentation;
import kamon.instrumentation.play.NettyPlayRequestHandlerHandleAdvice;
import kamon.util.CallingThreadExecutionContext$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class NettyPlayRequestHandlerHandleAdvice$ {
    public static final NettyPlayRequestHandlerHandleAdvice$ MODULE$ = new NettyPlayRequestHandlerHandleAdvice$();

    @Advice.OnMethodEnter
    public NettyPlayRequestHandlerHandleAdvice.RequestProcessingContext enter(@Advice.This Object requestHandler, @Advice.Argument(value=0) Channel channel, @Advice.Argument(value=1) HttpRequest request) {
        BoxedUnit boxedUnit;
        HasServerInstrumentation playRequestHandler = (HasServerInstrumentation)requestHandler;
        HttpServerInstrumentation serverInstrumentation = playRequestHandler.serverInstrumentation();
        HttpServerInstrumentation.RequestHandler serverRequestHandler = serverInstrumentation.createHandler(this.toRequest(request, serverInstrumentation.interface(), serverInstrumentation.port()), true);
        if (!playRequestHandler.hasBeenUsedBefore()) {
            playRequestHandler.markAsUsed();
            boxedUnit = channel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(playRequestHandler, serverInstrumentation){
                private final HasServerInstrumentation playRequestHandler$1;
                private final HttpServerInstrumentation serverInstrumentation$1;

                public void operationComplete(Future<? super Void> future) {
                    Instant connectionEstablishedTime = Kamon$.MODULE$.clock().toInstant(((HasTimestamp)((Object)this.playRequestHandler$1)).timestamp());
                    Duration aliveTime = Duration.between(connectionEstablishedTime, Kamon$.MODULE$.clock().instant());
                    this.serverInstrumentation$1.connectionClosed(aliveTime, this.playRequestHandler$1.handledRequests());
                }
                {
                    this.playRequestHandler$1 = playRequestHandler$1;
                    this.serverInstrumentation$1 = serverInstrumentation$1;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        playRequestHandler.requestHandled();
        return new NettyPlayRequestHandlerHandleAdvice.RequestProcessingContext(serverRequestHandler, Kamon$.MODULE$.storeContext(serverRequestHandler.context()));
    }

    @Advice.OnMethodExit
    public void exit(@Advice.Enter NettyPlayRequestHandlerHandleAdvice.RequestProcessingContext rpContext, @Advice.Return scala.concurrent.Future<HttpResponse> result) {
        HttpServerInstrumentation.RequestHandler reqHandler = rpContext.requestHandler();
        result.onComplete((Function1 & Serializable)x0$1 -> {
            NettyPlayRequestHandlerHandleAdvice$.$anonfun$exit$1(reqHandler, rpContext, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
        rpContext.scope().close();
    }

    private HttpMessage.Request toRequest(HttpRequest request, String serverHost, int serverPort) {
        return new HttpMessage.Request(request, serverHost, serverPort){
            private final HttpRequest request$1;
            private final String serverHost$1;
            private final int serverPort$1;

            public String url() {
                return this.request$1.uri();
            }

            public String path() {
                return this.request$1.uri();
            }

            public String method() {
                return this.request$1.method().name();
            }

            public String host() {
                return this.serverHost$1;
            }

            public int port() {
                return this.serverPort$1;
            }

            public Option<String> read(String header) {
                return Option$.MODULE$.apply((Object)this.request$1.headers().get(header));
            }

            public Map<String, String> readAll() {
                return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.request$1.headers().entries()).asScala()).map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), e.getValue()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            {
                this.request$1 = request$1;
                this.serverHost$1 = serverHost$1;
                this.serverPort$1 = serverPort$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$readAll$1(java.util.Map$Entry )}, serializedLambda);
            }
        };
    }

    private HttpMessage.ResponseBuilder<HttpResponse> toResponse(HttpResponse response) {
        return new HttpMessage.ResponseBuilder<HttpResponse>(response){
            private final HttpResponse response$1;

            public HttpResponse build() {
                return this.response$1;
            }

            public int statusCode() {
                return this.response$1.status().code();
            }

            public void write(String header, String value) {
                this.response$1.headers().add(header, (Object)value);
            }
            {
                this.response$1 = response$1;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$exit$1(HttpServerInstrumentation.RequestHandler reqHandler$1, NettyPlayRequestHandlerHandleAdvice.RequestProcessingContext rpContext$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            HttpResponse value = (HttpResponse)success.value();
            reqHandler$1.buildResponse(MODULE$.toResponse(value), rpContext$1.scope().context());
            reqHandler$1.responseSent();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            reqHandler$1.span().fail(exception);
            reqHandler$1.responseSent();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private NettyPlayRequestHandlerHandleAdvice$() {
    }
}

