/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation.classloader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kanela.agent.libs.io.vavr.Tuple;
import kanela.agent.libs.io.vavr.collection.List;
import kanela.agent.libs.io.vavr.control.Option;

public final class ClassRefiner {
    private final String target;
    private final Map<String, Set<String>> methods;
    private final Map<String, Option<Object>> fields;

    private ClassRefiner(Builder builder) {
        this.target = builder.target;
        this.fields = builder.fields;
        this.methods = builder.methods;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, Set<String>> getMethods() {
        return this.methods;
    }

    public Map<String, Option<Object>> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassRefiner)) {
            return false;
        }
        ClassRefiner other = (ClassRefiner)o;
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        Map<String, Set<String>> this$methods = this.getMethods();
        Map<String, Set<String>> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Map<String, Option<Object>> this$fields = this.getFields();
        Map<String, Option<Object>> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        Map<String, Set<String>> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Map<String, Option<Object>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "ClassRefiner(target=" + this.getTarget() + ", methods=" + this.getMethods() + ", fields=" + this.getFields() + ")";
    }

    public static class Builder {
        private String target;
        private Map<String, Option<Object>> fields = new HashMap<String, Option<Object>>();
        private Map<String, Set<String>> methods = new HashMap<String, Set<String>>();

        @Deprecated
        public Builder mustContains(String clazz) {
            this.target = clazz;
            return this;
        }

        public Builder mustContain(String clazz) {
            this.target = clazz;
            return this;
        }

        public Builder withFields(String ... fields) {
            Arrays.asList(fields).forEach(k -> this.withFieldAndValue((String)k, null));
            return this;
        }

        public Builder withFieldAndValue(String field, Object value) {
            this.fields.put(field, Option.of(value));
            return this;
        }

        public Builder withMethod(String method, String ... params) {
            this.methods.put(method, new HashSet<String>(Arrays.asList(params)));
            return this;
        }

        public Builder withMethods(String ... methods) {
            this.methods.putAll(List.of(methods).toJavaMap(method -> Tuple.of(method, new HashSet())));
            return this;
        }

        public ClassRefiner build() {
            if (this.target == null) {
                throw new RuntimeException("We must provide a target class.");
            }
            return new ClassRefiner(this);
        }
    }
}

