/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.attacher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import kanela.agent.attacher.io.Tools;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.net.bytebuddy.agent.ByteBuddyAgent;

public final class Attacher {
    private static final Logger log = Logger.getLogger("Kanela Attacher");

    public static void attach() {
        Attacher.attachTo(Tools.getCurrentPID());
    }

    private static void attachTo(String pid) {
        Try.of(() -> Class.forName("kanela.agent.Kanela")).flatMapTry(Attacher::kanelaJar).andThen(agentJar -> ByteBuddyAgent.attach(agentJar, pid)).onFailure(cause -> log.severe(() -> "Error trying to attach the KanelaAttacher Agent to process with Id: " + pid + " with error: " + cause.getMessage()));
    }

    private static Try<File> kanelaJar(Class clazz) {
        return Try.of(() -> Attacher.getKanelaJar(clazz)).orElse(() -> Try.of(() -> Attacher.generateKanelaJar(clazz, new Class[0]))).onFailure(cause -> log.severe(() -> "Error trying to obtain the KanelaAttacher Agent jar: " + cause.getMessage()));
    }

    private static File getKanelaJar(Class clazz) throws URISyntaxException {
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        return Paths.get(location.toURI()).toFile();
    }

    private static File generateKanelaJar(Class agent, Class ... resources) throws IOException {
        File jarFile = File.createTempFile("agent", ".jar");
        jarFile.deleteOnExit();
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(new Attributes.Name("Agent-Class"), agent.getName());
        mainAttributes.put(new Attributes.Name("Main-Class"), "kanela.agent.attacher.Attacher");
        mainAttributes.put(new Attributes.Name("Can-Retransform-Classes"), "true");
        mainAttributes.put(new Attributes.Name("Can-Redefine-Classes"), "true");
        mainAttributes.put(new Attributes.Name("Can-Set-Native-Method-Prefix"), "true");
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        jos.putNextEntry(new JarEntry(agent.getName().replace('.', '/') + ".class"));
        jos.write(Tools.getBytesFromStream(Objects.requireNonNull(agent.getClassLoader().getResourceAsStream(Tools.unqualify(agent)))));
        jos.closeEntry();
        for (Class clazz : resources) {
            String name = Tools.unqualify(clazz);
            jos.putNextEntry(new JarEntry(name));
            jos.write(Tools.getBytesFromStream(Objects.requireNonNull(clazz.getClassLoader().getResourceAsStream(name))));
            jos.closeEntry();
        }
        jos.close();
        return jarFile;
    }

    public static void main(String ... args) {
        try {
            if (args.length < 1) {
                log.info("Proper Usage is: java -jar kanela-agent.jar <pid>");
                System.exit(0);
            }
            Attacher.attachTo(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Attacher;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Attacher()";
    }
}

