/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.reinstrument;

import java.lang.instrument.Instrumentation;
import java.text.MessageFormat;
import kanela.agent.broker.EventBroker;
import kanela.agent.broker.Subscribe;
import kanela.agent.builder.KanelaFileTransformer;
import kanela.agent.libs.io.vavr.collection.LinearSeq;
import kanela.agent.libs.io.vavr.collection.List;
import kanela.agent.libs.io.vavr.control.Try;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.util.annotation.Experimental;
import kanela.agent.util.conf.KanelaConfiguration;
import kanela.agent.util.log.Logger;

@Experimental
public final class Reinstrumenter {
    private final Instrumentation instrumentation;
    private final KanelaConfiguration configuration;
    private final List<KanelaFileTransformer> transformers;

    public static void attach(Instrumentation instrumentation, KanelaConfiguration configuration, List<KanelaFileTransformer> transformers) {
        Try.of(() -> new Reinstrumenter(instrumentation, configuration, transformers)).andThen(() -> Logger.info(() -> MessageFormat.format("Reinstrumenter activated.", new Object[0]))).andThen(reinstrumenter -> EventBroker.instance().add(reinstrumenter)).andThen(() -> Logger.debug(() -> MessageFormat.format("Reinstrumenter is listening for Reinstrumentation Events.", new Object[0]))).onFailure(cause -> Logger.error(() -> MessageFormat.format("Error when trying to activate Reinstrumenter.", new Object[0]), cause));
    }

    @Subscribe
    public void onStopModules(ReinstrumentationProtocol.StopModules stopEvent) {
        Logger.warn(() -> "Trying to stop modules.....");
        LinearSeq stoppables = this.transformers.filter(KanelaFileTransformer::isStoppable).map(KanelaFileTransformer::getClassFileTransformer).map(transformer -> transformer.reset(this.instrumentation, AgentBuilder.RedefinitionStrategy.RETRANSFORMATION));
        if (stoppables.forAll(s2 -> s2.equals(true))) {
            Logger.warn(() -> "All modules are been stopped.");
        } else {
            Logger.warn(() -> "Error trying stop some modules.");
        }
    }

    @Subscribe
    public void onRestartModules(ReinstrumentationProtocol.RestartModules restartEvent) {
        Logger.warn(() -> "Trying to reapply the removed transformations...");
        this.transformers.filter(KanelaFileTransformer::isStoppable).map(KanelaFileTransformer::getAgentBuilder).forEach(transformer -> transformer.installOn(this.instrumentation));
    }

    public Reinstrumenter(Instrumentation instrumentation, KanelaConfiguration configuration, List<KanelaFileTransformer> transformers) {
        this.instrumentation = instrumentation;
        this.configuration = configuration;
        this.transformers = transformers;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public KanelaConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<KanelaFileTransformer> getTransformers() {
        return this.transformers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reinstrumenter)) {
            return false;
        }
        Reinstrumenter other = (Reinstrumenter)o;
        Instrumentation this$instrumentation = this.getInstrumentation();
        Instrumentation other$instrumentation = other.getInstrumentation();
        if (this$instrumentation == null ? other$instrumentation != null : !this$instrumentation.equals(other$instrumentation)) {
            return false;
        }
        KanelaConfiguration this$configuration = this.getConfiguration();
        KanelaConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<KanelaFileTransformer> this$transformers = this.getTransformers();
        List<KanelaFileTransformer> other$transformers = other.getTransformers();
        return !(this$transformers == null ? other$transformers != null : !this$transformers.equals(other$transformers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instrumentation $instrumentation = this.getInstrumentation();
        result = result * 59 + ($instrumentation == null ? 43 : $instrumentation.hashCode());
        KanelaConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<KanelaFileTransformer> $transformers = this.getTransformers();
        result = result * 59 + ($transformers == null ? 43 : $transformers.hashCode());
        return result;
    }

    public String toString() {
        return "Reinstrumenter(instrumentation=" + this.getInstrumentation() + ", configuration=" + this.getConfiguration() + ", transformers=" + this.getTransformers() + ")";
    }

    public static interface ReinstrumentationProtocol {

        public static final class RestartModules {
            private RestartModules() {
            }

            public static RestartModules instance() {
                return new RestartModules();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof RestartModules;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "Reinstrumenter.ReinstrumentationProtocol.RestartModules()";
            }
        }

        public static final class StopModules {
            private StopModules() {
            }

            public static StopModules instance() {
                return new StopModules();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof StopModules;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "Reinstrumenter.ReinstrumentationProtocol.StopModules()";
            }
        }
    }
}

