/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kanela.agent.Kanela;
import kanela.agent.libs.io.vavr.control.Try;

public final class Jar {
    public static Try<JarFile> getEmbeddedJar(String jarName) {
        return Jar.getEmbeddedFile(jarName).mapTry(file -> new JarFile(file.getFile()));
    }

    public static Try<URL> getEmbeddedFile(String jarName) {
        return Try.of(() -> {
            File tempFile = File.createTempFile(jarName, ".jar");
            tempFile.deleteOnExit();
            InputStream resourceAsStream = Kanela.class.getResourceAsStream(jarName);
            Files.copy(resourceAsStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return tempFile.toURI().toURL();
        });
    }

    public static Try<List<ExtensionJar>> fromString(String arguments) {
        return Jar.stringToMap(arguments).mapTry(map -> map.entrySet().stream().map(k -> ExtensionJar.from((String)k.getKey(), (String)k.getValue())).collect(Collectors.toList()));
    }

    public static Try<List<String>> searchWith(Pattern pattern) {
        return Jar.getKanelaJar().mapTry(kanelaJar -> {
            ArrayList<String> names = new ArrayList<String>();
            try (JarFile jarFile = new JarFile((String)kanelaJar);){
                Enumeration<JarEntry> entries2 = jarFile.entries();
                while (entries2.hasMoreElements()) {
                    JarEntry jarEntry = entries2.nextElement();
                    if (!pattern.matcher(jarEntry.getName()).matches()) continue;
                    names.add(jarEntry.getName());
                }
            }
            return names;
        });
    }

    private static Try<Map<String, String>> stringToMap(String value) {
        return Try.of(() -> Arrays.stream(value.split(";")).map(s2 -> s2.split(":")).collect(Collectors.toMap(k -> k[0], v -> v[1])));
    }

    public static Try<String> getKanelaJar() {
        return Try.of(() -> {
            String filePath = Kanela.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            return URLDecoder.decode(filePath, "UTF-8");
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Jar;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Jar()";
    }

    static final class ExtensionJar {
        private final String agentLocation;
        private final String classLoader;

        private ExtensionJar(String agentLocation, String classLoader) {
            this.agentLocation = agentLocation;
            this.classLoader = classLoader;
        }

        public static ExtensionJar from(String agentLocation, String classLoader) {
            return new ExtensionJar(agentLocation, classLoader);
        }

        public String getAgentLocation() {
            return this.agentLocation;
        }

        public String getClassLoader() {
            return this.classLoader;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtensionJar)) {
                return false;
            }
            ExtensionJar other = (ExtensionJar)o;
            String this$agentLocation = this.getAgentLocation();
            String other$agentLocation = other.getAgentLocation();
            if (this$agentLocation == null ? other$agentLocation != null : !this$agentLocation.equals(other$agentLocation)) {
                return false;
            }
            String this$classLoader = this.getClassLoader();
            String other$classLoader = other.getClassLoader();
            return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $agentLocation = this.getAgentLocation();
            result = result * 59 + ($agentLocation == null ? 43 : $agentLocation.hashCode());
            String $classLoader = this.getClassLoader();
            result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
            return result;
        }

        public String toString() {
            return "Jar.ExtensionJar(agentLocation=" + this.getAgentLocation() + ", classLoader=" + this.getClassLoader() + ")";
        }
    }
}

