/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.CreateFunctionalStatement;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.ResetStatement;
import net.sf.jsqlparser.statement.RollbackStatement;
import net.sf.jsqlparser.statement.SavepointStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterSession;
import net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.schema.CreateSchema;
import net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.grant.Grant;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.show.ShowTablesStatement;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.AlterDeParser;
import net.sf.jsqlparser.util.deparser.AlterSequenceDeParser;
import net.sf.jsqlparser.util.deparser.AlterSessionDeParser;
import net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import net.sf.jsqlparser.util.deparser.CreateSequenceDeParser;
import net.sf.jsqlparser.util.deparser.CreateSynonymDeparser;
import net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import net.sf.jsqlparser.util.deparser.DeclareStatementDeParser;
import net.sf.jsqlparser.util.deparser.DeleteDeParser;
import net.sf.jsqlparser.util.deparser.DropDeParser;
import net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.GrantDeParser;
import net.sf.jsqlparser.util.deparser.InsertDeParser;
import net.sf.jsqlparser.util.deparser.ReplaceDeParser;
import net.sf.jsqlparser.util.deparser.ResetStatementDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowColumnsStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowTablesStatementDeparser;
import net.sf.jsqlparser.util.deparser.UpdateDeParser;
import net.sf.jsqlparser.util.deparser.UpsertDeParser;
import net.sf.jsqlparser.util.deparser.UseStatementDeParser;
import net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;

public class StatementDeParser
extends AbstractDeParser<Statement>
implements StatementVisitor {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public StatementDeParser(StringBuilder buffer) {
        this(new ExpressionDeParser(), new SelectDeParser(), buffer);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        super(buffer);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
    }

    @Override
    public void visit(CreateIndex createIndex) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this, this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        AlterViewDeParser alterViewDeParser = new AlterViewDeParser(this.buffer);
        alterViewDeParser.deParse(alterView);
    }

    @Override
    public void visit(Delete delete) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        DropDeParser dropDeParser = new DropDeParser(this.buffer);
        dropDeParser.deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    @Override
    public void visit(Select select) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                withItem.accept(this.selectDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(this.selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
        this.buffer.append("TRUNCATE TABLE ");
        this.buffer.append(truncate.getTable());
        if (truncate.getCascade()) {
            this.buffer.append(" CASCADE");
        }
    }

    @Override
    public void visit(Update update) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        updateDeParser.deParse(update);
    }

    @Override
    public void visit(Alter alter) {
        AlterDeParser alterDeParser = new AlterDeParser(this.buffer);
        alterDeParser.deParse(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        executeDeParser.deParse(execute);
    }

    @Override
    public void visit(SetStatement set) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        setStatementDeparser.deParse(set);
    }

    @Override
    public void visit(ResetStatement reset) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        ResetStatementDeParser setStatementDeparser = new ResetStatementDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        setStatementDeparser.deParse(reset);
    }

    @Override
    public void visit(Merge merge2) {
        this.buffer.append(merge2.toString());
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
        this.buffer.append(savepointStatement.toString());
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
        this.buffer.append(rollbackStatement.toString());
    }

    @Override
    public void visit(Commit commit) {
        this.buffer.append(commit.toString());
    }

    @Override
    public void visit(Upsert upsert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        UpsertDeParser upsertDeParser = new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        upsertDeParser.deParse(upsert);
    }

    @Override
    public void visit(UseStatement use) {
        new UseStatementDeParser(this.buffer).deParse(use);
    }

    @Override
    public void visit(ShowColumnsStatement show) {
        new ShowColumnsStatementDeParser(this.buffer).deParse(show);
    }

    @Override
    public void visit(ShowTablesStatement showTables) {
        new ShowTablesStatementDeparser(this.buffer).deParse(showTables);
    }

    @Override
    public void visit(Block block) {
        this.buffer.append("BEGIN\n");
        if (block.getStatements() != null) {
            for (Statement stmt : block.getStatements().getStatements()) {
                stmt.accept(this);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END");
    }

    @Override
    public void visit(Comment comment) {
        this.buffer.append(comment.toString());
    }

    @Override
    public void visit(ValuesStatement values) {
        this.expressionDeParser.setBuffer(this.buffer);
        new ValuesStatementDeParser(this.expressionDeParser, this.buffer).deParse(values);
    }

    @Override
    public void visit(DescribeStatement describe) {
        this.buffer.append("DESCRIBE ");
        this.buffer.append(describe.getTable());
    }

    @Override
    public void visit(ExplainStatement explain) {
        this.buffer.append("EXPLAIN ");
        if (explain.getOptions() != null) {
            this.buffer.append(explain.getOptions().values().stream().map(ExplainStatement.Option::formatOption).collect(Collectors.joining(" ")));
            this.buffer.append(" ");
        }
        explain.getStatement().accept(this);
    }

    @Override
    public void visit(ShowStatement show) {
        new ShowStatementDeParser(this.buffer).deParse(show);
    }

    @Override
    public void visit(DeclareStatement declare) {
        this.expressionDeParser.setBuffer(this.buffer);
        new DeclareStatementDeParser(this.expressionDeParser, this.buffer).deParse(declare);
    }

    @Override
    public void visit(Grant grant) {
        GrantDeParser grantDeParser = new GrantDeParser(this.buffer);
        grantDeParser.deParse(grant);
    }

    @Override
    public void visit(CreateSchema aThis) {
        this.buffer.append(aThis.toString());
    }

    @Override
    public void visit(CreateSequence createSequence) {
        new CreateSequenceDeParser(this.buffer).deParse(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        new AlterSequenceDeParser(this.buffer).deParse(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.buffer.append(createFunctionalStatement.toString());
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        new CreateSynonymDeparser(this.buffer).deParse(createSynonym);
    }

    @Override
    void deParse(Statement statement) {
        statement.accept(this);
    }

    @Override
    public void visit(AlterSession alterSession) {
        new AlterSessionDeParser(this.buffer).deParse(alterSession);
    }
}

