/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.event.SubchannelClassification;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.remote.HeartbeatHistory;
import org.apache.pekko.remote.HeartbeatHistory$;
import org.apache.pekko.remote.PhiAccrualFailureDetector$State$;
import org.apache.pekko.remote.RemoteLogMarker$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tUf\u0001B\u001e=\u0001\u0015C\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0011)A\u0005%\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Y\u0011!a\u0006A!b\u0001\n\u0003i\u0006\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u001d\u0004!Q1A\u0005\u0002uC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tS\u0002\u0011)\u0019!C\u0001;\"A!\u000e\u0001B\u0001B\u0003%a\f\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003m\u0011!)\bA!A!\u0002\u00171\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u000b\u0001A\u0011AA\u000e\u0011\u001d\t)\u0001\u0001C\u0001\u0003WA\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0017B\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005u\u0003\u0001)A\u0005\u0003/B!\"a\u0018\u0001\u0001\u0004%\tAPA1\u0011)\tI\b\u0001a\u0001\n\u0003q\u00141\u0010\u0005\t\u0003\u000f\u0003\u0001\u0015)\u0003\u0002d\u00191\u0011\u0011\u0012\u0001E\u0003\u0017C!\"!*\u0018\u0005+\u0007I\u0011AA%\u0011)\t9k\u0006B\tB\u0003%\u00111\n\u0005\u000b\u0003S;\"Q3A\u0005\u0002\u0005-\u0006BCAX/\tE\t\u0015!\u0003\u0002.\"9\u0011QA\f\u0005\u0002\u0005E\u0006\"CA^/\u0005\u0005I\u0011AA_\u0011%\t\u0019mFI\u0001\n\u0003\t)\rC\u0005\u0002\\^\t\n\u0011\"\u0001\u0002^\"I\u0011\u0011]\f\u0002\u0002\u0013\u0005\u00131\u001d\u0005\t\u0003g<\u0012\u0011!C\u0001/\"I\u0011Q_\f\u0002\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0005\u00039\u0012\u0011!C!\u0005\u0007A\u0011B!\u0005\u0018\u0003\u0003%\tAa\u0005\t\u0013\tuq#!A\u0005B\t}\u0001\"\u0003B\u0012/\u0005\u0005I\u0011\tB\u0013\u0011%\u00119cFA\u0001\n\u0003\u0012I\u0003C\u0005\u0003,]\t\t\u0011\"\u0011\u0003.\u001dI!\u0011\u0007\u0001\u0002\u0002#%!1\u0007\u0004\n\u0003\u0013\u0003\u0011\u0011!E\u0005\u0005kAq!!\u0002+\t\u0003\u0011i\u0005C\u0005\u0003()\n\t\u0011\"\u0012\u0003*!I!q\n\u0016\u0002\u0002\u0013\u0005%\u0011\u000b\u0005\n\u0005/R\u0013\u0011!CA\u00053B\u0011Ba\u001a\u0001\u0005\u0004%IA!\u001b\t\u0011\tu\u0004\u0001)A\u0005\u0005WBqAa \u0001\t\u0003\u0012\t\tC\u0004\u0003\u0000\u0001!IAa!\t\u000f\t\u001d\u0005\u0001\"\u0011\u0003\u0002\"9!\u0011\u0012\u0001\u0005F\t-\u0005B\u0002BL\u0001\u0011\u0005\u0011\u000bC\u0004\u0003\u0018\u0002!IA!'\t\u0011\t]\u0005\u0001\"\u0001?\u0005;C\u0001Ba+\u0001\u0005\u0004%I!\u0015\u0005\b\u0005[\u0003\u0001\u0015!\u0003S\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005c\u0013\u0011\u0004\u00155j\u0003\u000e\u001c'/^1m\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe*\u0011QHP\u0001\u0007e\u0016lw\u000e^3\u000b\u0005}\u0002\u0015!\u00029fW.|'BA!C\u0003\u0019\t\u0007/Y2iK*\t1)A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\r2\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013a!\u00118z%\u00164\u0007CA'O\u001b\u0005a\u0014BA(=\u0005=1\u0015-\u001b7ve\u0016$U\r^3di>\u0014\u0018!\u0003;ie\u0016\u001c\bn\u001c7e+\u0005\u0011\u0006CA$T\u0013\t!\u0006J\u0001\u0004E_V\u0014G.Z\u0001\u000bi\"\u0014Xm\u001d5pY\u0012\u0004\u0013!D7bqN\u000bW\u000e\u001d7f'&TX-F\u0001Y!\t9\u0015,\u0003\u0002[\u0011\n\u0019\u0011J\u001c;\u0002\u001d5\f\u0007pU1na2,7+\u001b>fA\u0005yQ.\u001b8Ti\u0012$UM^5bi&|g.F\u0001_!\tyF-D\u0001a\u0015\t\t'-\u0001\u0005ekJ\fG/[8o\u0015\t\u0019\u0007*\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001a1\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0001R.\u001b8Ti\u0012$UM^5bi&|g\u000eI\u0001\u0019C\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,\u0017!G1dG\u0016\u0004H/\u00192mK\"+\u0017M\u001d;cK\u0006$\b+Y;tK\u0002\naCZ5sgRDU-\u0019:uE\u0016\fG/R:uS6\fG/Z\u0001\u0018M&\u00148\u000f\u001e%fCJ$(-Z1u\u000bN$\u0018.\\1uK\u0002\n1\"\u001a<f]R\u001cFO]3b[B\u0019q)\\8\n\u00059D%AB(qi&|g\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s}\u0005)QM^3oi&\u0011A/\u001d\u0002\f\u000bZ,g\u000e^*ue\u0016\fW.A\u0003dY>\u001c7\u000e\u0005\u0002x\u007f:\u0011\u00010 \b\u0003srt!A_>\u000e\u0003\u0001K!a\u0010!\n\u0005ur\u0014B\u0001@=\u0003=1\u0015-\u001b7ve\u0016$U\r^3di>\u0014\u0018\u0002BA\u0001\u0003\u0007\u0011Qa\u00117pG.T!A \u001f\u0002\rqJg.\u001b;?)9\tI!a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033!B!a\u0003\u0002\u000eA\u0011Q\n\u0001\u0005\u0006k6\u0001\u001dA\u001e\u0005\u0006!6\u0001\rA\u0015\u0005\u0006-6\u0001\r\u0001\u0017\u0005\u000696\u0001\rA\u0018\u0005\u0006O6\u0001\rA\u0018\u0005\u0006S6\u0001\rA\u0018\u0005\u0006W6\u0001\r\u0001\u001c\u000b\r\u0003;\t\t#a\t\u0002&\u0005\u001d\u0012\u0011\u0006\u000b\u0005\u0003\u0017\ty\u0002C\u0003v\u001d\u0001\u000fa\u000fC\u0003Q\u001d\u0001\u0007!\u000bC\u0003W\u001d\u0001\u0007\u0001\fC\u0003]\u001d\u0001\u0007a\fC\u0003h\u001d\u0001\u0007a\fC\u0003j\u001d\u0001\u0007a\f\u0006\u0004\u0002\f\u00055\u00121\t\u0005\b\u0003_y\u0001\u0019AA\u0019\u0003\u0019\u0019wN\u001c4jOB!\u00111GA \u001b\t\t)D\u0003\u0003\u00020\u0005]\"\u0002BA\u001d\u0003w\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003{\t1aY8n\u0013\u0011\t\t%!\u000e\u0003\r\r{gNZ5h\u0011\u0019\t)e\u0004a\u0001_\u0006\u0011QM^\u0001\u000fM&\u00148\u000f\u001e%fCJ$(-Z1u+\t\tY\u0005E\u0002N\u0003\u001bJ1!a\u0014=\u0005AAU-\u0019:uE\u0016\fG\u000fS5ti>\u0014\u00180A\bgSJ\u001cH\u000fS3beR\u0014W-\u0019;!\u0003y\t7mY3qi\u0006\u0014G.\u001a%fCJ$(-Z1u!\u0006,8/Z'jY2L7/\u0006\u0002\u0002XA\u0019q)!\u0017\n\u0007\u0005m\u0003J\u0001\u0003M_:<\u0017aH1dG\u0016\u0004H/\u00192mK\"+\u0017M\u001d;cK\u0006$\b+Y;tK6KG\u000e\\5tA\u00059\u0011\r\u001a3sKN\u001cXCAA2!\u0011\t)'a\u001d\u000f\t\u0005\u001d\u0014q\u000e\t\u0004\u0003SBUBAA6\u0015\r\ti\u0007R\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E\u0004*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\n9H\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003cB\u0015aC1eIJ,7o]0%KF$B!! \u0002\u0004B\u0019q)a \n\u0007\u0005\u0005\u0005J\u0001\u0003V]&$\b\"CAC+\u0005\u0005\t\u0019AA2\u0003\rAH%M\u0001\tC\u0012$'/Z:tA\t)1\u000b^1uKN1qCRAG\u0003'\u00032aRAH\u0013\r\t\t\n\u0013\u0002\b!J|G-^2u!\u0011\t)*a(\u000f\t\u0005]\u00151\u0014\b\u0005\u0003S\nI*C\u0001J\u0013\r\ti\nS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t+a)\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005u\u0005*A\u0004iSN$xN]=\u0002\u0011!L7\u000f^8ss\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0016\u0005\u00055\u0006\u0003B$n\u0003/\n!\u0002^5nKN$\u0018-\u001c9!)\u0019\t\u0019,a.\u0002:B\u0019\u0011QW\f\u000e\u0003\u0001Aq!!*\u001d\u0001\u0004\tY\u0005C\u0004\u0002*r\u0001\r!!,\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003g\u000by,!1\t\u0013\u0005\u0015V\u0004%AA\u0002\u0005-\u0003\"CAU;A\u0005\t\u0019AAW\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a2+\t\u0005-\u0013\u0011Z\u0016\u0003\u0003\u0017\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001b%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0006='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAApU\u0011\ti+!3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u000f\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\t1\fgn\u001a\u0006\u0003\u0003_\fAA[1wC&!\u0011QOAu\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!?\u0002\u0000B\u0019q)a?\n\u0007\u0005u\bJA\u0002B]fD\u0001\"!\"#\u0003\u0003\u0005\r\u0001W\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0001\t\u0007\u0005\u000f\u0011i!!?\u000e\u0005\t%!b\u0001B\u0006\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=!\u0011\u0002\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0016\tm\u0001cA$\u0003\u0018%\u0019!\u0011\u0004%\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0011\u0013\u0002\u0002\u0003\u0007\u0011\u0011`\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002f\n\u0005\u0002\u0002CACK\u0005\u0005\t\u0019\u0001-\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001W\u0001\ti>\u001cFO]5oOR\u0011\u0011Q]\u0001\u0007KF,\u0018\r\\:\u0015\t\tU!q\u0006\u0005\n\u0003\u000bC\u0013\u0011!a\u0001\u0003s\fQa\u0015;bi\u0016\u00042!!.+'\u0015Q#q\u0007B\"!)\u0011IDa\u0010\u0002L\u00055\u00161W\u0007\u0003\u0005wQ1A!\u0010I\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0011\u0003<\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t\u0015#1J\u0007\u0003\u0005\u000fRAA!\u0013\u0002n\u0006\u0011\u0011n\\\u0005\u0005\u0003C\u00139\u0005\u0006\u0002\u00034\u0005)\u0011\r\u001d9msR1\u00111\u0017B*\u0005+Bq!!*.\u0001\u0004\tY\u0005C\u0004\u0002*6\u0002\r!!,\u0002\u000fUt\u0017\r\u001d9msR!!1\fB2!\u00119UN!\u0018\u0011\u000f\u001d\u0013y&a\u0013\u0002.&\u0019!\u0011\r%\u0003\rQ+\b\u000f\\33\u0011%\u0011)GLA\u0001\u0002\u0004\t\u0019,A\u0002yIA\nQa\u001d;bi\u0016,\"Aa\u001b\u0011\r\t5$\u0011PAZ\u001b\t\u0011yG\u0003\u0003\u0003r\tM\u0014AB1u_6L7MC\u0002d\u0005kRAAa\u001e\u0002n\u0006!Q\u000f^5m\u0013\u0011\u0011YHa\u001c\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\faa\u001d;bi\u0016\u0004\u0013aC5t\u0003Z\f\u0017\u000e\\1cY\u0016,\"A!\u0006\u0015\t\tU!Q\u0011\u0005\b\u0003S\u0013\u0004\u0019AA,\u00031I7/T8oSR|'/\u001b8h\u0003%AW-\u0019:uE\u0016\fG\u000f\u0006\u0002\u0002~!\u001aAGa$\u0011\t\tE%1S\u0007\u0003\u0003'LAA!&\u0002T\n9A/Y5me\u0016\u001c\u0017a\u00019iSR\u0019!Ka'\t\u000f\u0005%f\u00071\u0001\u0002XQ9!Ka(\u0003$\n\u001d\u0006b\u0002BQo\u0001\u0007\u0011qK\u0001\ti&lW\rR5gM\"1!QU\u001cA\u0002I\u000bA!\\3b]\"1!\u0011V\u001cA\u0002I\u000bAb\u001d;e\t\u00164\u0018.\u0019;j_:\fQ#\\5o'R$G)\u001a<jCRLwN\\'jY2L7/\u0001\fnS:\u001cF\u000f\u001a#fm&\fG/[8o\u001b&dG.[:!\u0003])gn];sKZ\u000bG.\u001b3Ti\u0012$UM^5bi&|g\u000eF\u0002S\u0005gCaA!+;\u0001\u0004\u0011\u0006")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final double minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish(Logging$Warning$.MODULE$.apply(this.toString(), this.getClass(), new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString(), Logging$.MODULE$.emptyMDC(), RemoteLogMarker$.MODULE$.failureDetectorGrowing(this.address())));
                    }
                    heartbeatHistory = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory = oldState.history();
                }
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            return 0.0;
        }
        long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
        HeartbeatHistory history = oldState.history();
        double mean = history.mean();
        double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
        return this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        if ((double)timeDiff > mean) {
            return -package$.MODULE$.log10(e / (1.0 + e));
        }
        return -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private double minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0 & Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0 & Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    private class State
    implements Product,
    Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.history();
                }
                case 1: {
                    return this.timestamp();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "history";
                }
                case 1: {
                    return "timestamp";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() != this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ PhiAccrualFailureDetector org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

