/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u2Q\u0001C\u0005\u0001\u0017MA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\t?\u0001\u0011\t\u0011)A\u00059!)\u0001\u0005\u0001C\u0001C!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u001a\u0001A\u0003%\u0001\u0006C\u00035\u0001\u0011\u0005Q\u0007C\u00037\u0001\u0011\u0005qG\u0001\nF]Z,Gn\u001c9f\u0005V4g-\u001a:Q_>d'B\u0001\u0006\f\u0003\u0019\t'\u000f^3ss*\u0011A\"D\u0001\u0007e\u0016lw\u000e^3\u000b\u00059y\u0011!\u00029fW.|'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u00039i\u0017\r_5nk6\u0004\u0016-\u001f7pC\u0012\u001c\u0001\u0001\u0005\u0002\u0016;%\u0011aD\u0006\u0002\u0004\u0013:$\u0018AD7bq&lW/\u001c\"vM\u001a,'o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\"S\u0005\u0005\u0002$\u00015\t\u0011\u0002C\u0003\u001b\u0007\u0001\u0007A\u0004C\u0003 \u0007\u0001\u0007A$\u0001\tbm\u0006LG.\u00192mK\n+hMZ3sgV\t\u0001\u0006E\u0002*]Aj\u0011A\u000b\u0006\u0003W1\n!bY8oGV\u0014(/\u001a8u\u0015\ti\u0013#\u0001\u0004bOJ|g.Y\u0005\u0003_)\u0012a$T1osR{W*\u00198z\u0007>t7-\u001e:sK:$\u0018I\u001d:bsF+X-^3\u0011\u0005\r\n\u0014B\u0001\u001a\n\u00059)eN^3m_B,')\u001e4gKJ\f\u0011#\u0019<bS2\f'\r\\3Ck\u001a4WM]:!\u0003\u001d\t7-];je\u0016$\u0012\u0001M\u0001\be\u0016dW-Y:f)\tA4\b\u0005\u0002\u0016s%\u0011!H\u0006\u0002\u0005+:LG\u000fC\u0003=\u000f\u0001\u0007\u0001'\u0001\u0004ck\u001a4WM\u001d")
public class EnvelopeBufferPool {
    private final int maximumPayload;
    private final ManyToManyConcurrentArrayQueue<EnvelopeBuffer> availableBuffers;

    private ManyToManyConcurrentArrayQueue<EnvelopeBuffer> availableBuffers() {
        return this.availableBuffers;
    }

    public EnvelopeBuffer acquire() {
        EnvelopeBuffer buf = this.availableBuffers().poll();
        if (buf != null) {
            buf.byteBuffer().clear();
            return buf;
        }
        EnvelopeBuffer newBuf = new EnvelopeBuffer(ByteBuffer.allocateDirect(this.maximumPayload));
        newBuf.byteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        return newBuf;
    }

    public void release(EnvelopeBuffer buffer) {
        if (buffer.byteBuffer().isDirect() && !this.availableBuffers().offer(buffer)) {
            buffer.tryCleanDirectByteBuffer();
            return;
        }
    }

    public EnvelopeBufferPool(int maximumPayload, int maximumBuffers) {
        this.maximumPayload = maximumPayload;
        this.availableBuffers = new ManyToManyConcurrentArrayQueue(maximumBuffers);
    }
}

