/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayDeque;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.ArteryMessage;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.OutboundHandshake;
import org.apache.pekko.remote.artery.Reply;
import org.apache.pekko.remote.artery.SystemMessageDelivery$;
import org.apache.pekko.remote.artery.SystemMessageDelivery$ResendTick$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.PrettyDuration$PrettyPrintableDuration$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;

@ScalaSignature(bytes="\u0006\u0005\rexACA\u0004\u0003\u0013A\t!!\u0004\u0002\u001e\u0019Q\u0011\u0011EA\u0005\u0011\u0003\ti!a\t\t\u000f\u0005E\u0012\u0001\"\u0001\u00026\u00191\u0011qG\u0001C\u0003sA!\"a\u0018\u0004\u0005+\u0007I\u0011AA1\u0011)\t\u0019g\u0001B\tB\u0003%\u0011Q\u0005\u0005\u000b\u0003K\u001a!Q3A\u0005\u0002\u0005\u001d\u0004BCA8\u0007\tE\t\u0015!\u0003\u0002j!Q\u0011\u0011O\u0002\u0003\u0016\u0004%\t!a\u001d\t\u0015\u0005u4A!E!\u0002\u0013\t)\bC\u0004\u00022\r!\t!a \t\u0013\u0005-5!!A\u0005\u0002\u00055\u0005\"CAK\u0007E\u0005I\u0011AAL\u0011%\tikAI\u0001\n\u0003\ty\u000bC\u0005\u00024\u000e\t\n\u0011\"\u0001\u00026\"I\u0011\u0011X\u0002\u0002\u0002\u0013\u0005\u00131\u0018\u0005\n\u0003\u001b\u001c\u0011\u0011!C\u0001\u0003\u001fD\u0011\"a6\u0004\u0003\u0003%\t!!7\t\u0013\u0005\u00158!!A\u0005B\u0005\u001d\b\"CA{\u0007\u0005\u0005I\u0011AA|\u0011%\u0011\taAA\u0001\n\u0003\u0012\u0019\u0001C\u0005\u0003\b\r\t\t\u0011\"\u0011\u0003\n!I!1B\u0002\u0002\u0002\u0013\u0005#Q\u0002\u0005\n\u0005\u001f\u0019\u0011\u0011!C!\u0005#9\u0011B!\u0006\u0002\u0003\u0003E\tAa\u0006\u0007\u0013\u0005]\u0012!!A\t\u0002\te\u0001bBA\u00193\u0011\u0005!\u0011\u0007\u0005\n\u0005\u0017I\u0012\u0011!C#\u0005\u001bA\u0011Ba\r\u001a\u0003\u0003%\tI!\u000e\t\u0013\tu\u0012$!A\u0005\u0002\n}\u0002\"\u0003B)3\u0005\u0005I\u0011\u0002B*\r\u0019\u0011Y&\u0001\"\u0003^!Q\u0011QM\u0010\u0003\u0016\u0004%\t!a\u001a\t\u0015\u0005=tD!E!\u0002\u0013\tI\u0007\u0003\u0006\u0003f}\u0011)\u001a!C\u0001\u0003gB!Ba\u001a \u0005#\u0005\u000b\u0011BA;\u0011\u001d\t\td\bC\u0001\u0005SB\u0011\"a# \u0003\u0003%\tA!\u001d\t\u0013\u0005Uu$%A\u0005\u0002\u0005=\u0006\"CAW?E\u0005I\u0011AA[\u0011%\tIlHA\u0001\n\u0003\nY\fC\u0005\u0002N~\t\t\u0011\"\u0001\u0002P\"I\u0011q[\u0010\u0002\u0002\u0013\u0005!q\u000f\u0005\n\u0003K|\u0012\u0011!C!\u0003OD\u0011\"!> \u0003\u0003%\tAa\u001f\t\u0013\t\u0005q$!A\u0005B\t}\u0004\"\u0003B\u0004?\u0005\u0005I\u0011\tB\u0005\u0011%\u0011YaHA\u0001\n\u0003\u0012i\u0001C\u0005\u0003\u0010}\t\t\u0011\"\u0011\u0003\u0004\u001eI!qQ\u0001\u0002\u0002#\u0005!\u0011\u0012\u0004\n\u00057\n\u0011\u0011!E\u0001\u0005\u0017Cq!!\r3\t\u0003\u0011\u0019\nC\u0005\u0003\fI\n\t\u0011\"\u0012\u0003\u000e!I!1\u0007\u001a\u0002\u0002\u0013\u0005%Q\u0013\u0005\n\u0005{\u0011\u0014\u0011!CA\u00057C\u0011B!\u00153\u0003\u0003%IAa\u0015\u0007\r\t\u001d\u0016A\u0011BU\u0011)\t)\u0007\u000fBK\u0002\u0013\u0005\u0011q\r\u0005\u000b\u0003_B$\u0011#Q\u0001\n\u0005%\u0004B\u0003B3q\tU\r\u0011\"\u0001\u0002t!Q!q\r\u001d\u0003\u0012\u0003\u0006I!!\u001e\t\u000f\u0005E\u0002\b\"\u0001\u0003,\"I\u00111\u0012\u001d\u0002\u0002\u0013\u0005!1\u0017\u0005\n\u0003+C\u0014\u0013!C\u0001\u0003_C\u0011\"!,9#\u0003%\t!!.\t\u0013\u0005e\u0006(!A\u0005B\u0005m\u0006\"CAgq\u0005\u0005I\u0011AAh\u0011%\t9\u000eOA\u0001\n\u0003\u0011I\fC\u0005\u0002fb\n\t\u0011\"\u0011\u0002h\"I\u0011Q\u001f\u001d\u0002\u0002\u0013\u0005!Q\u0018\u0005\n\u0005\u0003A\u0014\u0011!C!\u0005\u0003D\u0011Ba\u00029\u0003\u0003%\tE!\u0003\t\u0013\t-\u0001(!A\u0005B\t5\u0001\"\u0003B\bq\u0005\u0005I\u0011\tBc\u000f%\u0011I-AA\u0001\u0012\u0003\u0011YMB\u0005\u0003(\u0006\t\t\u0011#\u0001\u0003N\"9\u0011\u0011G&\u0005\u0002\tE\u0007\"\u0003B\u0006\u0017\u0006\u0005IQ\tB\u0007\u0011%\u0011\u0019dSA\u0001\n\u0003\u0013\u0019\u000eC\u0005\u0003>-\u000b\t\u0011\"!\u0003Z\"I!\u0011K&\u0002\u0002\u0013%!1\u000b\u0004\u0007\u0005;\f!Ia8\t\u0015\t\u0005\u0018K!f\u0001\n\u0003\ty\r\u0003\u0006\u0003dF\u0013\t\u0012)A\u0005\u0003#Dq!!\rR\t\u0003\u0011)\u000fC\u0005\u0002\fF\u000b\t\u0011\"\u0001\u0003l\"I\u0011QS)\u0012\u0002\u0013\u0005!q\u001e\u0005\n\u0003s\u000b\u0016\u0011!C!\u0003wC\u0011\"!4R\u0003\u0003%\t!a4\t\u0013\u0005]\u0017+!A\u0005\u0002\tM\b\"CAs#\u0006\u0005I\u0011IAt\u0011%\t)0UA\u0001\n\u0003\u00119\u0010C\u0005\u0003\u0002E\u000b\t\u0011\"\u0011\u0003|\"I!qA)\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005\u0017\t\u0016\u0011!C!\u0005\u001bA\u0011Ba\u0004R\u0003\u0003%\tEa@\b\u0013\r\r\u0011!!A\t\u0002\r\u0015a!\u0003Bo\u0003\u0005\u0005\t\u0012AB\u0004\u0011\u001d\t\t$\u0019C\u0001\u0007\u001fA\u0011Ba\u0003b\u0003\u0003%)E!\u0004\t\u0013\tM\u0012-!A\u0005\u0002\u000eE\u0001\"\u0003B\u001fC\u0006\u0005I\u0011QB\u000b\u0011%\u0011\t&YA\u0001\n\u0013\u0011\u0019F\u0002\u0004\u0004\u001c\u0005\u00111Q\u0004\u0005\u000b\u0007k9'\u0011!Q\u0001\n\r]\u0002bBA\u0019O\u0012\u00051QI\u0004\b\u0007\u0017\n\u0001\u0012RB'\r\u001d\u0019y%\u0001EE\u0007#Bq!!\rl\t\u0003\u0019\u0019\u0006C\u0005\u0002:.\f\t\u0011\"\u0011\u0002<\"I\u0011QZ6\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003/\\\u0017\u0011!C\u0001\u0007+B\u0011\"!:l\u0003\u0003%\t%a:\t\u0013\u0005U8.!A\u0005\u0002\re\u0003\"\u0003B\u0004W\u0006\u0005I\u0011\tB\u0005\u0011%\u0011Ya[A\u0001\n\u0003\u0012i\u0001C\u0005\u0003R-\f\t\u0011\"\u0003\u0003T\u0019I1QL\u0001\u0011\u0002G\u00051q\f\u0004\n\u0003C\tI\u0001AA\u0007\u0007_B!ba$w\u0005\u0003\u0005\u000b\u0011BBI\u0011)\u00199J\u001eB\u0001B\u0003%1\u0011\u0014\u0005\u000b\u0007K3(\u0011!Q\u0001\n\r\u001d\u0006BCB\\m\n\u0005\t\u0015!\u0003\u0002R\"9\u0011\u0011\u0007<\u0005\u0002\re\u0006\"CBcm\n\u0007I\u0011ABd\u0011!\u0019yM\u001eQ\u0001\n\r%\u0007\"CBim\n\u0007I\u0011ABj\u0011!\u0019YN\u001eQ\u0001\n\rU\u0007\"CBom\n\u0007I\u0011IBp\u0011!\u0019\tO\u001eQ\u0001\n\r\u0005\u0005bBBrm\u0012\u00053Q]\u0001\u0016'f\u001cH/Z7NKN\u001c\u0018mZ3EK2Lg/\u001a:z\u0015\u0011\tY!!\u0004\u0002\r\u0005\u0014H/\u001a:z\u0015\u0011\ty!!\u0005\u0002\rI,Wn\u001c;f\u0015\u0011\t\u0019\"!\u0006\u0002\u000bA,7n[8\u000b\t\u0005]\u0011\u0011D\u0001\u0007CB\f7\r[3\u000b\u0005\u0005m\u0011aA8sOB\u0019\u0011qD\u0001\u000e\u0005\u0005%!!F*zgR,W.T3tg\u0006<W\rR3mSZ,'/_\n\u0004\u0003\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0005\u0005-\u0012!B:dC2\f\u0017\u0002BA\u0018\u0003S\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0005\u0005u!!F*zgR,W.T3tg\u0006<W-\u00128wK2|\u0007/Z\n\n\u0007\u0005\u0015\u00121HA!\u0003\u000f\u0002B!a\b\u0002>%!\u0011qHA\u0005\u00055\t%\u000f^3ss6+7o]1hKB!\u0011qEA\"\u0013\u0011\t)%!\u000b\u0003\u000fA\u0013x\u000eZ;diB!\u0011\u0011JA-\u001d\u0011\tY%!\u0016\u000f\t\u00055\u00131K\u0007\u0003\u0003\u001fRA!!\u0015\u00024\u00051AH]8pizJ!!a\u000b\n\t\u0005]\u0013\u0011F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY&!\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\t\u0005]\u0013\u0011F\u0001\b[\u0016\u001c8/Y4f+\t\t)#\u0001\u0005nKN\u001c\u0018mZ3!\u0003\u0015\u0019X-\u001d(p+\t\tI\u0007\u0005\u0003\u0002(\u0005-\u0014\u0002BA7\u0003S\u0011A\u0001T8oO\u000611/Z9O_\u0002\n!\"Y2l%\u0016\u0004H.\u001f+p+\t\t)\b\u0005\u0003\u0002x\u0005eTBAA\u0007\u0013\u0011\tY(!\u0004\u0003\u001bUs\u0017.];f\u0003\u0012$'/Z:t\u0003-\t7m\u001b*fa2LHk\u001c\u0011\u0015\u0011\u0005\u0005\u0015QQAD\u0003\u0013\u00032!a!\u0004\u001b\u0005\t\u0001bBA0\u0015\u0001\u0007\u0011Q\u0005\u0005\b\u0003KR\u0001\u0019AA5\u0011\u001d\t\tH\u0003a\u0001\u0003k\nAaY8qsRA\u0011\u0011QAH\u0003#\u000b\u0019\nC\u0005\u0002`-\u0001\n\u00111\u0001\u0002&!I\u0011QM\u0006\u0011\u0002\u0003\u0007\u0011\u0011\u000e\u0005\n\u0003cZ\u0001\u0013!a\u0001\u0003k\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a*\"\u0011QEANW\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013Ut7\r[3dW\u0016$'\u0002BAT\u0003S\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY+!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E&\u0006BA5\u00037\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00028*\"\u0011QOAN\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0017\u0001\u00026bm\u0006LA!a3\u0002B\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!5\u0011\t\u0005\u001d\u00121[\u0005\u0005\u0003+\fICA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\\\u0006\u0005\b\u0003BA\u0014\u0003;LA!a8\u0002*\t\u0019\u0011I\\=\t\u0013\u0005\r\u0018#!AA\u0002\u0005E\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002jB1\u00111^Ay\u00037l!!!<\u000b\t\u0005=\u0018\u0011F\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAz\u0003[\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011`A\u0000!\u0011\t9#a?\n\t\u0005u\u0018\u0011\u0006\u0002\b\u0005>|G.Z1o\u0011%\t\u0019oEA\u0001\u0002\u0004\tY.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA_\u0005\u000bA\u0011\"a9\u0015\u0003\u0003\u0005\r!!5\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!0\u0002\r\u0015\fX/\u00197t)\u0011\tIPa\u0005\t\u0013\u0005\rx#!AA\u0002\u0005m\u0017!F*zgR,W.T3tg\u0006<W-\u00128wK2|\u0007/\u001a\t\u0004\u0003\u0007K2#B\r\u0003\u001c\t\u001d\u0002\u0003\u0004B\u000f\u0005G\t)#!\u001b\u0002v\u0005\u0005UB\u0001B\u0010\u0015\u0011\u0011\t#!\u000b\u0002\u000fI,h\u000e^5nK&!!Q\u0005B\u0010\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)!!QFAc\u0003\tIw.\u0003\u0003\u0002\\\t-BC\u0001B\f\u0003\u0015\t\u0007\u000f\u001d7z)!\t\tIa\u000e\u0003:\tm\u0002bBA09\u0001\u0007\u0011Q\u0005\u0005\b\u0003Kb\u0002\u0019AA5\u0011\u001d\t\t\b\ba\u0001\u0003k\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003B\t5\u0003CBA\u0014\u0005\u0007\u00129%\u0003\u0003\u0003F\u0005%\"AB(qi&|g\u000e\u0005\u0006\u0002(\t%\u0013QEA5\u0003kJAAa\u0013\u0002*\t1A+\u001e9mKNB\u0011Ba\u0014\u001e\u0003\u0003\u0005\r!!!\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003VA!\u0011q\u0018B,\u0013\u0011\u0011I&!1\u0003\r=\u0013'.Z2u\u0005\r\t5m[\n\n?\u0005\u0015\"qLA!\u0003\u000f\u0002B!a\b\u0003b%!!1MA\u0005\u0005\u0015\u0011V\r\u001d7z\u0003\u00111'o\\7\u0002\u000b\u0019\u0014x.\u001c\u0011\u0015\r\t-$Q\u000eB8!\r\t\u0019i\b\u0005\b\u0003K\"\u0003\u0019AA5\u0011\u001d\u0011)\u0007\na\u0001\u0003k\"bAa\u001b\u0003t\tU\u0004\"CA3KA\u0005\t\u0019AA5\u0011%\u0011)'\nI\u0001\u0002\u0004\t)\b\u0006\u0003\u0002\\\ne\u0004\"CArU\u0005\u0005\t\u0019AAi)\u0011\tIP! \t\u0013\u0005\rH&!AA\u0002\u0005mG\u0003BA_\u0005\u0003C\u0011\"a9.\u0003\u0003\u0005\r!!5\u0015\t\u0005e(Q\u0011\u0005\n\u0003G\u0004\u0014\u0011!a\u0001\u00037\f1!Q2l!\r\t\u0019IM\n\u0006e\t5%q\u0005\t\u000b\u0005;\u0011y)!\u001b\u0002v\t-\u0014\u0002\u0002BI\u0005?\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011I\t\u0006\u0004\u0003l\t]%\u0011\u0014\u0005\b\u0003K*\u0004\u0019AA5\u0011\u001d\u0011)'\u000ea\u0001\u0003k\"BA!(\u0003&B1\u0011q\u0005B\"\u0005?\u0003\u0002\"a\n\u0003\"\u0006%\u0014QO\u0005\u0005\u0005G\u000bIC\u0001\u0004UkBdWM\r\u0005\n\u0005\u001f2\u0014\u0011!a\u0001\u0005W\u0012AAT1dWNI\u0001(!\n\u0003`\u0005\u0005\u0013q\t\u000b\u0007\u0005[\u0013yK!-\u0011\u0007\u0005\r\u0005\bC\u0004\u0002fu\u0002\r!!\u001b\t\u000f\t\u0015T\b1\u0001\u0002vQ1!Q\u0016B[\u0005oC\u0011\"!\u001a?!\u0003\u0005\r!!\u001b\t\u0013\t\u0015d\b%AA\u0002\u0005UD\u0003BAn\u0005wC\u0011\"a9D\u0003\u0003\u0005\r!!5\u0015\t\u0005e(q\u0018\u0005\n\u0003G,\u0015\u0011!a\u0001\u00037$B!!0\u0003D\"I\u00111\u001d$\u0002\u0002\u0003\u0007\u0011\u0011\u001b\u000b\u0005\u0003s\u00149\rC\u0005\u0002d&\u000b\t\u00111\u0001\u0002\\\u0006!a*Y2l!\r\t\u0019iS\n\u0006\u0017\n='q\u0005\t\u000b\u0005;\u0011y)!\u001b\u0002v\t5FC\u0001Bf)\u0019\u0011iK!6\u0003X\"9\u0011Q\r(A\u0002\u0005%\u0004b\u0002B3\u001d\u0002\u0007\u0011Q\u000f\u000b\u0005\u0005;\u0013Y\u000eC\u0005\u0003P=\u000b\t\u00111\u0001\u0003.\nQ2\t\\3beNK8\u000f^3n\u001b\u0016\u001c8/Y4f\t\u0016d\u0017N^3ssN9\u0011+!\n\u0002B\u0005\u001d\u0013aC5oG\u0006\u0014h.\u0019;j_:\fA\"\u001b8dCJt\u0017\r^5p]\u0002\"BAa:\u0003jB\u0019\u00111Q)\t\u000f\t\u0005H\u000b1\u0001\u0002RR!!q\u001dBw\u0011%\u0011\t/\u0016I\u0001\u0002\u0004\t\t.\u0006\u0002\u0003r*\"\u0011\u0011[AN)\u0011\tYN!>\t\u0013\u0005\r\u0018,!AA\u0002\u0005EG\u0003BA}\u0005sD\u0011\"a9\\\u0003\u0003\u0005\r!a7\u0015\t\u0005u&Q \u0005\n\u0003Gd\u0016\u0011!a\u0001\u0003#$B!!?\u0004\u0002!I\u00111]0\u0002\u0002\u0003\u0007\u00111\\\u0001\u001b\u00072,\u0017M]*zgR,W.T3tg\u0006<W\rR3mSZ,'/\u001f\t\u0004\u0003\u0007\u000b7#B1\u0004\n\t\u001d\u0002\u0003\u0003B\u000f\u0007\u0017\t\tNa:\n\t\r5!q\u0004\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAB\u0003)\u0011\u00119oa\u0005\t\u000f\t\u0005H\r1\u0001\u0002RR!1qCB\r!\u0019\t9Ca\u0011\u0002R\"I!qJ3\u0002\u0002\u0003\u0007!q\u001d\u0002\u001d\u000f\u00064X-\u00169TsN$X-\\'fgN\fw-Z#yG\u0016\u0004H/[8o'\u001597qDB\u0013!\u0011\tIe!\t\n\t\r\r\u0012Q\f\u0002\u0011%VtG/[7f\u000bb\u001cW\r\u001d;j_:\u0004Baa\n\u000425\u00111\u0011\u0006\u0006\u0005\u0007W\u0019i#A\u0004d_:$(o\u001c7\u000b\t\r=\u0012\u0011F\u0001\u0005kRLG.\u0003\u0003\u00044\r%\"\u0001\u0004(p'R\f7m\u001b+sC\u000e,\u0017aA7tOB!1\u0011HB!\u001d\u0011\u0019Yd!\u0010\u0011\t\u00055\u0013\u0011F\u0005\u0005\u0007\u007f\tI#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\u001c\u0019E\u0003\u0003\u0004@\u0005%B\u0003BB$\u0007\u0013\u00022!a!h\u0011\u001d\u0019)$\u001ba\u0001\u0007o\t!BU3tK:$G+[2l!\r\t\u0019i\u001b\u0002\u000b%\u0016\u001cXM\u001c3US\u000e\\7cB6\u0002&\u0005\u0005\u0013q\t\u000b\u0003\u0007\u001b\"B!a7\u0004X!I\u00111]8\u0002\u0002\u0003\u0007\u0011\u0011\u001b\u000b\u0005\u0003s\u001cY\u0006C\u0005\u0002dF\f\t\u00111\u0001\u0002\\\n!\u0012iY6fI\u0012+G.\u001b<feflUm]:bO\u0016\u001c2!^A\u0013Q\r\t11\r\t\u0005\u0007K\u001aI'\u0004\u0002\u0004h)!\u0011qUA\t\u0013\u0011\u0019Yga\u001a\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0004\u0001\r\r4c\u0001<\u0004rA111OB?\u0007\u0003k!a!\u001e\u000b\t\r]4\u0011P\u0001\u0006gR\fw-\u001a\u0006\u0005\u0007w\n\t\"\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0007\u007f\u001a)H\u0001\u0006He\u0006\u0004\bn\u0015;bO\u0016\u0004\u0002ba!\u0004\u0006\u000e%5\u0011R\u0007\u0003\u0007sJAaa\"\u0004z\tIa\t\\8x'\"\f\u0007/\u001a\t\u0005\u0003?\u0019Y)\u0003\u0003\u0004\u000e\u0006%!\u0001E(vi\n|WO\u001c3F]Z,Gn\u001c9f\u0003=yW\u000f\u001e2pk:$7i\u001c8uKb$\b\u0003BA\u0010\u0007'KAa!&\u0002\n\tyq*\u001e;c_VtGmQ8oi\u0016DH/A\u0006eK\u0006$G*\u001a;uKJ\u001c\b\u0003BBN\u0007Ck!a!(\u000b\t\r}\u0015\u0011C\u0001\u0006C\u000e$xN]\u0005\u0005\u0007G\u001biJ\u0001\u0005BGR|'OU3g\u00039\u0011Xm]3oI&sG/\u001a:wC2\u0004Ba!+\u000446\u001111\u0016\u0006\u0005\u0007[\u001by+\u0001\u0005ekJ\fG/[8o\u0015\u0011\u0019\t,!\u000b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00046\u000e-&A\u0004$j]&$X\rR;sCRLwN\\\u0001\u000e[\u0006D()\u001e4gKJ\u001c\u0016N_3\u0015\u0015\rm6QXB`\u0007\u0003\u001c\u0019\rE\u0002\u0002 YDqaa$|\u0001\u0004\u0019\t\nC\u0004\u0004\u0018n\u0004\ra!'\t\u000f\r\u00156\u00101\u0001\u0004(\"91qW>A\u0002\u0005E\u0017AA5o+\t\u0019I\r\u0005\u0004\u0004\u0004\u000e-7\u0011R\u0005\u0005\u0007\u001b\u001cIHA\u0003J]2,G/A\u0002j]\u0002\n1a\\;u+\t\u0019)\u000e\u0005\u0004\u0004\u0004\u000e]7\u0011R\u0005\u0005\u00073\u001cIH\u0001\u0004PkRdW\r^\u0001\u0005_V$\b%A\u0003tQ\u0006\u0004X-\u0006\u0002\u0004\u0002\u000611\u000f[1qK\u0002\n1b\u0019:fCR,Gj\\4jGR!1q]Bw!\u0011\u0019\u0019h!;\n\t\r-8Q\u000f\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jG\"A1q^A\u0003\u0001\u0004\u0019\t0A\nj]\",'/\u001b;fI\u0006#HO]5ckR,7\u000f\u0005\u0003\u0004\u0004\u000eM\u0018\u0002BB{\u0007s\u0012!\"\u0011;ue&\u0014W\u000f^3tQ\r181\r")
@InternalApi
public class SystemMessageDelivery
extends GraphStage<FlowShape<OutboundEnvelope, OutboundEnvelope>> {
    public final OutboundContext org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext;
    public final ActorRef org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters;
    public final FiniteDuration org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval;
    public final int org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize;
    private final Inlet<OutboundEnvelope> in;
    private final Outlet<OutboundEnvelope> out;
    private final FlowShape<OutboundEnvelope, OutboundEnvelope> shape;

    public Inlet<OutboundEnvelope> in() {
        return this.in;
    }

    public Outlet<OutboundEnvelope> out() {
        return this.out;
    }

    @Override
    public FlowShape<OutboundEnvelope, OutboundEnvelope> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private boolean replyObserverAttached;
            private long seqNo;
            private int incarnation;
            private final ArrayDeque<OutboundEnvelope> unacknowledged;
            private ArrayDeque<OutboundEnvelope> resending;
            private boolean stopping;
            private final long giveUpAfterNanos;
            private long ackTimestamp;
            private final AsyncCallback<Ack> ackCallback;
            private final AsyncCallback<Nack> nackCallback;
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final /* synthetic */ SystemMessageDelivery $outer;

            public LoggingAdapter log() {
                return StageLogging.log$(this);
            }

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$(this, cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            private boolean replyObserverAttached() {
                return this.replyObserverAttached;
            }

            private void replyObserverAttached_$eq(boolean x$1) {
                this.replyObserverAttached = x$1;
            }

            private long seqNo() {
                return this.seqNo;
            }

            private void seqNo_$eq(long x$1) {
                this.seqNo = x$1;
            }

            private int incarnation() {
                return this.incarnation;
            }

            private void incarnation_$eq(int x$1) {
                this.incarnation = x$1;
            }

            private ArrayDeque<OutboundEnvelope> unacknowledged() {
                return this.unacknowledged;
            }

            private ArrayDeque<OutboundEnvelope> resending() {
                return this.resending;
            }

            private void resending_$eq(ArrayDeque<OutboundEnvelope> x$1) {
                this.resending = x$1;
            }

            private boolean stopping() {
                return this.stopping;
            }

            private void stopping_$eq(boolean x$1) {
                this.stopping = x$1;
            }

            private long giveUpAfterNanos() {
                return this.giveUpAfterNanos;
            }

            private long ackTimestamp() {
                return this.ackTimestamp;
            }

            private void ackTimestamp_$eq(long x$1) {
                this.ackTimestamp = x$1;
            }

            private UniqueAddress localAddress() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.localAddress();
            }

            private Address remoteAddress() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.remoteAddress();
            }

            private String remoteAddressLogParam() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().uniqueRemoteAddress().getOrElse((Function0 & Serializable)() -> this.remoteAddress()).toString();
            }

            public Class<?> logSource() {
                return SystemMessageDelivery.class;
            }

            public void preStart() {
                AsyncCallback<T> callback = this.getAsyncCallback((Function1 & Serializable)x$1 -> {
                    $anon$1.$anonfun$preStart$1(this, x$1);
                    return BoxedUnit.UNIT;
                });
                this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.controlSubject().attach(this).foreach((Function1 & Serializable)t -> {
                    $anon$1.$anonfun$preStart$2(callback, t);
                    return BoxedUnit.UNIT;
                }, ExecutionContexts$.MODULE$.parasitic());
            }

            public void postStop() {
                int pendingCount = this.unacknowledged().size();
                this.sendUnacknowledgedToDeadLetters();
                this.unacknowledged().clear();
                if (pendingCount > 0) {
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.quarantine(new StringBuilder(62).append("SystemMessageDelivery stopped with [").append(pendingCount).append("] pending system messages.").toString());
                }
                this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.controlSubject().detach(this);
            }

            public void onUpstreamFinish() {
                if (this.unacknowledged().isEmpty()) {
                    InHandler.onUpstreamFinish$(this);
                    return;
                }
                this.stopping_$eq(true);
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                if (SystemMessageDelivery$ResendTick$.MODULE$.equals(object)) {
                    this.checkGiveUp();
                    if (this.resending().isEmpty() && !this.unacknowledged().isEmpty()) {
                        this.resending_$eq((ArrayDeque<OutboundEnvelope>)this.unacknowledged().clone());
                        this.tryResend();
                    }
                    if (!this.unacknowledged().isEmpty()) {
                        this.scheduleOnce((Object)SystemMessageDelivery$ResendTick$.MODULE$, this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
                        return;
                    }
                    return;
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unknown timer key: ").append(object).toString());
            }

            public void notify(InboundEnvelope inboundEnvelope) {
                Object object = inboundEnvelope.message();
                if (object instanceof Ack) {
                    Ack ack = (Ack)object;
                    Address address = ack.from().address();
                    Address address2 = this.remoteAddress();
                    if (!(address != null ? !((Object)address).equals(address2) : address2 != null)) {
                        this.ackCallback().invoke(ack);
                        return;
                    }
                    return;
                }
                if (object instanceof Nack) {
                    Nack nack = (Nack)object;
                    Address address = nack.from().address();
                    Address address3 = this.remoteAddress();
                    if (!(address != null ? !((Object)address).equals(address3) : address3 != null)) {
                        this.nackCallback().invoke(nack);
                        return;
                    }
                    return;
                }
            }

            public void controlSubjectCompleted(Try<Done> signal) {
                this.getAsyncCallback((Function1 & Serializable)x0$1 -> {
                    $anon$1.$anonfun$controlSubjectCompleted$1(this, x0$1);
                    return BoxedUnit.UNIT;
                }).invoke(signal);
            }

            private AsyncCallback<Ack> ackCallback() {
                return this.ackCallback;
            }

            private AsyncCallback<Nack> nackCallback() {
                return this.nackCallback;
            }

            private void ack(long n) {
                this.ackTimestamp_$eq(System.nanoTime());
                if (n <= this.seqNo()) {
                    this.clearUnacknowledged(n);
                    return;
                }
            }

            private void clearUnacknowledged(long ackedSeqNo) {
                block2: {
                    BoxedUnit boxedUnit;
                    while (!this.unacknowledged().isEmpty() && ((SystemMessageEnvelope)this.unacknowledged().peek().message()).seqNo() <= ackedSeqNo) {
                        this.unacknowledged().removeFirst();
                        if (this.unacknowledged().isEmpty()) {
                            this.cancelTimer(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
                        }
                        if (!this.stopping() || !this.unacknowledged().isEmpty()) continue;
                        this.completeStage();
                        boxedUnit = BoxedUnit.UNIT;
                        break block2;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }

            private void tryResend() {
                if (this.isAvailable(this.$outer.out()) && !this.resending().isEmpty()) {
                    OutboundEnvelope env = this.resending().poll();
                    if (this.log().isDebugEnabled()) {
                        Object object = env.message();
                        if (object instanceof SystemMessageEnvelope) {
                            SystemMessageEnvelope systemMessageEnvelope = (SystemMessageEnvelope)object;
                            Object msg = systemMessageEnvelope.message();
                            long n = systemMessageEnvelope.seqNo();
                            this.log().debug("Resending system message [{}] [{}]", Logging$.MODULE$.simpleName(msg), BoxesRunTime.boxToLong((long)n));
                        } else {
                            this.log().debug("Resending control message [{}]", Logging$.MODULE$.simpleName(env.message()));
                        }
                    }
                    if (this.incarnation() != this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation()) {
                        this.log().debug("Noticed new incarnation of [{}] from tryResend, clear state", this.remoteAddressLogParam());
                        this.clear();
                    }
                    this.pushCopy(env);
                    return;
                }
            }

            private void pushCopy(OutboundEnvelope outboundEnvelope) {
                this.push(this.$outer.out(), outboundEnvelope.copy());
            }

            public void onPush() {
                OutboundEnvelope outboundEnvelope = this.grab(this.$outer.in());
                Object object = outboundEnvelope.message();
                if (object instanceof SystemMessage ? true : object instanceof AckedDeliveryMessage) {
                    if (this.unacknowledged().size() < this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize) {
                        if (this.seqNo() == 0L) {
                            this.incarnation_$eq(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation());
                        } else if (this.incarnation() != this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation()) {
                            this.log().debug("Noticed new incarnation of [{}] from onPush, clear state", this.remoteAddressLogParam());
                            this.clear();
                        }
                        this.seqNo_$eq(this.seqNo() + 1L);
                        if (this.unacknowledged().isEmpty()) {
                            this.ackTimestamp_$eq(System.nanoTime());
                        } else {
                            this.checkGiveUp();
                        }
                        OutboundEnvelope sendEnvelope = outboundEnvelope.withMessage(new SystemMessageEnvelope(object, this.seqNo(), this.localAddress()));
                        this.unacknowledged().offer(sendEnvelope);
                        this.scheduleOnce((Object)SystemMessageDelivery$ResendTick$.MODULE$, this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
                        if (this.resending().isEmpty() && this.isAvailable(this.$outer.out())) {
                            this.pushCopy(sendEnvelope);
                            return;
                        }
                        this.resending().offer(sendEnvelope);
                        this.tryResend();
                        return;
                    }
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.quarantine(new StringBuilder(48).append("System message delivery buffer overflow, size [").append(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize).append("]").toString());
                    OutboundEnvelope x$1 = outboundEnvelope;
                    ActorRef x$2 = this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang$default$2(x$1);
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang(x$1, x$2);
                    this.pull(this.$outer.in());
                    return;
                }
                if (object instanceof OutboundHandshake.HandshakeReq) {
                    if (this.isAvailable(this.$outer.out())) {
                        this.pushCopy(outboundEnvelope);
                        return;
                    }
                    return;
                }
                if (object instanceof ClearSystemMessageDelivery) {
                    ClearSystemMessageDelivery clearSystemMessageDelivery = (ClearSystemMessageDelivery)object;
                    int i = clearSystemMessageDelivery.incarnation();
                    if (i <= this.incarnation()) {
                        this.log().debug("Clear system message delivery of [{}]", this.remoteAddressLogParam());
                        this.clear();
                    }
                    this.pull(this.$outer.in());
                    return;
                }
                if (this.resending().isEmpty() && this.isAvailable(this.$outer.out())) {
                    this.push(this.$outer.out(), outboundEnvelope);
                    return;
                }
                this.resending().offer(outboundEnvelope);
                this.tryResend();
            }

            private void checkGiveUp() {
                if (!this.unacknowledged().isEmpty() && System.nanoTime() - this.ackTimestamp() > this.giveUpAfterNanos()) {
                    throw new GaveUpSystemMessageException(new StringBuilder(44).append("Gave up sending system message to [").append(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.remoteAddress()).append("] after ").append(PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.settings().Advanced().GiveUpSystemMessageAfter()))).append(".").toString());
                }
            }

            private void clear() {
                this.sendUnacknowledgedToDeadLetters();
                this.seqNo_$eq(0L);
                this.incarnation_$eq(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation());
                this.unacknowledged().clear();
                this.resending().clear();
                this.cancelTimer(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
            }

            private void sendUnacknowledgedToDeadLetters() {
                for (OutboundEnvelope x$1 : this.unacknowledged()) {
                    ActorRef x$2 = this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang$default$2(x$1);
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang(x$1, x$2);
                }
            }

            public void onPull() {
                if (this.replyObserverAttached()) {
                    if (this.resending().isEmpty() && !this.hasBeenPulled(this.$outer.in()) && !this.stopping()) {
                        this.pull(this.$outer.in());
                        return;
                    }
                    this.tryResend();
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$preStart$1($anon$1 $this, Done x$1) {
                $this.replyObserverAttached_$eq(true);
                if ($this.isAvailable($this.$outer.out())) {
                    $this.pull($this.$outer.in());
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$preStart$2(AsyncCallback callback$1, Done t) {
                callback$1.invoke(t);
            }

            public static final /* synthetic */ void $anonfun$controlSubjectCompleted$1($anon$1 $this, Try x0$1) {
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    $this.completeStage();
                    return;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable cause = failure.exception();
                    $this.failStage(cause);
                    return;
                }
                throw new MatchError((Object)try_);
            }

            public static final /* synthetic */ void $anonfun$ackCallback$1($anon$1 $this, Ack reply) {
                $this.ack(reply.seqNo());
            }

            public static final /* synthetic */ void $anonfun$nackCallback$1($anon$1 $this, Nack reply) {
                if (reply.seqNo() <= $this.seqNo()) {
                    $this.ack(reply.seqNo());
                    $this.log().warning("Received negative acknowledgement of system message from [{}], highest acknowledged [{}]", $this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.remoteAddress(), (Object)BoxesRunTime.boxToLong((long)reply.seqNo()));
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$(this);
                OutHandler.$init$(this);
                StageLogging.$init$(this);
                this.replyObserverAttached = false;
                this.seqNo = 0L;
                this.incarnation = $outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation();
                this.unacknowledged = new ArrayDeque<E>();
                this.resending = new ArrayDeque<E>();
                this.stopping = false;
                this.giveUpAfterNanos = $outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.settings().Advanced().GiveUpSystemMessageAfter().toNanos();
                this.ackTimestamp = System.nanoTime();
                this.ackCallback = this.getAsyncCallback((Function1 & Serializable)reply -> {
                    $anon$1.$anonfun$ackCallback$1(this, reply);
                    return BoxedUnit.UNIT;
                });
                this.nackCallback = this.getAsyncCallback((Function1 & Serializable)reply -> {
                    $anon$1.$anonfun$nackCallback$1(this, reply);
                    return BoxedUnit.UNIT;
                });
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$ackCallback$1$adapted(org.apache.pekko.remote.artery.SystemMessageDelivery$$anon$1 org.apache.pekko.remote.artery.SystemMessageDelivery$Ack ), $anonfun$controlSubjectCompleted$1$adapted(org.apache.pekko.remote.artery.SystemMessageDelivery$$anon$1 scala.util.Try ), $anonfun$nackCallback$1$adapted(org.apache.pekko.remote.artery.SystemMessageDelivery$$anon$1 org.apache.pekko.remote.artery.SystemMessageDelivery$Nack ), $anonfun$preStart$1$adapted(org.apache.pekko.remote.artery.SystemMessageDelivery$$anon$1 org.apache.pekko.Done ), $anonfun$preStart$2$adapted(org.apache.pekko.stream.stage.AsyncCallback org.apache.pekko.Done ), $anonfun$remoteAddressLogParam$1(org.apache.pekko.remote.artery.SystemMessageDelivery$$anon$1 )}, serializedLambda);
            }
        };
    }

    public SystemMessageDelivery(OutboundContext outboundContext, ActorRef deadLetters, FiniteDuration resendInterval, int maxBufferSize) {
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext = outboundContext;
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters = deadLetters;
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval = resendInterval;
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize = maxBufferSize;
        this.in = Inlet$.MODULE$.apply("SystemMessageDelivery.in");
        this.out = Outlet$.MODULE$.apply("SystemMessageDelivery.out");
        this.shape = new FlowShape<OutboundEnvelope, OutboundEnvelope>(this.in(), this.out());
    }

    public static final class Ack
    implements Reply,
    Product {
        private final long seqNo;
        private final UniqueAddress from;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long seqNo() {
            return this.seqNo;
        }

        public UniqueAddress from() {
            return this.from;
        }

        public Ack copy(long seqNo, UniqueAddress from) {
            return new Ack(seqNo, from);
        }

        public long copy$default$1() {
            return this.seqNo();
        }

        public UniqueAddress copy$default$2() {
            return this.from();
        }

        public String productPrefix() {
            return "Ack";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.seqNo());
                }
                case 1: {
                    return this.from();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Ack;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "seqNo";
                }
                case 1: {
                    return "from";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Ack)) return false;
            boolean bl = true;
            if (!bl) return false;
            Ack ack = (Ack)x$1;
            if (this.seqNo() != ack.seqNo()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = ack.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public Ack(long seqNo, UniqueAddress from) {
            this.seqNo = seqNo;
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static interface AckedDeliveryMessage {
    }

    public static final class ClearSystemMessageDelivery
    implements Product,
    Serializable {
        private final int incarnation;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int incarnation() {
            return this.incarnation;
        }

        public ClearSystemMessageDelivery copy(int incarnation) {
            return new ClearSystemMessageDelivery(incarnation);
        }

        public int copy$default$1() {
            return this.incarnation();
        }

        public String productPrefix() {
            return "ClearSystemMessageDelivery";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.incarnation());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClearSystemMessageDelivery;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "incarnation";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.incarnation());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClearSystemMessageDelivery)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClearSystemMessageDelivery clearSystemMessageDelivery = (ClearSystemMessageDelivery)x$1;
            if (this.incarnation() != clearSystemMessageDelivery.incarnation()) return false;
            return true;
        }

        public ClearSystemMessageDelivery(int incarnation) {
            this.incarnation = incarnation;
            Product.$init$((Product)this);
        }
    }

    public static final class GaveUpSystemMessageException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public GaveUpSystemMessageException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }

    public static final class Nack
    implements Reply,
    Product {
        private final long seqNo;
        private final UniqueAddress from;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long seqNo() {
            return this.seqNo;
        }

        public UniqueAddress from() {
            return this.from;
        }

        public Nack copy(long seqNo, UniqueAddress from) {
            return new Nack(seqNo, from);
        }

        public long copy$default$1() {
            return this.seqNo();
        }

        public UniqueAddress copy$default$2() {
            return this.from();
        }

        public String productPrefix() {
            return "Nack";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.seqNo());
                }
                case 1: {
                    return this.from();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Nack;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "seqNo";
                }
                case 1: {
                    return "from";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Nack)) return false;
            boolean bl = true;
            if (!bl) return false;
            Nack nack = (Nack)x$1;
            if (this.seqNo() != nack.seqNo()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = nack.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public Nack(long seqNo, UniqueAddress from) {
            this.seqNo = seqNo;
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class SystemMessageEnvelope
    implements ArteryMessage,
    Product {
        private final Object message;
        private final long seqNo;
        private final UniqueAddress ackReplyTo;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Object message() {
            return this.message;
        }

        public long seqNo() {
            return this.seqNo;
        }

        public UniqueAddress ackReplyTo() {
            return this.ackReplyTo;
        }

        public SystemMessageEnvelope copy(Object message, long seqNo, UniqueAddress ackReplyTo) {
            return new SystemMessageEnvelope(message, seqNo, ackReplyTo);
        }

        public Object copy$default$1() {
            return this.message();
        }

        public long copy$default$2() {
            return this.seqNo();
        }

        public UniqueAddress copy$default$3() {
            return this.ackReplyTo();
        }

        public String productPrefix() {
            return "SystemMessageEnvelope";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.message();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.seqNo());
                }
                case 2: {
                    return this.ackReplyTo();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SystemMessageEnvelope;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "message";
                }
                case 1: {
                    return "seqNo";
                }
                case 2: {
                    return "ackReplyTo";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.message()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ackReplyTo()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SystemMessageEnvelope)) return false;
            boolean bl = true;
            if (!bl) return false;
            SystemMessageEnvelope systemMessageEnvelope = (SystemMessageEnvelope)x$1;
            if (this.seqNo() != systemMessageEnvelope.seqNo()) return false;
            if (!BoxesRunTime.equals((Object)this.message(), (Object)systemMessageEnvelope.message())) return false;
            UniqueAddress uniqueAddress = this.ackReplyTo();
            UniqueAddress uniqueAddress2 = systemMessageEnvelope.ackReplyTo();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public SystemMessageEnvelope(Object message, long seqNo, UniqueAddress ackReplyTo) {
            this.message = message;
            this.seqNo = seqNo;
            this.ackReplyTo = ackReplyTo;
            Product.$init$((Product)this);
        }
    }
}

