/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.SelectChildName;
import org.apache.pekko.actor.SelectChildPattern;
import org.apache.pekko.actor.SelectParent$;
import org.apache.pekko.actor.SelectionPathElement;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0006\f\u0001YA\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\tU\u0001\u0011\t\u0011)A\u0005I!)1\u0006\u0001C\u0001Y!AA\u0002\u0001EC\u0002\u0013%\u0001\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003D\u0001\u0011%A\tC\u0003K\u0001\u0011%1\nC\u0003n\u0001\u0011\u0005aN\u0001\u000eNKN\u001c\u0018mZ3D_:$\u0018-\u001b8feN+'/[1mSj,'O\u0003\u0002\r\u001b\u0005i1/\u001a:jC2L'0\u0019;j_:T!AD\b\u0002\rI,Wn\u001c;f\u0015\t\u0001\u0012#A\u0003qK.\\wN\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001fA5\tqD\u0003\u0002\r\u001f%\u0011\u0011e\b\u0002\u000f\u0005\u0006\u001cXmU3sS\u0006d\u0017N_3s\u0003\u0019\u0019\u0018p\u001d;f[V\tA\u0005\u0005\u0002&Q5\taE\u0003\u0002(\u001f\u0005)\u0011m\u0019;pe&\u0011\u0011F\n\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q\u0011Qf\f\t\u0003]\u0001i\u0011a\u0003\u0005\u0006E\r\u0001\r\u0001J\u000b\u0002cA\u0011aDM\u0005\u0003g}\u0011QbU3sS\u0006d\u0017N_1uS>t\u0017aD5oG2,H-Z'b]&4Wm\u001d;\u0016\u0003Y\u0002\"\u0001G\u001c\n\u0005aJ\"a\u0002\"p_2,\u0017M\\\u0001\ti>\u0014\u0015N\\1ssR\u00111(\u0011\t\u00041qr\u0014BA\u001f\u001a\u0005\u0015\t%O]1z!\tAr(\u0003\u0002A3\t!!)\u001f;f\u0011\u0015\u0011e\u00011\u0001\u0018\u0003\ry'M[\u0001\u0013g\u0016\u0014\u0018.\u00197ju\u0016\u001cV\r\\3di&|g\u000e\u0006\u0002<\u000b\")ai\u0002a\u0001\u000f\u0006\u00191/\u001a7\u0011\u0005\u0015B\u0015BA%'\u0005U\t5\r^8s'\u0016dWm\u0019;j_:lUm]:bO\u0016\fABY;jY\u0012\u0004\u0016\r\u001e;fe:$2\u0001\u0014-i!\tiUK\u0004\u0002O%:\u0011q\nU\u0007\u0002\u001b%\u0011\u0011+D\u0001\u0011\u0007>tG/Y5oKJ4uN]7biNL!a\u0015+\u0002\u0013M+G.Z2uS>t'BA)\u000e\u0013\t1vKA\u0004Ck&dG-\u001a:\u000b\u0005M#\u0006\"B-\t\u0001\u0004Q\u0016aB7bi\u000eDWM\u001d\t\u00041mk\u0016B\u0001/\u001a\u0005\u0019y\u0005\u000f^5p]B\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001Y\r\u000e\u0003\u0005T!AY\u000b\u0002\rq\u0012xn\u001c;?\u0013\t!\u0017$\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013\u001a\u0011\u0015I\u0007\u00021\u0001k\u0003\r!\b/\u001a\t\u0003\u001d.L!\u0001\u001c+\u0003\u0017A\u000bG\u000f^3s]RK\b/Z\u0001\u000bMJ|WNQ5oCJLHcA\fpc\")\u0001/\u0003a\u0001w\u0005)!-\u001f;fg\")!/\u0003a\u0001g\u0006AQ.\u00198jM\u0016\u001cH\u000fE\u0002\u00197R\u0004$!\u001e>\u0011\u0007y3\b0\u0003\u0002xO\n)1\t\\1tgB\u0011\u0011P\u001f\u0007\u0001\t%Y\u0018/!A\u0001\u0002\u000b\u0005APA\u0002`IE\n2!`A\u0001!\tAb0\u0003\u0002\u00003\t9aj\u001c;iS:<\u0007c\u0001\r\u0002\u0004%\u0019\u0011QA\r\u0003\u0007\u0005s\u0017\u0010")
public class MessageContainerSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private int identifier;
    private volatile boolean bitmap$0;

    @Override
    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$(this);
    }

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        MessageContainerSerializer messageContainerSerializer = this;
        synchronized (messageContainerSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if (!this.bitmap$0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public byte[] toBinary(Object obj) {
        Object object = obj;
        if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage actorSelectionMessage = (ActorSelectionMessage)object;
            return this.serializeSelection(actorSelectionMessage);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Cannot serialize object of type [").append(obj.getClass().getName()).append("]").toString());
    }

    private byte[] serializeSelection(ActorSelectionMessage sel) {
        ContainerFormats.SelectionEnvelope.Builder builder = ContainerFormats.SelectionEnvelope.newBuilder();
        Object message = sel.msg();
        Serializer serializer = this.serialization().findSerializerFor(message);
        builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(message))).setSerializerId(serializer.identifier()).setWildcardFanOut(sel.wildcardFanOut());
        String ms = Serializers$.MODULE$.manifestFor(serializer, message);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms)) ? builder.setMessageManifest(ByteString.copyFromUtf8(ms)) : BoxedUnit.UNIT;
        sel.elements().foreach((Function1 & Serializable)x0$1 -> {
            SelectionPathElement selectionPathElement = x0$1;
            if (selectionPathElement instanceof SelectChildName) {
                SelectChildName selectChildName = (SelectChildName)selectionPathElement;
                String name = selectChildName.name();
                return builder.addPattern(this.buildPattern((Option<String>)new Some((Object)name), ContainerFormats.PatternType.CHILD_NAME));
            }
            if (selectionPathElement instanceof SelectChildPattern) {
                SelectChildPattern selectChildPattern = (SelectChildPattern)selectionPathElement;
                String patternStr = selectChildPattern.patternStr();
                return builder.addPattern(this.buildPattern((Option<String>)new Some((Object)patternStr), ContainerFormats.PatternType.CHILD_PATTERN));
            }
            if (SelectParent$.MODULE$.equals(selectionPathElement)) {
                return builder.addPattern(this.buildPattern((Option<String>)None$.MODULE$, ContainerFormats.PatternType.PARENT));
            }
            throw new MatchError((Object)selectionPathElement);
        });
        return builder.build().toByteArray();
    }

    private ContainerFormats.Selection.Builder buildPattern(Option<String> matcher, ContainerFormats.PatternType tpe) {
        ContainerFormats.Selection.Builder builder = ContainerFormats.Selection.newBuilder().setType(tpe);
        matcher.foreach((Function1 & Serializable)value -> builder.setMatcher((String)value));
        return builder;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        ContainerFormats.SelectionEnvelope selectionEnvelope = ContainerFormats.SelectionEnvelope.parseFrom(bytes);
        String manifest2 = selectionEnvelope.hasMessageManifest() ? selectionEnvelope.getMessageManifest().toStringUtf8() : "";
        Object msg = this.serialization().deserialize(selectionEnvelope.getEnclosedMessage().toByteArray(), selectionEnvelope.getSerializerId(), manifest2).get();
        Iterable elements = (Iterable)package$JavaConverters$.MODULE$.ListHasAsScala(selectionEnvelope.getPatternList()).asScala().iterator().map((Function1 & Serializable)x -> {
            ContainerFormats.PatternType patternType = x.getType();
            if (ContainerFormats.PatternType.CHILD_NAME.equals(patternType)) {
                return new SelectChildName(x.getMatcher());
            }
            if (ContainerFormats.PatternType.CHILD_PATTERN.equals(patternType)) {
                return new SelectChildPattern(x.getMatcher());
            }
            if (ContainerFormats.PatternType.PARENT.equals(patternType)) {
                return SelectParent$.MODULE$;
            }
            throw new MatchError((Object)patternType);
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
        boolean wildcardFanOut = selectionEnvelope.hasWildcardFanOut() ? selectionEnvelope.getWildcardFanOut() : false;
        return new ActorSelectionMessage(msg, (Iterable<SelectionPathElement>)elements, wildcardFanOut);
    }

    public MessageContainerSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$(this);
        BaseSerializer.$init$(this);
        Statics.releaseFence();
    }
}

