/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.kamon.instrumentation.pekko.remote.internal.remote;

import java.nio.ByteBuffer;
import kamon.Kamon$;
import kamon.context.BinaryPropagation;
import kamon.context.Context;
import kamon.instrumentation.context.HasContext;
import kamon.instrumentation.pekko.PekkoRemoteMetrics;
import kamon.instrumentation.pekko.PekkoRemoteMetrics$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.serialization.Serialization;

public final class SerializeForArteryAdvice$ {
    public static final SerializeForArteryAdvice$ MODULE$ = new SerializeForArteryAdvice$();

    @Advice.OnMethodEnter
    public long enter() {
        return System.nanoTime();
    }

    @Advice.OnMethodExit
    public void exit(@Advice.Argument(value=0) Serialization serialization, @Advice.Argument(value=1) OutboundEnvelope envelope, @Advice.Argument(value=3) EnvelopeBuffer envelopeBuffer, @Advice.Enter long startTime) {
        PekkoRemoteMetrics.SerializationInstruments instruments = PekkoRemoteMetrics$.MODULE$.serializationInstruments(serialization.system().name());
        ByteBuffer messageBuffer = envelopeBuffer.byteBuffer();
        Context context = ((HasContext)envelope).context();
        int positionBeforeContext = messageBuffer.position();
        if (context.nonEmpty()) {
            Kamon$.MODULE$.defaultBinaryPropagation().write(context, (Object)this.byteBufferWriter(messageBuffer));
        }
        instruments.serializationTime().record(System.nanoTime() - startTime);
        instruments.outboundMessageSize().record((long)positionBeforeContext);
        int contextSize = messageBuffer.position() - positionBeforeContext;
        messageBuffer.putInt(contextSize);
    }

    public BinaryPropagation.ByteStreamWriter byteBufferWriter(ByteBuffer bb) {
        return new BinaryPropagation.ByteStreamWriter(bb){
            private final ByteBuffer bb$1;

            public void write(byte[] bytes) {
                this.bb$1.put(bytes);
            }

            public void write(byte[] bytes, int offset, int count) {
                this.bb$1.put(bytes, offset, count);
            }

            public void write(int n) {
                this.bb$1.put((byte)n);
            }
            {
                this.bb$1 = bb$1;
            }
        };
    }

    private SerializeForArteryAdvice$() {
    }
}

