/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.cassandra.driver;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.QueryOperations$;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import kamon.Kamon$;
import kamon.instrumentation.cassandra.CassandraInstrumentation$;
import kamon.instrumentation.cassandra.driver.InstrumentedSession$;
import kamon.trace.Span;
import kamon.trace.Span$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001\u0002\r\u001a\u0001\tB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006e\u0001!\ta\r\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019)\u0005\u0001)A\u0005s!)a\t\u0001C!\u000f\")Q\u000b\u0001C!-\")q\u000b\u0001C!1\")A\f\u0001C!;\")1\u000f\u0001C\u0005i\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA5\u0001\u0011%\u00111N\u0004\b\u0003cJ\u0002\u0012AA:\r\u0019A\u0012\u0004#\u0001\u0002v!1!\u0007\u0006C\u0001\u0003{B\u0011\"a \u0015\u0005\u0004%\t!!!\t\u0011\u0005uE\u0003)A\u0005\u0003\u0007\u00131#\u00138tiJ,X.\u001a8uK\u0012\u001cVm]:j_:T!AG\u000e\u0002\r\u0011\u0014\u0018N^3s\u0015\taR$A\u0005dCN\u001c\u0018M\u001c3sC*\u0011adH\u0001\u0010S:\u001cHO];nK:$\u0018\r^5p]*\t\u0001%A\u0003lC6|gn\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013-\u001b\u0005)#B\u0001\u0014(\u0003\u0011\u0019wN]3\u000b\u0005iA#BA\u0015+\u0003!!\u0017\r^1ti\u0006D(\"A\u0016\u0002\u0007\r|W.\u0003\u0002.K\ty\u0011IY:ue\u0006\u001cGoU3tg&|g.\u0001\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\"\u0001\n\u0019\n\u0005E*#aB*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q2\u0004CA\u001b\u0001\u001b\u0005I\u0002\"\u0002\u0018\u0003\u0001\u0004y\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0003e\u0002\"AO\"\u000e\u0003mR!\u0001P\u001f\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002?\u007f\u0005!Q\u000f^5m\u0015\t\u0001\u0015)\u0001\u0004d_6lwN\u001c\u0006\u0003\u0005*\naaZ8pO2,\u0017B\u0001#<\u0005aa\u0015n\u001d;f]&tw-\u0012=fGV$xN]*feZL7-Z\u0001\nKb,7-\u001e;pe\u0002\n\u0011cZ3u\u0019><w-\u001a3LKf\u001c\b/Y2f)\u0005A\u0005CA%S\u001d\tQ\u0005\u000b\u0005\u0002L\u001d6\tAJ\u0003\u0002NC\u00051AH]8pizR\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u000ba\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KT\u0001\u0005S:LG\u000fF\u00010\u0003%Ig.\u001b;Bgft7\rF\u0001Z!\rQ$lL\u0005\u00037n\u0012\u0001\u0003T5ti\u0016t\u0017M\u00197f\rV$XO]3\u0002\u0019A\u0014X\r]1sK\u0006\u001b\u0018P\\2\u0015\u0007y\u0013G\rE\u0002;5~\u0003\"\u0001\n1\n\u0005\u0005,#!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\")1\r\u0003a\u0001\u0011\u0006)\u0011/^3ss\")Q\r\u0003a\u0001M\u0006i1-^:u_6\u0004\u0016-\u001f7pC\u0012\u0004BaZ6I[6\t\u0001N\u0003\u0002?S*\t!.\u0001\u0003kCZ\f\u0017B\u00017i\u0005\ri\u0015\r\u001d\t\u0003]Fl\u0011a\u001c\u0006\u0003a&\f1A\\5p\u0013\t\u0011xN\u0001\u0006CsR,')\u001e4gKJ\fqBY;jY\u0012\u001cE.[3oiN\u0003\u0018M\u001c\u000b\u0003kn\u0004\"A^=\u000e\u0003]T!\u0001_\u0010\u0002\u000bQ\u0014\u0018mY3\n\u0005i<(\u0001B*qC:DQ\u0001`\u0005A\u0002u\f\u0011b\u001d;bi\u0016lWM\u001c;\u0011\u0005\u0011r\u0018BA@&\u0005%\u0019F/\u0019;f[\u0016tG/\u0001\u0007fq\u0016\u001cW\u000f^3Bgft7\r\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001\u0013\u0002\b%\u0019\u0011\u0011B\u0013\u0003\u001fI+7/\u001e7u'\u0016$h)\u001e;ve\u0016DQ\u0001 \u0006A\u0002u\faD]3d_J$7\t\\5f]R\fV/\u001a:z\u000bb,7-\u001e;j_:LeNZ8\u0015\r\u0005E\u0011\u0011DA\u000f!\u0011\t\u0019\"!\u0006\u000e\u00039K1!a\u0006O\u0005\u0011)f.\u001b;\t\r\u0005m1\u00021\u0001v\u0003)\u0019G.[3oiN\u0003\u0018M\u001c\u0005\b\u0003?Y\u0001\u0019AA\u0011\u0003\u0019\u0011Xm];miB\u0019A%a\t\n\u0007\u0005\u0015REA\u0005SKN,H\u000e^*fi\u0006Q1\r\\8tK\u0006\u001b\u0018P\\2\u0015\u0005\u0005-\u0002c\u0001\u0013\u0002.%\u0019\u0011qF\u0013\u0003\u0017\rcwn]3GkR,(/Z\u0001\tSN\u001cEn\\:fIR\u0011\u0011Q\u0007\t\u0005\u0003'\t9$C\u0002\u0002:9\u0013qAQ8pY\u0016\fg.\u0001\u0006hKR\u001cE.^:uKJ$\"!a\u0010\u0011\u0007\u0011\n\t%C\u0002\u0002D\u0015\u0012qa\u00117vgR,'/\u0001\u0005hKR\u001cF/\u0019;f)\t\tI\u0005\u0005\u0003\u0002L\u0005Ecb\u0001\u0013\u0002N%\u0019\u0011qJ\u0013\u0002\u000fM+7o]5p]&!\u00111KA+\u0005\u0015\u0019F/\u0019;f\u0015\r\ty%J\u0001\rKb$(/Y2u#V,'/\u001f\u000b\u0004\u0011\u0006m\u0003\"\u0002?\u0011\u0001\u0004i\u0018\u0001F3yiJ\f7\r^*uCR,W.\u001a8u)f\u0004X\r\u0006\u0003\u0002b\u0005\u001d\u0004#BA\n\u0003GB\u0015bAA3\u001d\n1q\n\u001d;j_:DQaY\tA\u0002!\u000bQ#\u001e8tC\u001a,W\t\u001f;sC\u000e$X\t_3dkR|'\u000fF\u0002:\u0003[Ba!a\u001c\u0013\u0001\u0004y\u0013aB:fgNLwN\\\u0001\u0014\u0013:\u001cHO];nK:$X\rZ*fgNLwN\u001c\t\u0003kQ\u00192\u0001FA<!\u0011\t\u0019\"!\u001f\n\u0007\u0005mdJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003g\nA\u0003R7m'R\fG/Z7f]R\u0004&/\u001a4jq\u0016\u001cXCAAB!\u0019\t))a$\u0002\u00146\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0005j[6,H/\u00192mK*\u0019\u0011Q\u0012(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\u0006\u001d%aA*fiB!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a&\fA\u0001\\1oO&\u00191+a&\u0002+\u0011kGn\u0015;bi\u0016lWM\u001c;Qe\u00164\u0017\u000e_3tA\u0001")
public class InstrumentedSession
extends AbstractSession {
    private final Session underlying;
    private final ListeningExecutorService executor;

    public static Set<String> DmlStatementPrefixes() {
        return InstrumentedSession$.MODULE$.DmlStatementPrefixes();
    }

    private ListeningExecutorService executor() {
        return this.executor;
    }

    public String getLoggedKeyspace() {
        return this.underlying.getLoggedKeyspace();
    }

    public Session init() {
        return new InstrumentedSession(this.underlying.init());
    }

    public ListenableFuture<Session> initAsync() {
        return Futures.transform((ListenableFuture)this.underlying.initAsync(), (Function)new Function<Session, Session>(null){

            public Session apply(Session session) {
                return new InstrumentedSession(session);
            }
        }, (Executor)this.executor());
    }

    public ListenableFuture<PreparedStatement> prepareAsync(String query, Map<String, ByteBuffer> customPayload) {
        SimpleStatement statement = new SimpleStatement(query);
        statement.setOutgoingPayload(customPayload);
        return this.underlying.prepareAsync((RegularStatement)statement);
    }

    private Span buildClientSpan(Statement statement) {
        if (CassandraInstrumentation$.MODULE$.settings().enableTracing()) {
            String query = this.extractQuery(statement);
            Option<String> statementKind = this.extractStatementType(query);
            Span clientSpan = Kamon$.MODULE$.clientSpanBuilder(QueryOperations$.MODULE$.QueryOperationName(), "cassandra.driver").tagMetrics("cassandra.query.kind", (String)statementKind.getOrElse((Function0 & Serializable)() -> "other")).tag("db.statement", query).tag("db.type", "cassandra").start();
            Option$.MODULE$.apply((Object)statement.getKeyspace()).foreach((Function1 & Serializable)ks -> clientSpan.tag("db.instance", ks));
            return clientSpan;
        }
        return Span.Empty$.MODULE$;
    }

    public ResultSetFuture executeAsync(Statement statement) {
        Span clientSpan = this.buildClientSpan(statement);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ResultSetFuture)Kamon$.MODULE$.runWithContext(Kamon$.MODULE$.currentContext().withEntry(Span$.MODULE$.Key(), (Object)clientSpan), (Function0 & Serializable)() -> $this.underlying.executeAsync(statement)));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                clientSpan.fail(cause.getMessage(), cause);
                clientSpan.finish();
                throw cause;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        ResultSetFuture resultSetFuture = (ResultSetFuture)success.value();
        ResultSetFuture future = resultSetFuture;
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(this, clientSpan){
            private final /* synthetic */ InstrumentedSession $outer;
            private final Span clientSpan$2;

            public void onSuccess(ResultSet result) {
                this.$outer.kamon$instrumentation$cassandra$driver$InstrumentedSession$$recordClientQueryExecutionInfo(this.clientSpan$2, result);
                this.clientSpan$2.finish();
            }

            public void onFailure(Throwable cause) {
                this.clientSpan$2.fail(cause.getMessage(), cause).finish();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientSpan$2 = clientSpan$2;
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    public void kamon$instrumentation$cassandra$driver$InstrumentedSession$$recordClientQueryExecutionInfo(Span clientSpan, ResultSet result) {
        ExecutionInfo info = result.getExecutionInfo();
        boolean hasMore = !result.isFullyFetched();
        QueryTrace trace = info.getQueryTrace();
        Object object = trace != null ? clientSpan.tag("cassandra.driver.rs.trace-id", trace.getTraceId().toString()) : BoxedUnit.UNIT;
        ConsistencyLevel consistencyLevel = info.getAchievedConsistencyLevel();
        Object object2 = consistencyLevel != null ? clientSpan.tag("cassandra.driver.rs.consistency-level", consistencyLevel.name()) : BoxedUnit.UNIT;
        clientSpan.tag("cassandra.driver.rs.fetch-size", (long)info.getStatement().getFetchSize()).tag("cassandra.driver.rs.fetched", (long)result.getAvailableWithoutFetching()).tag("cassandra.driver.rs.has-more", hasMore);
    }

    public CloseFuture closeAsync() {
        return this.underlying.closeAsync();
    }

    public boolean isClosed() {
        return this.underlying.isClosed();
    }

    public Cluster getCluster() {
        return this.underlying.getCluster();
    }

    public Session.State getState() {
        return this.underlying.getState();
    }

    private String extractQuery(Statement statement2) {
        Statement statement3 = statement2;
        if (statement3 instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement3;
            return boundStatement.preparedStatement().getQueryString();
        }
        if (statement3 instanceof RegularStatement) {
            RegularStatement regularStatement = (RegularStatement)statement3;
            return regularStatement.getQueryString();
        }
        if (statement3 instanceof BatchStatement) {
            BatchStatement batchStatement = (BatchStatement)statement3;
            return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(batchStatement.getStatements()).asScala()).map((Function1 & Serializable)statement -> this.extractQuery((Statement)statement))).mkString(",");
        }
        return "unsupported-statement-type";
    }

    private Option<String> extractStatementType(String query) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> query.substring(0, query.indexOf(" ")).toLowerCase()).filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)InstrumentedSession.$anonfun$extractStatementType$2(elem))).toOption();
    }

    private ListeningExecutorService unsafeExtractExecutor(Session session) {
        Method executorMethod = Class.forName("com.datastax.driver.core.SessionManager").getDeclaredMethod("executor", new Class[0]);
        executorMethod.setAccessible(true);
        return (ListeningExecutorService)executorMethod.invoke((Object)session, new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$extractStatementType$2(String elem) {
        return InstrumentedSession$.MODULE$.DmlStatementPrefixes().contains((Object)elem);
    }

    public InstrumentedSession(Session underlying) {
        this.underlying = underlying;
        this.executor = this.unsafeExtractExecutor(underlying);
    }
}

