/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.apache.httpclient;

import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.apache.httpclient.ApacheHttpClientHelper;
import kamon.instrumentation.apache.httpclient.ApacheHttpClientInstrumentation;
import kamon.instrumentation.context.HasContext;
import kamon.instrumentation.http.HttpClientInstrumentation;
import kamon.instrumentation.http.HttpMessage;
import kamon.trace.Span;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class UriRequestAdvisor {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnter(@Advice.Argument(value=0, readOnly=false) HttpUriRequest httpUriRequest, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpUriRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        if (((HasContext)httpUriRequest).context().nonEmpty()) {
            return;
        }
        Context context = Kamon.currentContext();
        HttpMessage.RequestBuilder<HttpUriRequest> requestBuilder = ApacheHttpClientHelper.toRequestBuilder(httpUriRequest);
        requestHandler = ApacheHttpClientInstrumentation.httpClientInstrumentation().createHandler(requestBuilder, context);
        Context context2 = context.withEntry(Span.Key(), (Object)requestHandler.span());
        scope = Kamon.storeContext((Context)context2);
        httpUriRequest = requestHandler.request();
        ((HasContext)httpUriRequest).setContext(context2);
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void onExit(@Advice.Return HttpResponse httpResponse, @Advice.Thrown Throwable throwable, @Advice.Local(value="handler") HttpClientInstrumentation.RequestHandler<HttpUriRequest> requestHandler, @Advice.Local(value="scope") Storage.Scope scope) {
        if (scope == null) {
            return;
        }
        ApacheHttpClientInstrumentation.processResponse(requestHandler, httpResponse, throwable);
        scope.close();
    }
}

