/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.ClassLoading$;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.JdbcInstrumentation;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class JdbcInstrumentation$
implements LoggingSupport {
    public static final JdbcInstrumentation$ MODULE$ = new JdbcInstrumentation$();
    private static volatile JdbcInstrumentation.Settings _settings;
    private static Logger logger;

    static {
        LoggingSupport.$init$(MODULE$);
        _settings = MODULE$.readSettings(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable)newConfig -> {
            JdbcInstrumentation$.MODULE$._settings_$eq(JdbcInstrumentation$.MODULE$.readSettings(newConfig));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport.logInfo$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport.logWarn$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport.logError$(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport.logTrace$(this, msg);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private JdbcInstrumentation.Settings _settings() {
        return _settings;
    }

    private void _settings_$eq(JdbcInstrumentation.Settings x$1) {
        _settings = x$1;
    }

    public void onStatementFinish(String statement, long elapsedTimeNanos) {
        if (elapsedTimeNanos >= this._settings().slowStatementThresholdNanos()) {
            this._settings().slowStatementProcessors().foreach((Function1 & Serializable)x$1 -> {
                x$1.process(statement, elapsedTimeNanos, JdbcInstrumentation$.MODULE$._settings().slowStatementThresholdNanos());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void onStatementFailure(String statement, Throwable error) {
        this._settings().failedStatementProcessors().foreach((Function1 & Serializable)x$2 -> {
            x$2.process(statement, error);
            return BoxedUnit.UNIT;
        });
    }

    private JdbcInstrumentation.Settings readSettings(Config config) {
        Config jdbcConfig = config.getConfig("kamon.instrumentation.jdbc");
        List slowStatementProcessors = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(jdbcConfig.getStringList("statements.slow.processors")).asScala()).map((Function1 & Serializable)fqcn -> (JdbcInstrumentation.SlowStatementProcessor)ClassLoading$.MODULE$.createInstance(fqcn, ClassTag$.MODULE$.apply(JdbcInstrumentation.SlowStatementProcessor.class)))).toList();
        List failedStatementProcessors = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(jdbcConfig.getStringList("statements.failed.processors")).asScala()).map((Function1 & Serializable)fqcn -> (JdbcInstrumentation.FailedStatementProcessor)ClassLoading$.MODULE$.createInstance(fqcn, ClassTag$.MODULE$.apply(JdbcInstrumentation.FailedStatementProcessor.class)))).toList();
        return new JdbcInstrumentation.Settings(jdbcConfig.getDuration("statements.slow.threshold").toNanos(), (List<JdbcInstrumentation.SlowStatementProcessor>)slowStatementProcessors, (List<JdbcInstrumentation.FailedStatementProcessor>)failedStatementProcessors);
    }

    private JdbcInstrumentation$() {
    }
}

