/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.mongo;

import com.mongodb.MongoNamespace;
import com.mongodb.internal.async.SingleResultCallback;
import kamon.instrumentation.context.HasContext;
import kamon.instrumentation.mongo.MongoClientInstrumentation;
import kamon.trace.Span;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public class AsyncBatchCursorGetMoreAdvice {
    @Advice.OnMethodEnter
    public static <T> void enter(@Advice.This Object object, @Advice.FieldValue(value="namespace") MongoNamespace mongoNamespace, @Advice.Argument(value=2, readOnly=false) SingleResultCallback<T> singleResultCallback) {
        Span span = (Span)((HasContext)object).context().get(Span.Key());
        Span span2 = MongoClientInstrumentation.getMoreSpanBuilder(span, mongoNamespace).start();
        singleResultCallback = AsyncBatchCursorGetMoreAdvice.spanCompletingCallback(singleResultCallback, span2);
    }

    public static <T> SingleResultCallback<T> spanCompletingCallback(final SingleResultCallback<T> singleResultCallback, final Span span) {
        return new SingleResultCallback<T>(){

            public void onResult(T t, Throwable throwable) {
                try {
                    if (throwable == null) {
                        span.finish();
                    } else {
                        span.fail(throwable).finish();
                    }
                }
                finally {
                    singleResultCallback.onResult(t, throwable);
                }
            }
        };
    }
}

