/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.finagle.client;

import com.twitter.finagle.tracing.Annotation;
import com.twitter.finagle.tracing.Record;
import com.twitter.finagle.tracing.TraceId;
import com.twitter.finagle.tracing.Tracer;
import java.io.Serializable;
import java.net.InetSocketAddress;
import kamon.instrumentation.finagle.client.BroadcastRequestHandler$;
import kamon.instrumentation.finagle.client.Tags$;
import kamon.instrumentation.finagle.client.Tags$Keys$;
import kamon.trace.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005E3AAB\u0004\u0003!!)!\u0005\u0001C\u0001G!Aa\u0005\u0001EC\u0002\u0013\u0005q\u0005C\u00031\u0001\u0011\u0005\u0013\u0007C\u0003:\u0001\u0011%!\bC\u0003E\u0001\u0011\u0005SI\u0001\nLC6|gNR5oC\u001edW\r\u0016:bG\u0016\u0014(B\u0001\u0005\n\u0003\u0019\u0019G.[3oi*\u0011!bC\u0001\bM&t\u0017m\u001a7f\u0015\taQ\"A\bj]N$(/^7f]R\fG/[8o\u0015\u0005q\u0011!B6b[>t7\u0001A\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u0019A5\t\u0011D\u0003\u0002\u001b7\u00059AO]1dS:<'B\u0001\u0006\u001d\u0015\tib$A\u0004uo&$H/\u001a:\u000b\u0003}\t1aY8n\u0013\t\t\u0013D\u0001\u0004Ue\u0006\u001cWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u0003\u001d\t1\u0001\\8h+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005i\u0013aA8sO&\u0011qF\u000b\u0002\u0007\u0019><w-\u001a:\u0002\rI,7m\u001c:e)\t\u0011T\u0007\u0005\u0002\u0013g%\u0011Ag\u0005\u0002\u0005+:LG\u000fC\u00031\u0007\u0001\u0007a\u0007\u0005\u0002\u0019o%\u0011\u0001(\u0007\u0002\u0007%\u0016\u001cwN\u001d3\u0002\u0019I,7m\u001c:e)>\u001c\u0006/\u00198\u0015\u0007IZD\bC\u00031\t\u0001\u0007a\u0007C\u0003>\t\u0001\u0007a(\u0001\u0003ta\u0006t\u0007CA C\u001b\u0005\u0001%BA!\u000e\u0003\u0015!(/Y2f\u0013\t\u0019\u0005I\u0001\u0003Ta\u0006t\u0017aC:b[BdW\r\u0016:bG\u0016$\"A\u0012'\u0011\u0007I9\u0015*\u0003\u0002I'\t1q\n\u001d;j_:\u0004\"A\u0005&\n\u0005-\u001b\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001b\u0016\u0001\rAT\u0001\biJ\f7-Z%e!\tAr*\u0003\u0002Q3\t9AK]1dK&#\u0007")
public final class KamonFinagleTracer
implements Tracer {
    private Logger log;
    private volatile boolean bitmap$0;

    public boolean isNull() {
        return Tracer.isNull$((Tracer)this);
    }

    public boolean isActivelyTracing(TraceId traceId) {
        return Tracer.isActivelyTracing$((Tracer)this, (TraceId)traceId);
    }

    private Logger log$lzycompute() {
        KamonFinagleTracer kamonFinagleTracer = this;
        synchronized (kamonFinagleTracer) {
            if (!this.bitmap$0) {
                this.log = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public void record(Record record) {
        BroadcastRequestHandler$.MODULE$.get().fold((Function0 & Serializable)() -> package$.MODULE$.error("There must be a BroadcastRequestHandler defined!"), (Function1 & Serializable)requestHandler -> {
            this.recordToSpan(record, requestHandler.span());
            return BoxedUnit.UNIT;
        });
    }

    private void recordToSpan(Record record, Span span) {
        boolean bl = false;
        Annotation.BinaryAnnotation binaryAnnotation = null;
        Annotation annotation = record.annotation();
        if (annotation instanceof Annotation.Rpc) {
            Annotation.Rpc rpc = (Annotation.Rpc)annotation;
            String name = rpc.name();
            span.tag(Tags$Keys$.MODULE$.ResourceName(), name);
            return;
        }
        if (annotation instanceof Annotation.Message) {
            Annotation.Message message = (Annotation.Message)annotation;
            String msg = message.content();
            span.tag("message", msg);
            return;
        }
        if (annotation instanceof Annotation.BinaryAnnotation) {
            bl = true;
            binaryAnnotation = (Annotation.BinaryAnnotation)annotation;
            String name = binaryAnnotation.key();
            Object s2 = binaryAnnotation.value();
            if (s2 instanceof String) {
                String string = (String)s2;
                span.tag(name, string);
                return;
            }
        }
        if (bl) {
            String name = binaryAnnotation.key();
            Object i = binaryAnnotation.value();
            if (i instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)i);
                span.tag(name, (long)n);
                return;
            }
        }
        if (bl) {
            String name = binaryAnnotation.key();
            Object i = binaryAnnotation.value();
            if (i instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)i);
                span.tag(name, l);
                return;
            }
        }
        if (bl) {
            String name = binaryAnnotation.key();
            Object b = binaryAnnotation.value();
            if (b instanceof Boolean) {
                boolean bl2 = BoxesRunTime.unboxToBoolean((Object)b);
                span.tag(name, bl2);
                return;
            }
        }
        if (bl) {
            String name = binaryAnnotation.key();
            Object t = binaryAnnotation.value();
            if (t instanceof Throwable) {
                Throwable throwable = (Throwable)t;
                span.fail(name, throwable);
                return;
            }
        }
        if (bl) {
            String name = binaryAnnotation.key();
            Object other = binaryAnnotation.value();
            span.tag(name, other.toString());
            return;
        }
        if (Annotation.WireSend$.MODULE$.equals(annotation)) {
            Tags$.MODULE$.mark(span, "wire/send", record.timestamp());
            return;
        }
        if (Annotation.WireRecv$.MODULE$.equals(annotation)) {
            Tags$.MODULE$.mark(span, "wire/recv", record.timestamp());
            return;
        }
        if (annotation instanceof Annotation.WireRecvError) {
            Annotation.WireRecvError wireRecvError = (Annotation.WireRecvError)annotation;
            String msg = wireRecvError.error();
            Tags$.MODULE$.fail(span, "wire/recv_error", msg, record.timestamp());
            return;
        }
        if (annotation instanceof Annotation.ClientAddr) {
            Annotation.ClientAddr clientAddr = (Annotation.ClientAddr)annotation;
            InetSocketAddress addr = clientAddr.ia();
            Tags$.MODULE$.setPeer(span, addr);
            return;
        }
        if (Annotation.ClientSend$.MODULE$.equals(annotation)) {
            Tags$.MODULE$.mark(span, "client/send", record.timestamp());
            return;
        }
        if (Annotation.ClientRecv$.MODULE$.equals(annotation)) {
            Tags$.MODULE$.mark(span, "client/recv", record.timestamp());
            return;
        }
        if (annotation instanceof Annotation.ClientRecvError) {
            Annotation.ClientRecvError clientRecvError = (Annotation.ClientRecvError)annotation;
            String msg = clientRecvError.error();
            Tags$.MODULE$.fail(span, "client/recv_error", msg, record.timestamp());
            return;
        }
        if (annotation instanceof Annotation.ServerAddr) {
            Annotation.ServerAddr serverAddr = (Annotation.ServerAddr)annotation;
            InetSocketAddress addr = serverAddr.ia();
            Tags$.MODULE$.setPeer(span, addr);
            return;
        }
        if (Annotation.ServerRecv$.MODULE$.equals(annotation)) {
            Tags$.MODULE$.mark(span, "server/recv", record.timestamp());
            return;
        }
        if (Annotation.ServerSend$.MODULE$.equals(annotation)) {
            Tags$.MODULE$.mark(span, "server/send", record.timestamp());
            return;
        }
        if (annotation instanceof Annotation.ServerSendError) {
            Annotation.ServerSendError serverSendError = (Annotation.ServerSendError)annotation;
            String msg = serverSendError.error();
            Tags$.MODULE$.fail(span, "server/send_error", msg, record.timestamp());
            return;
        }
        if (annotation instanceof Annotation.LocalAddr) {
            Annotation.LocalAddr localAddr = (Annotation.LocalAddr)annotation;
            InetSocketAddress addr = localAddr.ia();
            span.tag("local.hostname", addr.getHostString()).tag("local.port", (long)addr.getPort());
            return;
        }
        if (annotation instanceof Annotation.ServiceName) {
            Annotation.ServiceName serviceName = (Annotation.ServiceName)annotation;
            String name = serviceName.service();
            span.tag("finagle.service_name", name);
            return;
        }
        this.log().debug(new StringBuilder(30).append("dropping unhandled annotation ").append(annotation).toString());
    }

    public Option<Object> sampleTrace(TraceId traceId) {
        return traceId.sampled();
    }

    public KamonFinagleTracer() {
        Tracer.$init$((Tracer)this);
    }
}

